/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.web.util;

import eu.bitwalker.useragentutils.Browser;
import eu.bitwalker.useragentutils.DeviceType;
import eu.bitwalker.useragentutils.UserAgent;
import javax.servlet.http.HttpServletRequest;

public final class UserAgentUtil {
    public static UserAgent getUserAgent(HttpServletRequest request) {
        return UserAgent.parseUserAgentString(request.getHeader("User-Agent"));
    }

    public static DeviceType getDeviceType(HttpServletRequest request) {
        return UserAgentUtil.getUserAgent(request).getOperatingSystem().getDeviceType();
    }

    public static boolean isComputer(HttpServletRequest request) {
        return DeviceType.COMPUTER.equals((Object)UserAgentUtil.getDeviceType(request));
    }

    public static boolean isMobile(HttpServletRequest request) {
        return DeviceType.MOBILE.equals((Object)UserAgentUtil.getDeviceType(request));
    }

    public static boolean isTablet(HttpServletRequest request) {
        return DeviceType.TABLET.equals((Object)UserAgentUtil.getDeviceType(request));
    }

    public static boolean isMobileOrTablet(HttpServletRequest request) {
        DeviceType deviceType = UserAgentUtil.getDeviceType(request);
        return DeviceType.MOBILE.equals((Object)deviceType) || DeviceType.TABLET.equals((Object)deviceType);
    }

    public static Browser getBrowser(HttpServletRequest request) {
        return UserAgentUtil.getUserAgent(request).getBrowser();
    }

    public static boolean isLteIE8(HttpServletRequest request) {
        Browser browser = UserAgentUtil.getBrowser(request);
        return Browser.IE5.equals((Object)browser) || Browser.IE6.equals((Object)browser) || Browser.IE7.equals((Object)browser) || Browser.IE8.equals((Object)browser);
    }
}

