/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.web.util;

import cn.dolphin.core.exception.ParamRuntimeException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.UriUtils;

public class UrlUtil
extends UriUtils {
    private static final Logger log = LoggerFactory.getLogger(UrlUtil.class);

    public static String encodeURL(String source, Charset charset) {
        return UrlUtil.encode((String)source, (String)charset.name());
    }

    public static String decodeURL(String source, Charset charset) {
        return UrlUtil.decode((String)source, (String)charset.name());
    }

    public static String getPath(String uriStr) {
        URI uri;
        try {
            uri = new URI(uriStr);
        }
        catch (URISyntaxException var3) {
            throw new RuntimeException(var3);
        }
        return uri.getPath();
    }

    public static final String encode(String url) {
        if (StringUtils.isBlank((CharSequence)url)) {
            return "";
        }
        try {
            url = URLEncoder.encode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return url;
    }

    public static final String decode(String url) {
        if (StringUtils.isBlank((CharSequence)url)) {
            return "";
        }
        try {
            url = URLDecoder.decode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return url;
    }

    public static final Map<String, String> parseUrlParamsToMap(String urlParams) {
        String[] split;
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        if (StringUtils.isBlank((CharSequence)urlParams)) {
            return map;
        }
        urlParams = UrlUtil.decode(urlParams);
        for (String s : split = urlParams.split("&")) {
            String[] split2 = s.split("=");
            if (split2.length == 2) {
                map.put(split2[0], split2[1]);
                continue;
            }
            map.put(split2[0], "");
        }
        return map;
    }

    public static final String parseMapToUrlParams(Map<String, String> map) {
        if (map == null) {
            return "";
        }
        int size = map.size();
        if (size == 0) {
            return "";
        }
        int i = 0;
        StringBuilder sd = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            sd.append(entry.getKey() + "=" + entry.getValue());
            if (i == size - 1) continue;
            sd.append("&");
        }
        return sd.toString();
    }

    public static final URL getUrl(String url) {
        if (StringUtils.isBlank((CharSequence)url)) {
            throw ParamRuntimeException.NULL;
        }
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw ParamRuntimeException.ERROR;
        }
    }

    public static final String getUrlProtocol(String url) {
        URL u = UrlUtil.getUrl(url);
        return u == null ? "" : u.getProtocol();
    }

    public static final String getUrlHost(String url) {
        URL u = UrlUtil.getUrl(url);
        return u == null ? "" : u.getHost();
    }

    public static final String getDomain(String url) {
        if ((url = UrlUtil.getUrlHost(url)).equals("")) {
            return "";
        }
        String[] split = url.split("\\.");
        int len = split.length;
        if (len == 1 || len == 2) {
            return url;
        }
        return split[len - 2] + "." + split[len - 1];
    }

    public static final String getUrlUP(String url) {
        URL u = UrlUtil.getUrl(url);
        return u == null ? "" : u.getFile();
    }

    public static final String getUrlURI(String url) {
        URL u = UrlUtil.getUrl(url);
        return u == null ? "" : u.getPath();
    }

    public static final String getUrlParam(String url) {
        URL u = UrlUtil.getUrl(url);
        return u == null ? "" : u.getQuery();
    }

    public static String setParmas(String path, Map<String, String> map, String charset) throws Exception {
        String result = "";
        boolean hasParams = false;
        if (path != null && !"".equals(path) && MapUtils.isNotEmpty(map)) {
            StringBuilder builder = new StringBuilder();
            Set<Map.Entry<String, String>> params = map.entrySet();
            for (Map.Entry<String, String> entry : params) {
                String key = entry.getKey().trim();
                String value = entry.getValue().trim();
                if (hasParams) {
                    builder.append("&");
                } else {
                    hasParams = true;
                }
                if (charset != null && !"".equals(charset)) {
                    builder.append(key).append("=").append(URLEncoder.encode(value, charset));
                    continue;
                }
                builder.append(key).append("=").append(value);
            }
            result = builder.toString();
        }
        return UrlUtil.doUrlPath(path, result).toString();
    }

    private static URL doUrlPath(String path, String query) throws Exception {
        URL url = new URL(path);
        if (StringUtils.isEmpty((CharSequence)path)) {
            return url;
        }
        path = StringUtils.isEmpty((CharSequence)url.getQuery()) ? (path.endsWith("?") ? path + query : path + "?" + query) : (path.endsWith("&") ? path + query : path + "&" + query);
        return new URL(path);
    }

    public static void main(String[] args) throws Exception {
        System.out.println(URLEncoder.encode("\u7591\u95ee2(1).gif", "UTF-8"));
    }
}

