/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.web.util;

import cn.dolphin.core.exception.IoRuntimeException;
import cn.dolphin.core.result.ApiResult;
import cn.dolphin.core.util.Utf8Util;
import cn.dolphin.core.web.util.RequestUtil;
import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpStatus;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class ResponseUtil {
    private static final String DOWN_TYPE = "applicatoin/octet-stream";
    private static final String DOWN_HEADER1 = "Content-Disposition";
    private static final String DOWN_HEADER2 = "attachment; filename=";
    private static final String EXCEL_TYPE = "application/vnd.ms-excel;charset=utf-8";
    public static final String CACHE_CONTROL = "Cache-Control";
    public static final String NO_CACHE = "no-cache";
    public static final String PRAGMA = "Pragma";
    public static final String EXPIRESS = "Expires";
    public static final String FORWARD = "forward:";
    public static final String REDIRECT = "redirect:";

    private ResponseUtil() {
    }

    public static HttpServletResponse getResponse() {
        return ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getResponse();
    }

    public static final void setDownloadHeader(HttpServletResponse response, String fileName) {
        response.reset();
        response.setContentType(DOWN_TYPE);
        response.setHeader(DOWN_HEADER1, DOWN_HEADER2 + Utf8Util.utf2iso(fileName));
    }

    public static final void setNocachHeader(HttpServletResponse response) {
        response.reset();
        response.setHeader(PRAGMA, NO_CACHE);
        response.setHeader(CACHE_CONTROL, NO_CACHE);
        response.setDateHeader(EXPIRESS, 0L);
    }

    public static final void setExcelHeader(HttpServletResponse response, String fileName) {
        response.reset();
        response.setContentType(EXCEL_TYPE);
        response.setHeader(DOWN_HEADER1, DOWN_HEADER2 + Utf8Util.utf2iso(fileName));
    }

    public static final void response(String text) {
        ResponseUtil.response(ResponseUtil.getResponse(), text);
    }

    public static final void response(HttpServletResponse response, String text) {
        ResponseUtil.cors(response, null);
        response.setStatus(HttpStatus.OK.value());
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        PrintWriter writer = null;
        try {
            writer = response.getWriter();
            writer.write(text);
        }
        catch (IOException e) {
            throw new IoRuntimeException("\u53d1\u9001JSON\u54cd\u5e94\u5931\u8d25", e);
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }

    public static final void responseText(String text) {
        ResponseUtil.responseText(ResponseUtil.getResponse(), text);
    }

    public static final void responseText(HttpServletResponse response, String text) {
        try {
            response.getWriter().write(text);
            response.getWriter().flush();
        }
        catch (IOException e) {
            throw new IoRuntimeException("\u53d1\u9001\u6587\u5b57\u54cd\u5e94\u5931\u8d25", e);
        }
        finally {
            try {
                response.getWriter().close();
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }

    public static final String forward(String url) {
        return FORWARD + url;
    }

    public static final void sendForward(HttpServletRequest request, HttpServletResponse response, String url) {
        try {
            request.getRequestDispatcher(url).forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (IOException | ServletException e) {
            throw new IoRuntimeException("\u8f6c\u53d1\u5931\u8d25\uff1aurl = " + url, e);
        }
    }

    public static final void sendForward(String url) {
        ResponseUtil.sendForward(RequestUtil.getRequest(), ResponseUtil.getResponse(), url);
    }

    public static final String redirect(String url) {
        return REDIRECT + url;
    }

    public static final void sendRedirect(HttpServletResponse response, String url) {
        try {
            response.sendRedirect(url);
        }
        catch (IOException e) {
            throw new IoRuntimeException("\u91cd\u5b9a\u5411\u5931\u8d25\uff1aurl = " + url, e);
        }
    }

    public static final void sendRedirect(String url) {
        ResponseUtil.sendRedirect(ResponseUtil.getResponse(), url);
    }

    public static final void responseFile(byte[] bs, String fileName) {
        ResponseUtil.responseFile(bs, fileName, ResponseUtil.getResponse());
    }

    public static final void responseFile(byte[] bs, String fileName, HttpServletResponse response) {
        ResponseUtil.setDownloadHeader(response, fileName);
        ServletOutputStream output = null;
        try {
            output = response.getOutputStream();
            output.write(bs);
            output.flush();
        }
        catch (IOException e) {
            throw new IoRuntimeException("\u53d1\u9001\u6587\u4ef6\u54cd\u5e94\u5931\u8d25", e);
        }
        finally {
            try {
                output.close();
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }

    public static final void cors(HttpServletResponse response, String origin) {
        if (StringUtils.isBlank((CharSequence)response.getHeader("Access-Control-Allow-Origin"))) {
            response.setHeader("Access-Control-Allow-Origin", origin == null ? "*" : origin);
        }
    }

    public static final void sse() {
        ResponseUtil.getResponse().setHeader("X-Accel-Buffering", "no");
    }

    public static void errorToken(HttpServletResponse httpResponse, String msg) throws IOException {
        ApiResult result = ApiResult.error(msg);
        String json = JSON.toJSONString((Object)result);
        httpResponse.setCharacterEncoding("UTF-8");
        httpResponse.setContentType("application/json;charset=UTF-8");
        httpResponse.setHeader("Content-type", "application/json;charset=UTF-8");
        httpResponse.setHeader("Access-Control-Allow-Origin", "*");
        httpResponse.setStatus(401);
        httpResponse.getWriter().write(json);
    }

    public static void errorToken(HttpServletResponse httpResponse, String code, String msg) throws IOException {
        ApiResult result = ApiResult.error(code, msg);
        String json = JSON.toJSONString((Object)result);
        httpResponse.setCharacterEncoding("UTF-8");
        httpResponse.setContentType("application/json;charset=UTF-8");
        httpResponse.setHeader("Content-type", "application/json;charset=UTF-8");
        httpResponse.setHeader("Access-Control-Allow-Origin", "*");
        httpResponse.setStatus(401);
        httpResponse.getWriter().write(json);
    }

    public static void errorAuth(HttpServletResponse httpResponse, String code, String msg) throws IOException {
        ApiResult result = ApiResult.error(code, msg);
        String json = JSON.toJSONString((Object)result);
        httpResponse.setCharacterEncoding("UTF-8");
        httpResponse.setContentType("application/json;charset=UTF-8");
        httpResponse.setHeader("Content-type", "application/json;charset=UTF-8");
        httpResponse.setHeader("Access-Control-Allow-Origin", "*");
        httpResponse.setStatus(401);
        httpResponse.getWriter().write(json);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void responseData(HttpServletResponse response, Object resData) throws JsonProcessingException {
        ObjectMapper objectMapper = new ObjectMapper();
        String jsonString = objectMapper.writeValueAsString(resData);
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json; charset=utf-8");
        try (PrintWriter out = null;){
            out = response.getWriter();
            out.append(jsonString);
        }
    }
}

