/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.web.util;

import cn.dolphin.core.exception.IoRuntimeException;
import cn.dolphin.core.spring.SpringContextUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.ResourceUtils;

public class ResourceUtil {
    private static final Logger log = LoggerFactory.getLogger(ResourceUtil.class);

    public static String getText(String msgKey, Object arg, Locale local) {
        MessageSource messageSource = SpringContextUtil.getBean(MessageSource.class);
        return messageSource.getMessage(msgKey, new Object[]{arg}, local);
    }

    public static String getText(String msgKey, Object[] args, Locale local) {
        MessageSource messageSource = SpringContextUtil.getBean(MessageSource.class);
        return messageSource.getMessage(msgKey, args, local);
    }

    public static InputStream getIns(String path) {
        ClassPathResource classPathResource = new ClassPathResource(path);
        try {
            return classPathResource.getInputStream();
        }
        catch (IOException e) {
            log.warn("\u8bfb\u53d6\u6587\u4ef6 classpath:{}\u5931\u8d25\uff1a{}", (Object)path, (Object)e.getMessage());
            return null;
        }
    }

    public static File getFile(String path) {
        try {
            return ResourceUtils.getFile((String)("classpath:" + path));
        }
        catch (FileNotFoundException e) {
            log.warn("\u8bfb\u53d6\u6587\u4ef6 classpath:{}\u5931\u8d25\uff1a{}", (Object)path, (Object)e.getMessage());
            return null;
        }
    }

    public static Resource getResource(String path) {
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        Resource resource = resolver.getResource("classpath:" + path);
        boolean exists = resource.exists();
        if (!exists) {
            log.warn("\u672a\u627e\u5230\u914d\u7f6e\u6587\u4ef6 classpath:" + path);
            return null;
        }
        return resource;
    }

    public static final String readStr(String path) {
        Resource resource = ResourceUtil.getResource(path);
        if (resource == null) {
            return null;
        }
        InputStream inputStream = null;
        BufferedReader br = null;
        try {
            inputStream = resource.getInputStream();
            br = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            StringBuilder sb = new StringBuilder();
            String line = "";
            while ((line = br.readLine()) != null) {
                if ((line = StringUtils.trimToEmpty((String)line)).equals("") || line.startsWith("#")) continue;
                sb.append(line);
            }
            String string = sb.toString();
            return string;
        }
        catch (IOException e) {
            throw new IoRuntimeException("\u8bfb\u53d6\u8d44\u6e90\u5931\u8d25\uff1aclasspath:" + path, e);
        }
        finally {
            try {
                inputStream.close();
                br.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static final ArrayList<String> readList(String path) {
        Resource resource = ResourceUtil.getResource(path);
        if (resource == null) {
            return null;
        }
        InputStream inputStream = null;
        BufferedReader br = null;
        try {
            inputStream = resource.getInputStream();
            br = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            ArrayList<String> list = new ArrayList<String>();
            String line = "";
            while ((line = br.readLine()) != null) {
                if ((line = StringUtils.trimToEmpty((String)line)).equals("") || line.startsWith("#")) continue;
                list.add(line);
            }
            ArrayList<String> arrayList = list;
            return arrayList;
        }
        catch (IOException e) {
            throw new IoRuntimeException("\u8bfb\u53d6\u8d44\u6e90\u5931\u8d25\uff1aclasspath:" + path, e);
        }
        finally {
            try {
                inputStream.close();
                br.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static final HashSet<String> readSet(String path) {
        Resource resource = ResourceUtil.getResource(path);
        if (resource == null) {
            return null;
        }
        InputStream inputStream = null;
        BufferedReader br = null;
        try {
            inputStream = resource.getInputStream();
            br = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            HashSet<String> set = new HashSet<String>();
            String line = "";
            while ((line = br.readLine()) != null) {
                if ((line = StringUtils.trimToEmpty((String)line)).equals("") || line.startsWith("#")) continue;
                set.add(line);
            }
            HashSet<String> hashSet = set;
            return hashSet;
        }
        catch (IOException e) {
            throw new IoRuntimeException("\u8bfb\u53d6\u8d44\u6e90\u5931\u8d25\uff1aclasspath:" + path, e);
        }
        finally {
            try {
                inputStream.close();
                br.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static final HashMap<String, String> readMap(String path) {
        Resource resource = ResourceUtil.getResource(path);
        if (resource == null) {
            return null;
        }
        InputStream inputStream = null;
        BufferedReader br = null;
        try {
            inputStream = resource.getInputStream();
            br = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            HashMap<String, String> map = new HashMap<String, String>();
            String line = "";
            String[] lines = null;
            while ((line = br.readLine()) != null) {
                if ((line = StringUtils.trimToEmpty((String)line)).equals("") || line.startsWith("#")) continue;
                lines = line.split("=");
                map.put(lines[0], lines.length > 1 ? lines[1] : null);
            }
            HashMap<String, String> hashMap = map;
            return hashMap;
        }
        catch (IOException e) {
            throw new IoRuntimeException("\u8bfb\u53d6\u8d44\u6e90\u5931\u8d25\uff1aclasspath:" + path, e);
        }
        finally {
            try {
                inputStream.close();
                br.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

