/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.web.util;

import cn.dolphin.core.date.DateFormatUtil;
import cn.dolphin.core.ip.IPUtil;
import cn.dolphin.core.util.BeanUtil;
import cn.dolphin.core.util.StrUtil;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.ParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

public class RequestUtil {
    private static Logger logger = LoggerFactory.getLogger(RequestUtil.class);
    public static final String RT_HEADER = "X-Requested-With";
    public static final String AJAX_RT = "XMLHttpRequest";
    public static final String RETURNURL = "returnUrl";
    public static final String TOKEN = "token";
    public static final String AUTHORIZATION = "Authorization";

    private RequestUtil() {
    }

    public static HttpServletRequest getRequest() {
        return ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
    }

    public static void setHeader(HttpServletRequest request, HttpServletResponse response) {
        response.setHeader("Access-control-Allow-Origin", request.getHeader("Origin"));
        response.setHeader("Access-Control-Allow-Methods", "POST,GET,OPTIONS,DELETE,PUT");
        response.setHeader("Access-Control-Allow-Credentials", "false");
        response.setHeader("Access-Control-Allow-Headers", "*");
        response.setHeader("Access-Control-Max-Age", "3600");
        response.setHeader("Content-Type", "application/json;charset=UTF-8");
        response.setStatus(HttpStatus.OK.value());
    }

    public static String getUserAgent(HttpServletRequest request) {
        return request.getHeader("user-agent");
    }

    public static String getDomain() {
        HttpServletRequest request = RequestUtil.getRequest();
        StringBuffer url = request.getRequestURL();
        return url.delete(url.length() - request.getRequestURI().length(), url.length()).toString();
    }

    public static String getOrigin() {
        HttpServletRequest request = RequestUtil.getRequest();
        return request.getHeader("Origin");
    }

    public static final boolean isAjax(HttpServletRequest request) {
        String requestType = request.getHeader(RT_HEADER);
        if (StringUtils.isBlank((CharSequence)requestType)) {
            return false;
        }
        return requestType.equalsIgnoreCase(AJAX_RT);
    }

    public static String getString(HttpServletRequest request, String key, String defaultValue, boolean b) {
        String value = request.getParameter(key);
        if (StrUtil.isEmpty((CharSequence)value)) {
            return defaultValue;
        }
        if (b) {
            return value.replace("'", "''").trim();
        }
        return value.trim();
    }

    public static String getString(String key, String defaultValue, boolean b) {
        String value = RequestUtil.getRequest().getParameter(key);
        if (StrUtil.isEmpty((CharSequence)value)) {
            return defaultValue;
        }
        if (b) {
            return value.replace("'", "''").trim();
        }
        return value.trim();
    }

    public static String getString(HttpServletRequest request, String key) {
        return RequestUtil.getString(request, key, "", true);
    }

    public static String getString(HttpServletRequest request, String key, boolean b) {
        return RequestUtil.getString(request, key, "", b);
    }

    public static String getString(HttpServletRequest request, String key, String defaultValue) {
        return RequestUtil.getString(request, key, defaultValue, true);
    }

    public static String getStringAry(HttpServletRequest request, String key) {
        String[] aryValue = request.getParameterValues(key);
        if (aryValue == null || aryValue.length == 0) {
            return "";
        }
        String tmp = "";
        for (String v : aryValue) {
            tmp = "".equals(tmp) ? tmp + v : tmp + "," + v;
        }
        return tmp;
    }

    public static String getSecureString(HttpServletRequest request, String key, String defaultValue) {
        String value = request.getParameter(key);
        if (StrUtil.isEmpty((CharSequence)value)) {
            return defaultValue;
        }
        return RequestUtil.filterInject(value);
    }

    public static String getSecureString(HttpServletRequest request, String key) {
        return RequestUtil.getSecureString(request, key, "");
    }

    public static String filterInject(String str) {
        String injectstr = "\\||;|exec|insert|select|delete|update|count|chr|truncate|char";
        Pattern regex = Pattern.compile(injectstr, 226);
        Matcher matcher = regex.matcher(str);
        str = matcher.replaceAll("");
        str = str.replace("'", "''");
        str = str.replace("-", "\u2014");
        str = str.replace("(", "\uff08");
        str = str.replace(")", "\uff09");
        str = str.replace("%", "\uff05");
        return str;
    }

    public static String getLowercaseString(HttpServletRequest request, String key) {
        return RequestUtil.getString(request, key).toLowerCase();
    }

    public static int getInt(HttpServletRequest request, String key) {
        return RequestUtil.getInt(request, key, 0);
    }

    public static int getInt(HttpServletRequest request, String key, int defaultValue) {
        String str = request.getParameter(key);
        if (StrUtil.isEmpty((CharSequence)str)) {
            return defaultValue;
        }
        return Integer.parseInt(str);
    }

    public static int getInt(String key, int defaultValue) {
        String str = RequestUtil.getRequest().getParameter(key);
        if (StrUtil.isEmpty((CharSequence)str)) {
            return defaultValue;
        }
        return Integer.parseInt(str);
    }

    public static long getLong(HttpServletRequest request, String key) {
        return RequestUtil.getLong(request, key, 0L);
    }

    public static Long[] getLongAry(HttpServletRequest request, String key) {
        String[] aryKey = request.getParameterValues(key);
        if (BeanUtil.isEmpty(aryKey)) {
            return null;
        }
        Long[] aryLong = new Long[aryKey.length];
        for (int i = 0; i < aryKey.length; ++i) {
            aryLong[i] = Long.parseLong(aryKey[i]);
        }
        return aryLong;
    }

    public static Long[] getLongAryByStr(HttpServletRequest request, String key) {
        String str = request.getParameter(key);
        if (StrUtil.isEmpty((CharSequence)str)) {
            return null;
        }
        String[] aryId = str.split(",");
        Long[] lAryId = new Long[aryId.length];
        for (int i = 0; i < aryId.length; ++i) {
            lAryId[i] = Long.parseLong(aryId[i]);
        }
        return lAryId;
    }

    public static String[] getStringAryByStr(HttpServletRequest request, String key) {
        String str = request.getParameter(key);
        if (StrUtil.isEmpty((CharSequence)str)) {
            return null;
        }
        String[] aryId = str.split(",");
        String[] lAryId = new String[aryId.length];
        for (int i = 0; i < aryId.length; ++i) {
            lAryId[i] = aryId[i];
        }
        return lAryId;
    }

    public static Integer[] getIntAry(HttpServletRequest request, String key) {
        String[] aryKey = request.getParameterValues(key);
        if (BeanUtil.isEmpty(aryKey)) {
            return null;
        }
        Integer[] aryInt = new Integer[aryKey.length];
        for (int i = 0; i < aryKey.length; ++i) {
            aryInt[i] = Integer.parseInt(aryKey[i]);
        }
        return aryInt;
    }

    public static Float[] getFloatAry(HttpServletRequest request, String key) {
        String[] aryKey = request.getParameterValues(key);
        if (BeanUtil.isEmpty(aryKey)) {
            return null;
        }
        Float[] fAryId = new Float[aryKey.length];
        for (int i = 0; i < aryKey.length; ++i) {
            fAryId[i] = Float.valueOf(Float.parseFloat(aryKey[i]));
        }
        return fAryId;
    }

    public static long getLong(HttpServletRequest request, String key, long defaultValue) {
        String str = request.getParameter(key);
        if (StrUtil.isEmpty((CharSequence)str)) {
            return defaultValue;
        }
        return Long.parseLong(str.trim());
    }

    public static Long getLong(HttpServletRequest request, String key, Long defaultValue) {
        String str = request.getParameter(key);
        if (StrUtil.isEmpty((CharSequence)str)) {
            return defaultValue;
        }
        return Long.parseLong(str.trim());
    }

    public static float getFloat(HttpServletRequest request, String key) {
        return RequestUtil.getFloat(request, key, 0.0f);
    }

    public static float getFloat(HttpServletRequest request, String key, float defaultValue) {
        String str = request.getParameter(key);
        if (StrUtil.isEmpty((CharSequence)str)) {
            return defaultValue;
        }
        return Float.parseFloat(request.getParameter(key));
    }

    public static boolean getBoolean(HttpServletRequest request, String key) {
        return RequestUtil.getBoolean(request, key, false);
    }

    public static boolean getBoolean(HttpServletRequest request, String key, boolean defaultValue) {
        String str = request.getParameter(key);
        if (StrUtil.isEmpty((CharSequence)str)) {
            return defaultValue;
        }
        if (StringUtils.isNumeric((CharSequence)str)) {
            return Integer.parseInt(str) == 1;
        }
        return Boolean.parseBoolean(str);
    }

    public static Short getShort(HttpServletRequest request, String key) {
        return RequestUtil.getShort(request, key, (short)0);
    }

    public static Short getShort(HttpServletRequest request, String key, Short defaultValue) {
        String str = request.getParameter(key);
        if (StrUtil.isEmpty((CharSequence)str)) {
            return defaultValue;
        }
        return Short.parseShort(str);
    }

    public static Date getDate(HttpServletRequest request, String key, String style) throws ParseException {
        String str = request.getParameter(key);
        if (StrUtil.isEmpty((CharSequence)str)) {
            return null;
        }
        if (StrUtil.isEmpty((CharSequence)style)) {
            style = "yyyy-MM-dd HH:mm:ss";
        }
        return DateFormatUtil.parse(str, style);
    }

    public static Date getDate(HttpServletRequest request, String key) throws ParseException {
        String str = request.getParameter(key);
        if (StrUtil.isEmpty((CharSequence)str)) {
            return null;
        }
        return DateFormatUtil.parseDate(str);
    }

    public static Date getTimestamp(HttpServletRequest request, String key) throws ParseException {
        String str = request.getParameter(key);
        if (StrUtil.isEmpty((CharSequence)str)) {
            return null;
        }
        return DateFormatUtil.parseDateTime(str);
    }

    public static String getUrl(HttpServletRequest request) {
        StringBuffer urlThisPage = new StringBuffer();
        urlThisPage.append(request.getRequestURI());
        Enumeration e = request.getParameterNames();
        String para = "";
        String values = "";
        urlThisPage.append("?");
        while (e.hasMoreElements()) {
            para = (String)e.nextElement();
            values = request.getParameter(para);
            urlThisPage.append(para);
            urlThisPage.append("=");
            urlThisPage.append(values);
            urlThisPage.append("&");
        }
        return urlThisPage.substring(0, urlThisPage.length() - 1);
    }

    public static String getRootHost(HttpServletRequest request) {
        return request.getRequestURL().toString().split(request.getRequestURI())[0];
    }

    public static String getSysHost(HttpServletRequest request) {
        return request.getRequestURL().toString().split(request.getRequestURI())[0] + request.getContextPath();
    }

    public static Map<String, Object> getParameterValueMap(HttpServletRequest request, boolean remainArray, boolean isSecure) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Enumeration params = request.getParameterNames();
        while (params.hasMoreElements()) {
            String key = params.nextElement().toString();
            String[] values = request.getParameterValues(key);
            if (values == null) continue;
            if (values.length == 1) {
                String tmpValue = values[0];
                if (tmpValue == null || (tmpValue = tmpValue.trim()).equals("")) continue;
                if (isSecure) {
                    tmpValue = RequestUtil.filterInject(tmpValue);
                }
                if (tmpValue.equals("")) continue;
                map.put(key, tmpValue);
                continue;
            }
            String rtn = RequestUtil.getByAry(values, isSecure);
            if (rtn.length() <= 0) continue;
            if (remainArray) {
                map.put(key, rtn.split(","));
                continue;
            }
            map.put(key, rtn);
        }
        return map;
    }

    private static String getByAry(String[] aryTmp, boolean isSecure) {
        String rtn = "";
        for (int i = 0; i < aryTmp.length; ++i) {
            String str = aryTmp[i].trim();
            if (str.equals("")) continue;
            if (isSecure) {
                if ((str = RequestUtil.filterInject(str)).equals("")) continue;
                rtn = rtn + str + ",";
                continue;
            }
            rtn = rtn + str + ",";
        }
        if (rtn.length() > 0) {
            rtn = rtn.substring(0, rtn.length() - 1);
        }
        return rtn;
    }

    public static String getStringValues(HttpServletRequest request, String paramName) {
        String[] values = request.getParameterValues(paramName);
        if (BeanUtil.isEmpty(values)) {
            return "";
        }
        String tmp = "";
        for (int i = 0; i < values.length; ++i) {
            tmp = i == 0 ? tmp + values[i] : tmp + "," + values[i];
        }
        return tmp;
    }

    public static Locale getLocal(HttpServletRequest request) {
        Locale local = request.getLocale();
        if (local == null) {
            local = Locale.CHINA;
        }
        return local;
    }

    public static String getGetFullUrl(String url, String ... postParams) {
        if (postParams != null) {
            for (int i = 0; i < postParams.length; i += 2) {
                url = !url.contains("?") && i == 0 ? url + "?" + postParams[i] + "=" + postParams[i + 1] : url + "&" + postParams[i] + "=" + postParams[i + 1];
            }
        }
        return url;
    }

    public static String getGetFullUrl(String url, Map<String, ?> postParams) {
        if (postParams != null) {
            int i = 0;
            for (String key : postParams.keySet()) {
                url = !url.contains("?") && i == 0 ? url + "?" + key + "=" + String.valueOf(postParams.get(key)) : url + "&" + key + "=" + String.valueOf(postParams.get(key));
                ++i;
            }
        }
        return url;
    }

    public static final String getErrorUrl(HttpServletRequest request) {
        String errorUrl = (String)request.getAttribute("javax.servlet.error.request_uri");
        if (errorUrl == null) {
            errorUrl = (String)request.getAttribute("javax.servlet.forward.request_uri");
        }
        if (errorUrl == null) {
            errorUrl = (String)request.getAttribute("javax.servlet.include.request_uri");
        }
        if (errorUrl == null) {
            errorUrl = request.getRequestURL().toString();
        }
        return errorUrl;
    }

    public static Map<String, String> getParamsUtf8(HttpServletRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        for (String key : request.getParameterMap().keySet()) {
            params.put(key, RequestUtil.urlDecode(request.getParameter(key), "UTF-8"));
        }
        return params;
    }

    public static Map<String, Object> getParams(HttpServletRequest request) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        for (String key : request.getParameterMap().keySet()) {
            params.put(key, request.getParameter(key));
        }
        return params;
    }

    public static Map<String, String> getParameterMap(HttpServletRequest request) {
        HashMap<String, String> result = new HashMap<String, String>();
        Enumeration parameterNames = request.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String parameterName = (String)parameterNames.nextElement();
            result.put(parameterName, request.getParameter(parameterName));
        }
        return result;
    }

    public static Map<String, String> getParamsUtf8(ServletRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        for (String key : request.getParameterMap().keySet()) {
            params.put(key, RequestUtil.urlDecode(request.getParameter(key), "UTF-8"));
        }
        return params;
    }

    public static Map<String, String> getTrimedParamsUtf8(HttpServletRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        for (String key : request.getParameterMap().keySet()) {
            params.put(key, RequestUtil.urlDecode(request.getParameter(key), "UTF-8").trim());
        }
        return params;
    }

    public static Map<String, Object> getParams(HttpSession session) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        Enumeration enumeration = session.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            params.put(key, session.getAttribute(key));
        }
        return params;
    }

    public static boolean isAjaxRequest(HttpServletRequest request) {
        String header = request.getHeader(RT_HEADER);
        boolean isAjax = AJAX_RT.equals(header);
        return isAjax;
    }

    public static String urlDecode(String text, String charset) {
        try {
            return URLDecoder.decode(text, charset);
        }
        catch (Exception e) {
            return text;
        }
    }

    public static String urlEncode(String text, String charset) {
        try {
            return URLEncoder.encode(text, charset);
        }
        catch (Exception e) {
            return text;
        }
    }

    public static String getAuthHeader(HttpServletRequest request) {
        String accessToken = request.getHeader(TOKEN);
        if (!StrUtil.isBlank((CharSequence)accessToken)) {
            return accessToken;
        }
        accessToken = request.getHeader(AUTHORIZATION);
        if (!StrUtil.isBlank((CharSequence)accessToken)) {
            return accessToken;
        }
        accessToken = request.getParameter(TOKEN);
        if (!StrUtil.isBlank((CharSequence)accessToken)) {
            return accessToken;
        }
        Cookie[] cookies = request.getCookies();
        if (null == cookies || cookies.length == 0) {
            return null;
        }
        for (Cookie cookie : cookies) {
            if (!cookie.getName().equals(TOKEN)) continue;
            accessToken = cookie.getValue();
            break;
        }
        return accessToken;
    }

    public static String getBasePath(HttpServletRequest request) {
        StringBuffer basePath = new StringBuffer();
        String scheme = request.getScheme();
        String domain = request.getServerName();
        int port = request.getServerPort();
        basePath.append(scheme);
        basePath.append("://");
        basePath.append(domain);
        if ("http".equalsIgnoreCase(scheme) && 80 != port) {
            basePath.append(":").append(String.valueOf(port));
        } else if ("https".equalsIgnoreCase(scheme) && port != 443) {
            basePath.append(":").append(String.valueOf(port));
        }
        return basePath.toString();
    }

    public static String removeParam(HttpServletRequest request, String paramName) {
        String queryString = "";
        Enumeration keys = request.getParameterNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (key.equals(paramName)) continue;
            if (queryString.equals("")) {
                queryString = key + "=" + request.getParameter(key);
                continue;
            }
            queryString = queryString + "&" + key + "=" + request.getParameter(key);
        }
        return queryString;
    }

    public static String getIpAddr(HttpServletRequest request) {
        return IPUtil.getIpAddress(request);
    }

    public static Collection<MultipartFile> getUploadFiles(HttpServletRequest request) {
        Map fileMap = null;
        if (ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            MultipartHttpServletRequest multiRequest = (MultipartHttpServletRequest)request;
            fileMap = multiRequest.getFileMap();
        }
        return Optional.ofNullable(fileMap).map(map -> map.values()).orElse(Collections.emptyList());
    }
}

