/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.web.util;

import java.util.HashMap;
import java.util.Map;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class ParamsHolder {
    private static ThreadLocal<Map<String, Object>> paramsHolder = new ThreadLocal();

    private ParamsHolder() {
    }

    public static void set(String key, Object object) {
        Assert.hasText((String)key);
        Map<String, Object> params = paramsHolder.get();
        if (params == null) {
            params = new HashMap<String, Object>();
        }
        params.put(key, object);
        paramsHolder.set(params);
    }

    public static <T> T get(String key) {
        Map<String, Object> params = paramsHolder.get();
        if (CollectionUtils.isEmpty(params)) {
            return null;
        }
        return (T)params.get(key);
    }

    public static void sets(Map<String, Object> params) {
        paramsHolder.set(params);
    }

    public static Map<String, Object> gets() {
        return paramsHolder.get();
    }
}

