/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.web.util;

import cn.dolphin.core.exception.ParamRuntimeException;
import cn.dolphin.core.regex.RegexUtil;
import org.apache.commons.lang3.StringUtils;

public final class ParamValidUtil {
    public static final void check(boolean ... checks) {
        for (boolean check : checks) {
            if (!check) continue;
            throw ParamRuntimeException.ILLEGAL;
        }
    }

    public static final boolean isMobile(String mobile) {
        return RegexUtil.matcher(mobile, "^1[345678][0-9]{9}$");
    }

    public static final boolean isEmail(String email) {
        if (email.contains("#")) {
            return false;
        }
        return RegexUtil.matcher(email, "^[\\w-]+(\\.[\\w-]+)*@[\\w-]+(\\.[\\w-]+)+$");
    }

    public static final boolean isPwd(String pwd) {
        return pwd.length() == 32;
    }

    public static final boolean isUserName(String userName) {
        return userName.length() >= 4 && !StringUtils.isAlphanumeric((CharSequence)userName) && !StringUtils.isNumeric((CharSequence)userName);
    }

    public static final boolean isSmsCode(String smsCode) {
        return RegexUtil.matcher(smsCode, "^[0-9]{6}$");
    }

    public static final boolean isImgCode(String imgCode) {
        return RegexUtil.matcher(imgCode, "^[0-9]{4}$");
    }

    public static final boolean isEmailCode(String emailCode) {
        return RegexUtil.matcher(emailCode, "^[0-9]{6}$");
    }

    public static final boolean is31Days(String value) {
        return RegexUtil.matcher(value, "^((0?[1-9])|((1|2)[0-9])|30|31)$");
    }

    public static final boolean Date(String value) {
        return RegexUtil.matcher(value, "^((((1[6-9]|[2-9]\\d)\\d{2})-(0?[13578]|1[02])-(0?[1-9]|[12]\\d|3[01]))|(((1[6-9]|[2-9]\\d)\\d{2})-(0?[13456789]|1[012])-(0?[1-9]|[12]\\d|30))|(((1[6-9]|[2-9]\\d)\\d{2})-0?2-(0?[1-9]|1\\d|2[0-8]))|(((1[6-9]|[2-9]\\d)(0[48]|[2468][048]|[13579][26])|((16|[2468][048]|[3579][26])00))-0?2-29-)) (20|21|22|23|[0-1]?\\d):[0-5]?\\d:[0-5]?\\d$");
    }

    public static final boolean nomalStr(String value) {
        return RegexUtil.matcher(value, "[A-Za-z]+[0-9]");
    }

    public static final boolean Picture(String value) {
        return RegexUtil.matcher(value, "(.*)\\.(jpg|bmp|gif|ico|pcx|jpeg|tif|png|raw|tga)$");
    }

    public static final boolean Rar(String value) {
        return RegexUtil.matcher(value, "(.*)\\.(rar|zip|7zip|tgz)$");
    }

    public static final boolean UserName(String value) {
        return RegexUtil.matcher(value, "^\\w+$");
    }

    public static String contentType(String FilenameExtension) {
        if (FilenameExtension.equals("BMP") || FilenameExtension.equals("bmp")) {
            return "image/bmp";
        }
        if (FilenameExtension.equals("GIF") || FilenameExtension.equals("gif")) {
            return "image/gif";
        }
        if (FilenameExtension.equals("JPEG") || FilenameExtension.equals("jpeg") || FilenameExtension.equals("JPG") || FilenameExtension.equals("jpg") || FilenameExtension.equals("PNG") || FilenameExtension.equals("png")) {
            return "image/jpeg";
        }
        if (FilenameExtension.equals("HTML") || FilenameExtension.equals("html")) {
            return "text/html";
        }
        if (FilenameExtension.equals("TXT") || FilenameExtension.equals("txt")) {
            return "text/plain";
        }
        if (FilenameExtension.equals("VSD") || FilenameExtension.equals("vsd")) {
            return "application/vnd.visio";
        }
        if (FilenameExtension.equals("PPTX") || FilenameExtension.equals("pptx") || FilenameExtension.equals("PPT") || FilenameExtension.equals("ppt")) {
            return "application/vnd.ms-powerpoint";
        }
        if (FilenameExtension.equals("DOCX") || FilenameExtension.equals("docx") || FilenameExtension.equals("DOC") || FilenameExtension.equals("doc")) {
            return "application/msword";
        }
        if (FilenameExtension.equals("XML") || FilenameExtension.equals("xml")) {
            return "text/xml";
        }
        return "text/html";
    }
}

