/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.web.security.aspect;

import cn.dolphin.core.Global;
import cn.dolphin.core.id.ID;
import cn.dolphin.core.spring.SpringContextUtil;
import cn.dolphin.core.util.EmptyUtil;
import cn.dolphin.core.util.StrUtil;
import cn.dolphin.core.util.SystemClock;
import cn.dolphin.core.web.log.model.Log;
import cn.dolphin.core.web.log.service.LogService;
import cn.dolphin.core.web.security.UserSecurity;
import cn.dolphin.core.web.security.annotation.ApiLog;
import cn.dolphin.core.web.util.RequestUtil;
import cn.dolphin.ip.ipipnet.IP;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadLocalRandom;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;

@Aspect
@Order(value=-1)
public class LogAnnotationAspect {
    private static final Logger logger = LoggerFactory.getLogger(LogAnnotationAspect.class);

    @Around(value="@annotation(ds)")
    public Object logSave(ProceedingJoinPoint joinPoint, ApiLog ds) throws Throwable {
        MethodSignature methodSignature;
        ApiLog logAnnotation;
        long userid;
        String url = null;
        String httpMethod = null;
        Object result = null;
        Log log = new Log();
        log.setId(ID.getID());
        log.setCreatedAt(SystemClock.nowDate());
        if (EmptyUtil.isNotEmpty(UserSecurity.getUserId()).booleanValue() && (userid = UserSecurity.getUserId().longValue()) >= 0L) {
            log.setUserId(userid);
        }
        log.setSystem(null != (logAnnotation = (methodSignature = (MethodSignature)joinPoint.getSignature()).getMethod().getDeclaredAnnotation(ApiLog.class)).system() && !"".equals(logAnnotation.system()) ? logAnnotation.system() : Global.getConfig("spring.application.name"));
        log.setModule(logAnnotation.module());
        log.setName(logAnnotation.name());
        log.setMethod(methodSignature.getDeclaringTypeName() + "." + methodSignature.getName());
        log.setType(logAnnotation.type().getValue());
        if (logAnnotation.ip()) {
            String ip = RequestUtil.getIpAddr(RequestUtil.getRequest());
            if (StrUtil.isBlank((CharSequence)ip)) {
                ip = "\u672a\u77e5IP";
            }
            String addrs = IP.find(ip);
            log.setIp(ip);
            log.setLocation(StrUtil.isNotBlank((CharSequence)addrs) ? addrs : "\u672a\u8bc6\u522b\u51fa\u5730\u5740");
        }
        if (logAnnotation.params()) {
            ArrayList<Object> httpReqArgs = new ArrayList<Object>();
            Object[] args = joinPoint.getArgs();
            url = methodSignature.getDeclaringTypeName() + "/" + methodSignature.getName();
            for (Object object : args) {
                if (object instanceof HttpServletRequest) {
                    HttpServletRequest request = (HttpServletRequest)object;
                    url = request.getRequestURI();
                    httpMethod = request.getMethod();
                    continue;
                }
                if (object instanceof HttpServletResponse) continue;
                httpReqArgs.add(object);
            }
            try {
                String params = JSONObject.toJSONString(httpReqArgs);
                log.setParams(params);
            }
            catch (Exception e) {
                logger.error("\u8bb0\u5f55\u53c2\u6570\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            }
        }
        try {
            result = joinPoint.proceed();
            log.setFlag("true");
            log.setRemark("\u6210\u529f");
        }
        catch (Exception e) {
            log.setFlag("false");
            log.setRemark(e.getMessage());
            throw e;
        }
        finally {
            CompletableFuture.runAsync(() -> {
                try {
                    LogService logService = SpringContextUtil.getBean(LogService.class);
                    logService.saveLog(log);
                }
                catch (Exception e) {
                    logger.error("\u8bb0\u5f55\u53c2\u6570\u5931\u8d25\uff1a{}", (Object)e.getMessage());
                }
            });
        }
        return result;
    }

    public String getRandom() {
        StringBuilder st = new StringBuilder();
        for (int i = 0; i < 5; ++i) {
            st.append(ThreadLocalRandom.current().nextInt(10));
        }
        return st.toString() + System.currentTimeMillis();
    }
}

