/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.web.security;

import cn.dolphin.core.enums.SecurityEnum;
import cn.dolphin.core.exception.ApiException;
import cn.dolphin.core.util.CastUtil;
import cn.dolphin.core.util.EmptyUtil;
import cn.dolphin.core.util.StrUtil;
import cn.dolphin.core.web.security.core.AuthenticationContext;
import cn.dolphin.core.web.security.core.IntegrationAuthentication;

public class UserSecurity {
    public static Long getUserId() {
        IntegrationAuthentication authentication = AuthenticationContext.get();
        if (EmptyUtil.isEmpty(authentication).booleanValue()) {
            throw new ApiException(SecurityEnum.API_009019.code(), SecurityEnum.API_009019.msg());
        }
        return CastUtil.castLong(authentication.getUserId(), 0L);
    }

    public static String getUserIdStr() {
        IntegrationAuthentication authentication = AuthenticationContext.get();
        if (EmptyUtil.isEmpty(authentication).booleanValue()) {
            throw new ApiException(SecurityEnum.API_009019.code(), SecurityEnum.API_009019.msg());
        }
        return StrUtil.isNotBlank((CharSequence)authentication.getUserId()) ? authentication.getUserId() : "";
    }

    public static String getLoginName() {
        IntegrationAuthentication authentication = AuthenticationContext.get();
        if (EmptyUtil.isEmpty(authentication).booleanValue()) {
            throw new ApiException(SecurityEnum.API_009019.code(), SecurityEnum.API_009019.msg());
        }
        return StrUtil.isNotBlank((CharSequence)authentication.getLoginName()) ? authentication.getLoginName() : "";
    }

    public static String getToken() {
        IntegrationAuthentication authentication = AuthenticationContext.get();
        if (EmptyUtil.isEmpty(authentication).booleanValue()) {
            throw new ApiException(SecurityEnum.API_009019.code(), SecurityEnum.API_009019.msg());
        }
        return StrUtil.isNotBlank((CharSequence)authentication.getToken()) ? authentication.getToken() : "";
    }

    public static boolean isSuperAdmin() {
        IntegrationAuthentication authentication = AuthenticationContext.get();
        if (EmptyUtil.isEmpty(authentication).booleanValue()) {
            throw new ApiException(SecurityEnum.API_009019.code(), SecurityEnum.API_009019.msg());
        }
        return null != authentication.getIsSuper() && authentication.getIsSuper() == 1;
    }
}

