/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.web.controller;

import cn.dolphin.core.map.ThreadMapUtil;
import cn.dolphin.core.page.PageBean;
import cn.dolphin.core.page.PageSupport;
import cn.dolphin.core.util.EmptyUtil;
import cn.dolphin.core.web.context.BodyCacheHttpServletRequestWrapper;
import cn.dolphin.core.web.context.RequestThreadLocal;
import cn.dolphin.core.web.context.ResponseThreadLocal;
import cn.dolphin.core.web.controller.GenericController;
import java.beans.PropertyEditor;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;

public abstract class BaseExtController
extends GenericController {
    private static final Logger log = LoggerFactory.getLogger(BaseExtController.class);

    @InitBinder
    public void initBinder(ServletRequestDataBinder binder) {
        binder.registerCustomEditor(Date.class, (PropertyEditor)new CustomDateEditor((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"), true));
        binder.registerCustomEditor(Date.class, (PropertyEditor)new CustomDateEditor((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH"), true));
    }

    @ModelAttribute
    public void setReqAndRes(HttpServletRequest request, HttpServletResponse response) {
        RequestThreadLocal.setRequest(request);
        ResponseThreadLocal.setResponse(response);
    }

    protected PageBean getPage() {
        PageBean pageBean = PageSupport.buildPageRequest();
        return pageBean;
    }

    protected HttpServletRequest getRequest() {
        return RequestThreadLocal.getRequest();
    }

    protected HttpServletResponse getResponse() {
        return ResponseThreadLocal.getResponse();
    }

    protected Map<String, Object> getRequestParamsMap() {
        try {
            if (EmptyUtil.isEmpty(ThreadMapUtil.get()).booleanValue()) {
                return ThreadMapUtil.get();
            }
            ThreadMapUtil.put(BodyCacheHttpServletRequestWrapper.getParamsMap(this.getRequest()));
            return EmptyUtil.isNotEmpty(ThreadMapUtil.get()) != false ? ThreadMapUtil.get() : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected String redirect(String url) {
        return "redirect:" + url;
    }

    protected void outJson(HttpServletResponse response, Object jsonDataStr) {
        try {
            response.setContentType("application/json;charset=utf-8");
            PrintWriter out = response.getWriter();
            out.print(jsonDataStr);
            out.flush();
            out.close();
        }
        catch (IOException e) {
            log.error("\u8f93\u51fajson\u6570\u636e\u5b57\u7b26\u4e32", (Throwable)e);
        }
    }
}

