/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.web.context;

import cn.dolphin.core.json.FastJsonUtil;
import cn.dolphin.core.util.Bytes;
import cn.dolphin.core.util.EmptyUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.json.XML;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;

public class BodyCacheHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private static final Logger log = LoggerFactory.getLogger(BodyCacheHttpServletRequestWrapper.class);
    private static final byte[] DEFAULT_BYTE = new byte[0];
    private byte[] body;
    private ServletInputStreamWrapper inputStreamWrapper;

    public BodyCacheHttpServletRequestWrapper(HttpServletRequest request) throws IOException {
        super(request);
        this.body = IOUtils.toByteArray((InputStream)request.getInputStream());
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.body != null ? this.body : DEFAULT_BYTE);
        this.inputStreamWrapper = new ServletInputStreamWrapper(byteArrayInputStream);
        this.inputStreamWrapper.setInputStream(byteArrayInputStream);
    }

    public String[] getParameterValues(String parameter) {
        String[] values = super.getParameterValues(parameter);
        if (values == null || values.length <= 0) {
            return null;
        }
        int count = values.length;
        String[] encodedValues = new String[count];
        for (int i = 0; i < count; ++i) {
            encodedValues[i] = StringEscapeUtils.escapeHtml4((String)values[i]);
        }
        return encodedValues;
    }

    public String getParameter(String parameter) {
        String value = super.getParameter(parameter);
        return StringEscapeUtils.escapeHtml4((String)value);
    }

    public String getHeader(String name) {
        String value = super.getHeader(name);
        return StringEscapeUtils.escapeHtml4((String)value);
    }

    public byte[] getBody() {
        return this.body;
    }

    public static Map<String, Object> getParamsMap(HttpServletRequest request) {
        HashMap<String, Object> paramMap;
        block9: {
            paramMap = new HashMap<String, Object>();
            String httpmethod = request.getMethod();
            if (HttpMethod.POST.matches(httpmethod) || HttpMethod.PATCH.matches(httpmethod) || HttpMethod.PUT.matches(httpmethod)) {
                if (request instanceof BodyCacheHttpServletRequestWrapper) {
                    String body = Bytes.toString(((BodyCacheHttpServletRequestWrapper)request).getBody());
                    try {
                        JSONObject jsonObject;
                        String json;
                        if (StringUtils.isNotBlank((CharSequence)body) && EmptyUtil.isNotEmpty(json = JSON.toJSONString((Object)JSON.parseObject((String)body), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue})).booleanValue() && EmptyUtil.isNotEmpty(jsonObject = JSONObject.parseObject((String)json)).booleanValue()) {
                            paramMap.putAll((Map)JSONObject.toJavaObject((JSON)jsonObject, Map.class));
                        }
                    }
                    catch (Exception e) {
                        org.json.JSONObject json = XML.toJSONObject(body);
                        JSONObject jsonObject = null;
                        jsonObject = !json.isNull("xml") ? FastJsonUtil.parseObject(json.get("xml").toString()) : FastJsonUtil.parseObject(json.toString());
                        if (!EmptyUtil.isNotEmpty(jsonObject).booleanValue()) break block9;
                        paramMap.putAll((Map)JSONObject.toJavaObject((JSON)jsonObject, Map.class));
                    }
                } else {
                    Map ParameterMap = request.getParameterMap();
                    for (String name : ParameterMap.keySet()) {
                        paramMap.put(name, ((String[])ParameterMap.get(name))[0]);
                    }
                }
            } else {
                Map ParameterMap = request.getParameterMap();
                for (String name : ParameterMap.keySet()) {
                    paramMap.put(name, ((String[])ParameterMap.get(name))[0]);
                }
            }
        }
        return paramMap;
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.inputStreamWrapper;
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)((Object)this.inputStreamWrapper)));
    }

    private static class ServletInputStreamWrapper
    extends ServletInputStream {
        private InputStream inputStream;

        public boolean isFinished() {
            return true;
        }

        public boolean isReady() {
            return false;
        }

        public void setReadListener(ReadListener readListener) {
        }

        public int read() throws IOException {
            return this.inputStream.read();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ServletInputStreamWrapper)) {
                return false;
            }
            ServletInputStreamWrapper other = (ServletInputStreamWrapper)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            InputStream this$inputStream = this.getInputStream();
            InputStream other$inputStream = other.getInputStream();
            return !(this$inputStream == null ? other$inputStream != null : !this$inputStream.equals(other$inputStream));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ServletInputStreamWrapper;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            InputStream $inputStream = this.getInputStream();
            result = result * 59 + ($inputStream == null ? 43 : $inputStream.hashCode());
            return result;
        }

        public InputStream getInputStream() {
            return this.inputStream;
        }

        public void setInputStream(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        public String toString() {
            return "BodyCacheHttpServletRequestWrapper.ServletInputStreamWrapper(inputStream=" + this.getInputStream() + ")";
        }

        public ServletInputStreamWrapper(InputStream inputStream) {
            this.inputStream = inputStream;
        }
    }
}

