/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.util;

import cn.dolphin.core.util.StrUtil;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Map;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class YamlUtil {
    public static Map<?, ?> loadYaml(String fileName) throws FileNotFoundException {
        InputStream in = YamlUtil.class.getClassLoader().getResourceAsStream(fileName);
        return StrUtil.isNotEmpty((CharSequence)fileName) ? (LinkedHashMap)new Yaml().load(in) : null;
    }

    public static void dumpYaml(String fileName, Map<?, ?> map) throws IOException {
        if (StrUtil.isNotEmpty((CharSequence)fileName)) {
            FileWriter fileWriter = new FileWriter(YamlUtil.class.getResource(fileName).getFile());
            DumperOptions options = new DumperOptions();
            options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
            Yaml yaml = new Yaml(options);
            yaml.dump(map, (Writer)fileWriter);
        }
    }

    public static Object getProperty(Map<?, ?> map, Object qualifiedKey) {
        String input;
        if (map != null && !map.isEmpty() && qualifiedKey != null && !(input = String.valueOf(qualifiedKey)).equals("")) {
            if (input.contains(".")) {
                int index = input.indexOf(".");
                String left = input.substring(0, index);
                String right = input.substring(index + 1, input.length());
                return YamlUtil.getProperty((Map)map.get(left), right);
            }
            if (map.containsKey(input)) {
                return map.get(input);
            }
            return null;
        }
        return null;
    }

    public static void setProperty(Map<?, ?> map, Object qualifiedKey, Object value) {
        String input;
        if (map != null && !map.isEmpty() && qualifiedKey != null && !(input = String.valueOf(qualifiedKey)).equals("")) {
            if (input.contains(".")) {
                int index = input.indexOf(".");
                String left = input.substring(0, index);
                String right = input.substring(index + 1, input.length());
                YamlUtil.setProperty((Map)map.get(left), right, value);
            } else {
                map.put(qualifiedKey, value);
            }
        }
    }
}

