/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.util;

import cn.dolphin.core.util.EmptyUtil;
import cn.dolphin.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import java.io.File;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class ValidateUtil {
    private static final Pattern pcharanddigit = Pattern.compile("[0-9a-zA-Z]+");
    private static final Pattern pdatey_m_d = Pattern.compile("\\d{4}\\-\\d{2}\\-\\d{2}");
    private static final Pattern pip4 = Pattern.compile("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}");
    private static final Pattern pdomain = Pattern.compile("[a-zA-Z0-9-\\u4e00-\\u9fa5]+(.[a-zA-Z0-9-]+)+");
    private static final Pattern pinteger = Pattern.compile("[+-]?\\d+");
    private static final Pattern purl = Pattern.compile("(http|https):\\/\\/[\\w\\-_]+(\\.[\\w\\-_]+)+([\\w\\-\\.,@?^=%&amp;:/~\\+#]*[\\w\\-\\@?^=%&amp;/~\\+#])?");
    private static final Pattern pserialno = Pattern.compile("[a-z0-9-_]+");
    private static final Pattern pdateymd = Pattern.compile("\\d{8}");
    private static final String DOMAINS = ".com.cn|.net.cn|.org.cn|.gov.cn|.com|.net|.tv|.gd|.org|.cc|.vc|.mobi|.cd|.info|.name|.asia|.hk|.me|.la|.sh|.biz|.li|.kr|.in|.us|.io|.ac.cn|.bj.cn|.sh.cn|.tj.cn|.cq.cn|.he.cn|.sx.cn|.nm.cn|.ln.cn|.jl.cn|.hl.cn|.js.cn|.zj.cn|.ah.cn|.fj.cn|.jx.cn|.sd.cn|.ha.cn|.hb.cn|.hn.cn|.gd.cn|.gx.cn|.hi.cn|.sc.cn|.gz.cn|.yn.cn|.xz.cn|.sn.cn|.gs.cn|.qh.cn|.nx.cn|.xj.cn|.tw.cn|.hk.cn|.mo.cn|.cn";
    public static final Pattern IMAGES_PATTERN = Pattern.compile(".*\\.(bmp|gif|jpe?g|png|tiff?|pcx|tga|svg|pic)$", 2);
    public static final Pattern DECIMAL_PATTERN = Pattern.compile("^[0-9]+(\\.[0-9]+)?$");
    private static final char[] enChar = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    private static final char[] numChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};

    private ValidateUtil() {
    }

    public static boolean isEnglish(String value) {
        if (ValidateUtil.isEmptyString(value)) {
            return false;
        }
        Pattern pattern = Pattern.compile("^[A-Za-z]+$");
        Matcher m = pattern.matcher(value);
        return m.matches();
    }

    public static boolean isNumber(String value) {
        if (ValidateUtil.isEmptyString(value)) {
            return false;
        }
        Pattern pattern = Pattern.compile("^-?[0-9]*.?[0-9]+$");
        Matcher m = pattern.matcher(value);
        return m.matches();
    }

    public static boolean isInteger(String value) {
        if (ValidateUtil.isEmptyString(value)) {
            return false;
        }
        Matcher m = pinteger.matcher(value);
        return m.matches();
    }

    public static boolean isPoInteger(String value) {
        if (ValidateUtil.isEmptyString(value)) {
            return false;
        }
        Pattern pattern = Pattern.compile("^[0-9]+$");
        Matcher m = pattern.matcher(value);
        return m.matches();
    }

    public static boolean checkPhone(String value) {
        if (ValidateUtil.isEmptyString(value)) {
            return false;
        }
        Pattern pattern = Pattern.compile("^((\\d{3,4})\\-(\\d{8})|(\\d{4})\\-(\\d{7}))$");
        Matcher m = pattern.matcher(value);
        return m.matches();
    }

    public static boolean isEnglishOrNumber(String test) {
        for (char ch : test.toCharArray()) {
            if (Arrays.binarySearch(enChar, ch) >= 0 || Arrays.binarySearch(numChar, ch) >= 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isMobile(String str) {
        Pattern p = null;
        Matcher m = null;
        boolean b = false;
        p = Pattern.compile("^[1][3,5,8,7][0-9]{9}$");
        m = p.matcher(str);
        b = m.matches();
        return b;
    }

    public static boolean isPhone(String str) {
        Pattern p1 = null;
        Pattern p2 = null;
        Matcher m = null;
        boolean b = false;
        p1 = Pattern.compile("^[0][1-9]{2,3}-[0-9]{5,10}$");
        p2 = Pattern.compile("^[1-9]{1}[0-9]{5,8}$");
        if (str.length() > 9) {
            m = p1.matcher(str);
            b = m.matches();
        } else {
            m = p2.matcher(str);
            b = m.matches();
        }
        return b;
    }

    public static boolean isImage(String file) {
        return StrUtil.isNotEmpty((CharSequence)file) && IMAGES_PATTERN.matcher(file).matches();
    }

    public static boolean isImage(File file) {
        return EmptyUtil.isNotEmpty(file) != false && ValidateUtil.isImage(file.getName());
    }

    public static boolean isDecimal(String decimal) {
        return StrUtil.isNotEmpty((CharSequence)decimal) && DECIMAL_PATTERN.matcher(decimal).matches();
    }

    public static boolean checkMobile(String value) {
        if (ValidateUtil.isEmptyString(value)) {
            return false;
        }
        Pattern pattern = Pattern.compile("^1(4[0-9]|3[0-9]|5[0-9]|8[0-9]|7[0-9])\\d{8}$");
        Matcher m = pattern.matcher(value);
        return m.matches();
    }

    public static boolean checkMobileNo(String mobileNo) {
        if (ValidateUtil.isEmptyString(mobileNo)) {
            return false;
        }
        String regex = "^((13[0-9])|(14[5|7])|(15([0-3]|[5-9]))|(17[013678])|(18[0,5-9]))\\d{8}$";
        boolean isMatch = false;
        try {
            if (mobileNo.length() != 11) {
                isMatch = false;
            } else {
                Pattern p = Pattern.compile(regex);
                Matcher m = p.matcher(mobileNo);
                isMatch = m.matches();
            }
        }
        catch (Exception e) {
            isMatch = false;
            e.printStackTrace();
        }
        return isMatch;
    }

    public static boolean checkEmail(String value) {
        if (ValidateUtil.isEmptyString(value)) {
            return false;
        }
        Pattern pattern = Pattern.compile("^([a-zA-Z0-9]+[_|\\_|\\.]?)*[a-zA-Z0-9]+@([a-zA-Z0-9]+[_|\\_|\\.]?)*[a-zA-Z0-9]+\\.[a-zA-Z]{2,3}$");
        Matcher m = pattern.matcher(value);
        return m.matches();
    }

    public static boolean checkURL(String str) {
        if (ValidateUtil.isEmptyString(str)) {
            return false;
        }
        Matcher m = purl.matcher(str);
        return m.matches();
    }

    public static boolean checkURLExist(String url) {
        try {
            URL u = new URL(url);
            HttpURLConnection urlconn = (HttpURLConnection)u.openConnection();
            int state = urlconn.getResponseCode();
            if (state == 200) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean checkMainDomain(String str) {
        String[] domains;
        if (ValidateUtil.isEmptyString(str)) {
            return false;
        }
        for (String s : domains = DOMAINS.split("\\|")) {
            if (null == s || s.trim().equals("") || str.indexOf(s) <= 0) continue;
            return ValidateUtil.checkSerialNo(str = str.replace(s, ""));
        }
        return false;
    }

    public static boolean checkDomain(String s) {
        if (ValidateUtil.isEmptyString(s)) {
            return false;
        }
        Matcher m = pdomain.matcher(s);
        return m.matches();
    }

    public static boolean checkNotDomain(String s) {
        return !ValidateUtil.checkDomain(s);
    }

    public static boolean checkIP(String s) {
        if (ValidateUtil.isEmptyString(s)) {
            return false;
        }
        Matcher m = pip4.matcher(s);
        return m.matches();
    }

    public static boolean checkCharAndDigit(String s) {
        if (ValidateUtil.isEmptyString(s)) {
            return false;
        }
        Matcher m = pcharanddigit.matcher(s);
        return m.matches();
    }

    public static boolean checkSerialNo(String str) {
        if (ValidateUtil.isEmptyString(str)) {
            return false;
        }
        str = str.toLowerCase().trim();
        Matcher isSerialNo = pserialno.matcher(str);
        return isSerialNo.matches();
    }

    public static boolean checkForbid(String str) {
        String[] forbids;
        if (ValidateUtil.isEmptyString(str)) {
            return false;
        }
        str = str.toLowerCase().trim();
        for (String s : forbids = new String[]{"%", "\\", "'", "*"}) {
            if (str.indexOf(s) <= -1) continue;
            return true;
        }
        return false;
    }

    public static boolean checkPassWord(String value) {
        if (ValidateUtil.isEmptyString(value)) {
            return false;
        }
        Pattern pattern = Pattern.compile("^[a-zA-Z0-9_-]{6,20}$");
        Matcher m = pattern.matcher(value);
        return m.matches();
    }

    public static boolean checkUserName(String value) {
        if (ValidateUtil.isEmptyString(value)) {
            return false;
        }
        Pattern pattern = Pattern.compile("^[a-zA-Z0-9_-]{6,12}$");
        Matcher m = pattern.matcher(value);
        return m.matches();
    }

    public static boolean checkPersonName(String value) {
        if (ValidateUtil.isEmptyString(value)) {
            return false;
        }
        Pattern pattern = Pattern.compile("^[\u4e00-\u9fa5]{2,4}$");
        Matcher m = pattern.matcher(value);
        return m.matches();
    }

    public static int getLength(String value) {
        return value.length();
    }

    public static boolean isEmptyString(String value) {
        return value == null || "".equals(value.trim());
    }

    public static boolean isNotEmptyString(String s) {
        return !ValidateUtil.isEmptyString(s);
    }

    public static boolean isAllEmptyString(String ... str) {
        if (str == null) {
            return true;
        }
        for (String s : str) {
            if (!ValidateUtil.isNotEmptyString(s)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllNotEmptyString(String ... str) {
        if (str == null) {
            return false;
        }
        for (String s : str) {
            if (!ValidateUtil.isEmptyString(s)) continue;
            return false;
        }
        return true;
    }

    public static String replaceBlank(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return str;
        }
        Pattern p = Pattern.compile("\\s*|\t|\r|\n");
        Matcher m = p.matcher(str);
        return m.replaceAll("");
    }

    public static Boolean checkCommon(String value) {
        if (ValidateUtil.isEmptyString(value)) {
            return false;
        }
        Pattern pattern = Pattern.compile("\\S{1,50}");
        Matcher m = pattern.matcher(value);
        return m.matches();
    }

    public static Boolean checkAddress(String value) {
        if (ValidateUtil.isEmptyString(value)) {
            return false;
        }
        Pattern pattern = Pattern.compile("\\S{1,100}");
        Matcher m = pattern.matcher(value);
        return m.matches();
    }

    public static Boolean checkConstant(String value) {
        if (ValidateUtil.isEmptyString(value)) {
            return false;
        }
        Pattern pattern = Pattern.compile("\\S{1,255}");
        Matcher m = pattern.matcher(value);
        return m.matches();
    }

    public static boolean checkStringBetween(String str, int minLength, int maxLength) {
        if (str == null) {
            return false;
        }
        return str.length() >= minLength && str.length() <= maxLength;
    }

    public static boolean checkLongitude(String value) {
        if (ValidateUtil.isEmptyString(value)) {
            return false;
        }
        Pattern pattern = Pattern.compile("^[\\-\\+]?(0?\\d{1,2}\\.\\d{1,5}|1[0-7]?\\d{1}\\.\\d{1,12}|180\\.0{1,12})$");
        Matcher m = pattern.matcher(value);
        return m.matches();
    }

    public static boolean checkLatitude(String value) {
        if (ValidateUtil.isEmptyString(value)) {
            return false;
        }
        Pattern pattern = Pattern.compile("^[\\-\\+]?([0-8]?\\d{1}\\.\\d{1,12}|90\\.0{1,12})$");
        Matcher m = pattern.matcher(value);
        return m.matches();
    }

    public static boolean checkDateYMD(String s) {
        if (ValidateUtil.isEmptyString(s)) {
            return false;
        }
        Matcher m = pdateymd.matcher(s);
        return m.matches();
    }

    public static boolean checkDateY_M_D(String s) {
        if (ValidateUtil.isEmptyString(s)) {
            return false;
        }
        Matcher m = pdatey_m_d.matcher(s);
        return m.matches();
    }

    public static boolean test(String pattern, String str) {
        try {
            Pattern regex = Pattern.compile(pattern);
            Matcher m = regex.matcher(str);
            return m.matches();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean validateJson(String json) {
        if (json == null) {
            return false;
        }
        try {
            JSON.parse((String)json);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean validateNumber(String number) {
        if (null == number) {
            return false;
        }
        for (int i = 0; i < number.length(); ++i) {
            if (Character.isDigit(number.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        System.out.println(ValidateUtil.isNumber("-122.22"));
        System.out.println(ValidateUtil.isPoInteger("122"));
        System.out.println(ValidateUtil.isInteger("-122"));
        String phone = "13123456789";
        System.out.println("---\u7ed3\u679c:" + ValidateUtil.checkMobileNo(phone));
        System.out.println("---\u7ed3\u679c:" + ValidateUtil.checkMobile(phone));
        System.out.println("---\u7ed3\u679c:" + ValidateUtil.checkPhone("0755-12345678"));
    }

    static {
        Arrays.sort(enChar);
        Arrays.sort(numChar);
    }
}

