/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.util;

import cn.dolphin.core.util.StrUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utf8Util {
    private static final Logger logger = LoggerFactory.getLogger(Utf8Util.class);

    private Utf8Util() {
    }

    public static String getUtf8(String value) {
        if (StrUtil.isEmpty((CharSequence)value)) {
            return "";
        }
        try {
            if (Charset.forName("ISO-8859-1").newEncoder().canEncode(value)) {
                value = new String(value.getBytes("ISO-8859-1"), "UTF-8");
            }
            if (Charset.forName("GBK").newEncoder().canEncode(value)) {
                value = new String(value.getBytes("GBK"), "UTF-8");
            }
            if (Charset.forName("GB2312").newEncoder().canEncode(value)) {
                value = new String(value.getBytes("GB2312"), "UTF-8");
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return value;
    }

    public static final String iso2Utf(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return "";
        }
        try {
            return new String(str.getBytes("ISO-8859-1"), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static final String utf2iso(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return "";
        }
        try {
            return new String(str.getBytes("UTF-8"), "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String parseToUTF8(String str) {
        try {
            return URLEncoder.encode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String convertEncoding(String convertString) {
        String str = convertString;
        if (convertString != null) {
            try {
                if (convertString.equals(new String(convertString.getBytes("ISO-8859-1"), "ISO-8859-1"))) {
                    str = new String(convertString.getBytes("ISO-8859-1"), "UTF-8");
                }
            }
            catch (UnsupportedEncodingException e) {
                logger.error(e.toString(), (Throwable)e);
            }
        }
        return str;
    }

    public static final String ISO2GB(String text) {
        String result = "";
        try {
            result = new String(text.getBytes("ISO-8859-1"), "GB2312");
        }
        catch (UnsupportedEncodingException ex) {
            result = ex.toString();
        }
        return result;
    }

    public static final String GB2ISO(String text) {
        String result = "";
        try {
            result = new String(text.getBytes("GB2312"), "ISO-8859-1");
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static final String Utf8URLencode(String text) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c >= '\u0000' && c <= '\u00ff') {
                result.append(c);
                continue;
            }
            byte[] b = new byte[]{};
            try {
                b = Character.toString(c).getBytes("UTF-8");
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (int j = 0; j < b.length; ++j) {
                int k = b[j];
                if (k < 0) {
                    k += 256;
                }
                result.append("%" + Integer.toHexString(k).toUpperCase());
            }
        }
        return result.toString();
    }

    public static final String Utf8URLdecode(String text) {
        String result = "";
        int p = 0;
        if (text != null && text.length() > 0) {
            p = (text = text.toLowerCase()).indexOf("%e");
            if (p == -1) {
                return text;
            }
            while (p != -1) {
                result = result + text.substring(0, p);
                if ((text = text.substring(p, text.length())) == "" || text.length() < 9) {
                    return result;
                }
                result = result + Utf8Util.CodeToWord(text.substring(0, 9));
                text = text.substring(9, text.length());
                p = text.indexOf("%e");
            }
        }
        return result + text;
    }

    private static final String CodeToWord(String text) {
        String result;
        if (Utf8Util.Utf8codeCheck(text)) {
            byte[] code = new byte[]{(byte)(Integer.parseInt(text.substring(1, 3), 16) - 256), (byte)(Integer.parseInt(text.substring(4, 6), 16) - 256), (byte)(Integer.parseInt(text.substring(7, 9), 16) - 256)};
            try {
                result = new String(code, "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                result = null;
            }
        } else {
            result = text;
        }
        return result;
    }

    private static final boolean Utf8codeCheck(String text) {
        String sign = "";
        if (text.startsWith("%e")) {
            int i = 0;
            int p = 0;
            while (p != -1) {
                if ((p = text.indexOf("%", p)) != -1) {
                    ++p;
                }
                sign = sign + p;
                ++i;
            }
        }
        return sign.equals("147-1");
    }

    public static final boolean isUtf8Url(String text) {
        int p = (text = text.toLowerCase()).indexOf("%");
        if (p != -1 && text.length() - p > 9) {
            text = text.substring(p, p + 9);
        }
        return Utf8Util.Utf8codeCheck(text);
    }

    public static String urlEncode(String source, String encode) {
        String result = source;
        try {
            result = URLEncoder.encode(source, encode);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static void main(String[] args) {
        String url = "http://www.google.com/search?hl=zh-CN&newwindow=1&q=%E4%B8%AD%E5%9B%BD%E5%A4%A7%E7%99%BE%E7%A7%91%E5%9C%A8%E7%BA%BF%E5%85%A8%E6%96%87%E6%A3%80%E7%B4%A2&btnG=%E6%90%9C%E7%B4%A2&lr=";
        if (Utf8Util.isUtf8Url(url)) {
            System.out.println(Utf8Util.Utf8URLdecode(url));
        }
        if (Utf8Util.isUtf8Url(url = "http://www.baidu.com/baidu?word=%D6%D0%B9%FA%B4%F3%B0%D9%BF%C6%D4%DA%CF%DF%C8%AB%CE%C4%BC%EC%CB%F7&tn=myie2dg")) {
            System.out.println(Utf8Util.Utf8URLdecode(url));
        }
    }
}

