/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UnicodeUtil {
    private static String unicodeParttenExp = "\\\\u[0-9a-zA-Z]{4}";

    public static boolean isContainsUnicodeChar(String str) {
        if (null == str || str.isEmpty()) {
            return false;
        }
        Pattern pattern = Pattern.compile(unicodeParttenExp);
        return pattern.matcher(str).find();
    }

    public static boolean isUnicodeChar(String str) {
        return UnicodeUtil.isContainsUnicodeChar(str) && str.length() == 6;
    }

    public static String char2Unicode(char c) {
        if (c >= '\u0000' && c <= '\u007f') {
            return String.valueOf(c);
        }
        String s = Integer.toHexString(c);
        if (s.length() < 4) {
            s = "0000".substring(s.length(), 4) + s;
        }
        return "\\u" + s;
    }

    public static String string2Unicode(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        StringBuffer unicodeSb = new StringBuffer();
        for (char aChar : str.toCharArray()) {
            unicodeSb.append(UnicodeUtil.char2Unicode(aChar));
        }
        return unicodeSb.toString();
    }

    public static char unicode2char(String unicodeChar) {
        if (!UnicodeUtil.isUnicodeChar(unicodeChar)) {
            return '?';
        }
        char c = (char)Integer.parseInt(unicodeChar.substring(2), 16);
        return c;
    }

    public static String unicode2String(String unicode) {
        if (!UnicodeUtil.isContainsUnicodeChar(unicode)) {
            return unicode;
        }
        Pattern compile = Pattern.compile("(" + unicodeParttenExp + ")");
        Matcher matcher = compile.matcher(unicode);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, String.valueOf(UnicodeUtil.unicode2char(matcher.group())));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }
}

