/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.util;

import com.fasterxml.uuid.EthernetAddress;
import com.fasterxml.uuid.Generators;
import com.fasterxml.uuid.impl.TimeBasedGenerator;
import java.util.UUID;

public class UUIDUtil {
    private static String[] chars = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};

    public static String getUUID8() {
        return UUIDUtil.getUUID(8, UUID.randomUUID());
    }

    public static String getUUID8(byte[] bytes) {
        return UUIDUtil.getUUID(8, UUID.nameUUIDFromBytes(bytes));
    }

    public static String getUUID8(String fromString) {
        return UUIDUtil.getUUID(8, UUID.fromString(fromString));
    }

    public static long getUID19() {
        long uid = 0L;
        String dateuid = "" + (int)((Math.random() * 9.0 + 1.0) * 1.0E7);
        uid = Long.parseLong(dateuid);
        return uid;
    }

    public static String getUUID16() {
        return UUIDUtil.getUUID(16, UUID.randomUUID());
    }

    public static String getUUID16Num() {
        int machineId = 1;
        int hashCodeV = UUID.randomUUID().toString().hashCode();
        if (hashCodeV < 0) {
            hashCodeV = -hashCodeV;
        }
        return machineId + String.format("%015d", hashCodeV);
    }

    public static String getUUID16(String fromString) {
        return UUIDUtil.getUUID(16, UUID.fromString(fromString));
    }

    public static String getUUID16(byte[] bytes) {
        return UUIDUtil.getUUID(16, UUID.nameUUIDFromBytes(bytes));
    }

    public static String getUUID32() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public static String generatorUUID() {
        TimeBasedGenerator timeBasedGenerator = Generators.timeBasedGenerator((EthernetAddress)EthernetAddress.fromInterface());
        return timeBasedGenerator.generate().toString().replace("-", "");
    }

    public static String generateShortUuid() {
        StringBuffer shortBuffer = new StringBuffer();
        String uuid = UUID.randomUUID().toString().replace("-", "");
        for (int i = 0; i < 8; ++i) {
            String str = uuid.substring(i * 4, i * 4 + 4);
            int x = Integer.parseInt(str, 16);
            shortBuffer.append(chars[x % 62]);
        }
        return shortBuffer.toString();
    }

    private static String getUUID(int length, UUID uuid) {
        int groupLength = 32 / length;
        StringBuilder sb = new StringBuilder();
        String id = uuid.toString().replace("-", "");
        for (int i = 0; i < length; ++i) {
            String str = id.substring(i * groupLength, i * groupLength + groupLength);
            int x = Integer.parseInt(str, 16);
            sb.append(chars[x % 62]);
        }
        return sb.toString();
    }

    private static String getUUID(int length) {
        int groupLength = 32 / length;
        StringBuilder sb = new StringBuilder();
        String id = UUID.randomUUID().toString().replace("-", "");
        for (int i = 0; i < length; ++i) {
            String str = id.substring(i * groupLength, i * groupLength + groupLength);
            int x = Integer.parseInt(str, 16);
            sb.append(chars[x % 62]);
        }
        return sb.toString();
    }
}

