/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.util;

import cn.dolphin.core.exception.UtilsRuntimeException;
import java.io.UnsupportedEncodingException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class TextUtil {
    public static String convertHtmlSpecialChars(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return null;
        }
        String[][] chars = new String[][]{{"&", "&amp;"}, {"<", "&lt;"}, {">", "&gt;"}, {"\"", "&quot;"}, {"\u3000", " "}};
        return TextUtil.replaceChars(str, chars);
    }

    public static String reverseHtmlSpecialChars(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return null;
        }
        String[][] chars = new String[][]{{"&amp;", "&"}, {"&lt;", "<"}, {"&gt;", ">"}, {"&quot;", "\""}, {"\u3000", " "}};
        return TextUtil.replaceChars(str, chars);
    }

    public static String replaceChars(String str, String[][] chars) {
        for (String[] cs : chars) {
            str = str.replace(cs[0], cs[1]);
        }
        return str;
    }

    public static String substringForByte(String text, int length) {
        return TextUtil.substringForByte(text, length, false);
    }

    public static String substringForByte(String text, int length, boolean isConvertSpecialChars) {
        if (StringUtils.isBlank((CharSequence)text) || length < 1) {
            return text;
        }
        if (isConvertSpecialChars) {
            text = TextUtil.convertHtmlSpecialChars(text);
        }
        try {
            byte[] bytes = text.getBytes("GBK");
            byte[] contentNameBytes = ArrayUtils.subarray((byte[])bytes, (int)0, (int)length);
            int count = 0;
            for (byte b : contentNameBytes) {
                if (b >= 0) continue;
                ++count;
            }
            if (count % 2 != 0) {
                contentNameBytes = ArrayUtils.subarray((byte[])contentNameBytes, (int)0, (int)(contentNameBytes.length - 1));
            }
            String contentName = new String(contentNameBytes, "GBK");
            return contentName;
        }
        catch (UnsupportedEncodingException e) {
            throw new UtilsRuntimeException("\u6839\u636ebyte\u622a\u53d6\u5b57\u7b26\u4e32\u5931\u8d25", e);
        }
    }
}

