/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.util;

import java.sql.Timestamp;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class SystemClock {
    private final long period;
    private final AtomicLong now;

    private SystemClock(long period) {
        this.period = period;
        this.now = new AtomicLong(System.currentTimeMillis());
        this.scheduleClockUpdating();
    }

    private static SystemClock instance() {
        return InstanceHolder.INSTANCE;
    }

    public static long now() {
        return SystemClock.instance().currentTimeMillis();
    }

    public static String nowDateString() {
        return new Timestamp(SystemClock.instance().currentTimeMillis()).toString();
    }

    public static Timestamp nowDate() {
        return new Timestamp(SystemClock.instance().currentTimeMillis());
    }

    public static Timestamp nowDate(int l) {
        return new Timestamp(SystemClock.instance().currentTimeMillis() + (long)l);
    }

    private void scheduleClockUpdating() {
        ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable, "System Clock");
                thread.setDaemon(true);
                return thread;
            }
        });
        scheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                SystemClock.this.now.set(System.currentTimeMillis());
            }
        }, this.period, this.period, TimeUnit.MILLISECONDS);
    }

    private long currentTimeMillis() {
        return this.now.get();
    }

    public static void main(String[] args) {
        Timestamp date = SystemClock.nowDate();
        System.out.println(date);
        System.out.println(SystemClock.now());
        System.out.println(SystemClock.nowDate());
        System.out.println(SystemClock.nowDate(86400000));
    }

    private static class InstanceHolder {
        public static final SystemClock INSTANCE = new SystemClock(1L);

        private InstanceHolder() {
        }
    }
}

