/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.util;

import cn.dolphin.core.date.DateFormatUtil;
import cn.dolphin.core.util.ArrayUtil;
import cn.dolphin.core.util.BeanUtil;
import cn.dolphin.core.util.CharsetUtil;
import cn.dolphin.core.util.StrFormatter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.safety.Whitelist;

public class StrUtil
extends StringUtils {
    public static final Pattern pattern = Pattern.compile("^1[34578]\\d{9}$");
    public static final char UNDERLINE = '_';
    private static final String REGEX_URL = "(http:|https:)//[^[A-Za-z0-9\\._\\?%&+\\-=/#]]*";
    public static final String EMPTY_STRING = "";
    public static final String DEFAULT_GLUE = ", ";

    public static boolean isEqualsArr(Object value, Object ... equalArr) {
        if (value == null || EMPTY_STRING.equals(value.toString().trim())) {
            return false;
        }
        for (Object object : equalArr) {
            if (!value.toString().equals(object.toString())) continue;
            return true;
        }
        return false;
    }

    public static boolean isEqualsIcArr(Object value, Object ... equalArr) {
        if (value == null || EMPTY_STRING.equalsIgnoreCase(value.toString().trim())) {
            return false;
        }
        for (Object object : equalArr) {
            if (!value.toString().equals(object.toString())) continue;
            return true;
        }
        return false;
    }

    public static boolean isNotEqualsArr(Object value, Object ... notEqualArr) {
        if (value == null || EMPTY_STRING.equals(value.toString().trim())) {
            return true;
        }
        for (Object object : notEqualArr) {
            if (!value.toString().equals(object.toString())) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotEqualsIcArr(Object value, Object ... notEqualArr) {
        if (value == null || EMPTY_STRING.equals(value.toString().trim())) {
            return true;
        }
        for (Object object : notEqualArr) {
            if (!value.toString().equalsIgnoreCase(object.toString())) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumeric(Object obj) {
        if (obj == null) {
            return false;
        }
        String str = obj.toString();
        int sz = str.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isFullUpperCase(String word) {
        for (int i = 0; i < word.length(); ++i) {
            char c = word.charAt(i);
            if (!Character.isLowerCase(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isFullLowerCase(String word) {
        for (int i = 0; i < word.length(); ++i) {
            char c = word.charAt(i);
            if (!Character.isUpperCase(c)) continue;
            return false;
        }
        return true;
    }

    public static String toDefault(String value, String defaultValue) {
        return value == defaultValue ? EMPTY_STRING : value;
    }

    public static String[] split(String str, String separator) {
        return StringUtils.splitByWholeSeparator((String)str, (String)separator);
    }

    public static List<String> toArray(String string, String regex) {
        String[] arr;
        ArrayList<String> list = new ArrayList<String>();
        if (StrUtil.isEmpty((CharSequence)string)) {
            return list;
        }
        for (String str : arr = string.split(regex)) {
            if (StrUtil.isEmpty((CharSequence)str)) continue;
            list.add(str);
        }
        return list;
    }

    public static String inputStreamToString(InputStream is) {
        byte[] b = new byte[4096];
        StringBuffer out = new StringBuffer();
        try {
            int n;
            while ((n = is.read(b)) != -1) {
                out.append(new String(b, 0, n));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return out.toString();
    }

    public static String getPaper(String text, int length, String omit) {
        text = text.replaceAll("</?[^>]+>", EMPTY_STRING);
        if ((text = text.replaceAll("<a>\\s*|t|r|n</a>", EMPTY_STRING)).length() > length) {
            return text.substring(0, length - omit.length()) + omit;
        }
        return text;
    }

    private static boolean equalObject(Object obj1, Object obj2) {
        return obj1 != null ? obj1.equals(obj2) : obj2 == null;
    }

    private static boolean equalsString(CharSequence str1, CharSequence str2, boolean ignoreCase) {
        if (str1 == null) {
            return str2 == null;
        }
        if (ignoreCase) {
            return str1.toString().equalsIgnoreCase(str2.toString());
        }
        return str1.equals(str2);
    }

    public static boolean areNotEmpty(String ... values) {
        boolean result = true;
        if (values == null || values.length == 0) {
            result = false;
        } else {
            for (String value : values) {
                result &= !StrUtil.isEmpty((CharSequence)value);
            }
        }
        return result;
    }

    public static final String getStr(byte[] bytes) {
        try {
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static final byte[] getBytes(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return null;
        }
        try {
            return str.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String makeFirstLetterUpperCase(String newStr) {
        if (newStr.length() == 0) {
            return newStr;
        }
        char[] oneChar = new char[]{newStr.charAt(0)};
        String firstChar = new String(oneChar);
        return firstChar.toUpperCase() + newStr.substring(1);
    }

    public static String makeFirstLetterLowerCase(String newStr) {
        if (newStr.length() == 0) {
            return newStr;
        }
        char[] oneChar = new char[]{newStr.charAt(0)};
        String firstChar = new String(oneChar);
        return firstChar.toLowerCase() + newStr.substring(1);
    }

    public static boolean isNumberic(String s) {
        if (StringUtils.isEmpty((CharSequence)s)) {
            return false;
        }
        boolean rtn = StrUtil.validByRegex("^[-+]{0,1}\\d*\\.{0,1}\\d+$", s);
        if (rtn) {
            return true;
        }
        return StrUtil.validByRegex("^0[x|X][\\da-eA-E]+$", s);
    }

    public static boolean isInteger(String s) {
        boolean rtn = StrUtil.validByRegex("^[-+]{0,1}\\d*$", s);
        return rtn;
    }

    public static boolean isEmail(String s) {
        boolean rtn = StrUtil.validByRegex("(\\w+([-+.]\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*)*", s);
        return rtn;
    }

    public static boolean isMobile(String mobile) {
        return pattern.matcher(mobile).matches();
    }

    public static boolean isPhone(String s) {
        boolean rtn = StrUtil.validByRegex("(0[0-9]{2,3}\\-)?([2-9][0-9]{6,7})+(\\-[0-9]{1,4})?", s);
        return rtn;
    }

    public static boolean isZip(String s) {
        boolean rtn = StrUtil.validByRegex("^[0-9]{6}$", s);
        return rtn;
    }

    public static boolean isQq(String s) {
        boolean rtn = StrUtil.validByRegex("^[1-9]\\d{4,9}$", s);
        return rtn;
    }

    public static boolean isIp(String s) {
        boolean rtn = StrUtil.validByRegex("^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$", s);
        return rtn;
    }

    public static boolean isChinese(String s) {
        boolean rtn = StrUtil.validByRegex("^[\u4e00-\u9fa5]+$", s);
        return rtn;
    }

    public static boolean isChrNum(String s) {
        boolean rtn = StrUtil.validByRegex("^([a-zA-Z0-9]+)$", s);
        return rtn;
    }

    public static boolean isUrl(String url) {
        return StrUtil.validByRegex("(http://|https://)?([\\w-]+\\.)+[\\w-]+(/[\\w- ./?%&=]*)?", url);
    }

    public static Boolean isJson(String json) {
        if (StrUtil.isEmpty((CharSequence)json)) {
            return false;
        }
        try {
            JSONObject.fromObject((Object)json);
            return true;
        }
        catch (JSONException e) {
            try {
                JSONArray.fromObject((Object)json);
                return true;
            }
            catch (JSONException ex) {
                return false;
            }
        }
    }

    public static boolean validByRegex(String regex, String input) {
        Pattern p = Pattern.compile(regex, 2);
        Matcher regexMatcher = p.matcher(input);
        return regexMatcher.find();
    }

    public static String formatParamMsg(String message, Object ... args) {
        for (int i = 0; i < args.length; ++i) {
            message = message.replace("{" + i + "}", args[i].toString());
        }
        return message;
    }

    public static String formatParamMsg(String message, Map<String, ?> params) {
        if (params == null) {
            return message;
        }
        for (String key : params.keySet()) {
            Object val = params.get(key);
            if (val == null) continue;
            message = message.replace("${" + key + "}", val.toString());
        }
        return message;
    }

    public static StringBuilder formatMsg(CharSequence msgWithFormat, boolean autoQuote, Object ... args) {
        int argsLen = args.length;
        boolean markFound = false;
        StringBuilder sb = new StringBuilder(msgWithFormat);
        if (argsLen > 0) {
            for (int i = 0; i < argsLen; ++i) {
                String flag = "%" + (i + 1);
                int idx = sb.indexOf(flag);
                while (idx >= 0) {
                    markFound = true;
                    sb.replace(idx, idx + 2, StrUtil.toString(args[i], autoQuote));
                    idx = sb.indexOf(flag);
                }
            }
            if (args[argsLen - 1] instanceof Throwable) {
                StringWriter sw = new StringWriter();
                ((Throwable)args[argsLen - 1]).printStackTrace(new PrintWriter(sw));
                sb.append("\n").append(sw.toString());
            } else if (argsLen == 1 && !markFound) {
                sb.append(args[argsLen - 1].toString());
            }
        }
        return sb;
    }

    public static StringBuilder formatMsg(String msgWithFormat, Object ... args) {
        return StrUtil.formatMsg(new StringBuilder(msgWithFormat), true, args);
    }

    public static String toString(Object obj, boolean autoQuote) {
        StringBuilder sb = new StringBuilder();
        if (obj == null) {
            sb.append("NULL");
        } else if (obj instanceof Object[]) {
            for (int i = 0; i < ((Object[])obj).length; ++i) {
                sb.append(((Object[])obj)[i]).append(DEFAULT_GLUE);
            }
            if (sb.length() > 0) {
                sb.delete(sb.length() - 2, sb.length());
            }
        } else {
            sb.append(obj.toString());
        }
        if (!(!autoQuote || sb.length() <= 0 || sb.charAt(0) == '[' && sb.charAt(sb.length() - 1) == ']' || sb.charAt(0) == '{' && sb.charAt(sb.length() - 1) == '}')) {
            sb.insert(0, "[").append("]");
        }
        return sb.toString();
    }

    public static String returnSpace(String str) {
        String space = EMPTY_STRING;
        if (!str.isEmpty()) {
            String[] path = str.split("\\.");
            for (int i = 0; i < path.length - 1; ++i) {
                space = space + "&nbsp;&emsp;";
            }
        }
        return space;
    }

    public static synchronized String encryptSha256(String inputStr) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] digest = md.digest(inputStr.getBytes("UTF-8"));
            return new String(Base64.encodeBase64((byte[])digest));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static synchronized String encryptMd5(String inputStr) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(inputStr.getBytes());
            byte[] digest = md.digest();
            StringBuffer sb = new StringBuffer();
            for (byte b : digest) {
                sb.append(Integer.toHexString(b & 0xFF));
            }
            return sb.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getArrayAsString(List<String> arr) {
        if (arr == null || arr.size() == 0) {
            return EMPTY_STRING;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < arr.size(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(arr.get(i));
        }
        return sb.toString();
    }

    public static String getArrayAsString(String[] arr) {
        if (arr == null || arr.length == 0) {
            return EMPTY_STRING;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < arr.length; ++i) {
            if (i > 0) {
                sb.append("#");
            }
            sb.append(arr[i]);
        }
        return sb.toString();
    }

    public static String getSetAsString(Set<?> set) {
        if (set == null || set.size() == 0) {
            return EMPTY_STRING;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        Iterator<?> it = set.iterator();
        while (it.hasNext()) {
            if (i++ > 0) {
                sb.append(",");
            }
            sb.append(it.next().toString());
        }
        return sb.toString();
    }

    public static String hangeToBig(double value) {
        char[] hunit = new char[]{'\u62fe', '\u4f70', '\u4edf'};
        char[] vunit = new char[]{'\u4e07', '\u4ebf'};
        char[] digit = new char[]{'\u96f6', '\u58f9', '\u8d30', '\u53c1', '\u8086', '\u4f0d', '\u9646', '\u67d2', '\u634c', '\u7396'};
        String zheng = "\u6574";
        String jiao = "\u89d2";
        String fen = "\u5206";
        char yuan = '\u5706';
        long midVal = (long)(value * 100.0);
        String valStr = String.valueOf(midVal);
        String head = valStr.substring(0, valStr.length() - 2);
        int len = head.length();
        if (len > 12) {
            return "\u503c\u8fc7\u5927";
        }
        String rail = valStr.substring(valStr.length() - 2);
        String prefix = EMPTY_STRING;
        String suffix = EMPTY_STRING;
        suffix = rail.equals("00") ? zheng : digit[rail.charAt(0) - 48] + jiao + digit[rail.charAt(1) - 48] + fen;
        char[] chDig = head.toCharArray();
        int zero = 48;
        int zeroSerNum = 0;
        for (int i = 0; i < chDig.length; ++i) {
            int idx = (chDig.length - i - 1) % 4;
            int vidx = (chDig.length - i - 1) / 4;
            if (chDig[i] == '0') {
                zeroSerNum = (byte)(zeroSerNum + 1);
                if (zero == 48) {
                    zero = digit[0];
                    continue;
                }
                if (idx != 0 || vidx <= 0 || zeroSerNum >= 4) continue;
                prefix = prefix + vunit[vidx - 1];
                zero = 48;
                continue;
            }
            zeroSerNum = 0;
            if (zero != 48) {
                prefix = prefix + (char)zero;
                zero = 48;
            }
            prefix = prefix + digit[chDig[i] - 48];
            if (idx > 0) {
                prefix = prefix + hunit[idx - 1];
            }
            if (idx != 0 || vidx <= 0) continue;
            prefix = prefix + vunit[vidx - 1];
        }
        if (prefix.length() > 0) {
            prefix = prefix + yuan;
        }
        return prefix + suffix;
    }

    public static String jsonUnescape(String str) {
        return str.replace("&quot;", "\"").replace("&nuot;", "\n");
    }

    public static String htmlEntityToString(String dataStr) {
        dataStr = dataStr.replace("&apos;", "'").replace("&quot;", "\"").replace("&gt;", ">").replace("&lt;", "<").replace("&amp;", "&");
        int start = 0;
        int end = 0;
        StringBuffer buffer = new StringBuffer();
        while (start > -1) {
            int length;
            char s;
            int system = 10;
            if (start == 0) {
                int t = dataStr.indexOf("&#");
                if (start != t) {
                    start = t;
                }
                if (start > 0) {
                    buffer.append(dataStr.substring(0, start));
                }
            }
            end = dataStr.indexOf(";", start + 2);
            String charStr = EMPTY_STRING;
            if (end != -1 && ((s = (charStr = dataStr.substring(start + 2, end)).charAt(0)) == 'x' || s == 'X')) {
                system = 16;
                charStr = charStr.substring(1);
            }
            try {
                if (StrUtil.isNotEmpty((CharSequence)charStr)) {
                    char letter = (char)Integer.parseInt(charStr, system);
                    buffer.append(new Character(letter).toString());
                }
            }
            catch (NumberFormatException letter) {
                // empty catch block
            }
            start = dataStr.indexOf("&#", end);
            if (start - end > 1) {
                buffer.append(dataStr.substring(end + 1, start));
            }
            if (start != -1 || end + 1 == (length = dataStr.length())) continue;
            buffer.append(dataStr.substring(end + 1, length));
        }
        return buffer.toString();
    }

    public static String stringToHtmlEntity(String str) {
        StringBuffer sb = new StringBuffer();
        block8: for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\n': {
                    sb.append(c);
                    continue block8;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block8;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block8;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block8;
                }
                case '\'': {
                    sb.append("&apos;");
                    continue block8;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block8;
                }
                default: {
                    if (c < ' ' || c > '~') {
                        sb.append("&#x");
                        sb.append(Integer.toString(c, 16));
                        sb.append(';');
                        continue block8;
                    }
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String encodingString(String str, String from, String to) {
        String result = str;
        try {
            result = new String(str.getBytes(from), to);
        }
        catch (Exception e) {
            result = str;
        }
        return result;
    }

    public static String comdify(String value) {
        DecimalFormat df = null;
        if (value.indexOf(".") > 0) {
            int i = value.length() - value.indexOf(".") - 1;
            switch (i) {
                case 0: {
                    df = new DecimalFormat("###,##0");
                    break;
                }
                case 1: {
                    df = new DecimalFormat("###,##0.0");
                    break;
                }
                case 2: {
                    df = new DecimalFormat("###,##0.00");
                    break;
                }
                case 3: {
                    df = new DecimalFormat("###,##0.000");
                    break;
                }
                case 4: {
                    df = new DecimalFormat("###,##0.0000");
                    break;
                }
                default: {
                    df = new DecimalFormat("###,##0.00000");
                    break;
                }
            }
        } else {
            df = new DecimalFormat("###,##0");
        }
        double number = 0.0;
        try {
            number = Double.parseDouble(value);
        }
        catch (Exception e) {
            number = 0.0;
        }
        return df.format(number);
    }

    public static String convertScriptLine(String arg, Boolean flag) {
        if (StringUtils.isEmpty((CharSequence)arg)) {
            return arg;
        }
        String origStr = "\n";
        String targStr = "/n";
        if (!flag.booleanValue()) {
            origStr = "/n";
            targStr = "\n";
        }
        String[] args = arg.split(origStr);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < args.length; ++i) {
            sb.append(args[i]);
            if (args.length == i + 1) continue;
            sb.append(targStr);
        }
        return sb.toString();
    }

    public static String convertLine(String arg, Boolean flag) {
        if (StringUtils.isEmpty((CharSequence)arg)) {
            return arg;
        }
        String origStr = "\n";
        String targStr = "/n";
        if (!flag.booleanValue()) {
            origStr = "/n";
            targStr = "\n";
        }
        String[] args = arg.split(origStr);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < args.length; ++i) {
            sb.append(StringUtils.deleteWhitespace((String)args[i]));
            if (args.length == i + 1) continue;
            sb.append(targStr);
        }
        return sb.toString();
    }

    public static String deleteWhitespaceLine(String arg) {
        if (StringUtils.isEmpty((CharSequence)arg)) {
            return arg;
        }
        String origStr = "\n";
        String[] args = arg.split(origStr);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < args.length; ++i) {
            sb.append(StringUtils.deleteWhitespace((String)args[i]));
            if (args.length == i + 1) continue;
            sb.append(origStr);
        }
        return sb.toString();
    }

    public static String parseText(String arg) {
        if (StringUtils.isEmpty((CharSequence)arg)) {
            return arg;
        }
        String[] args = arg.split("\n");
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < args.length; ++i) {
            sb.append(args[i]);
            if (args.length == i + 1) continue;
            sb.append("</br>");
        }
        return sb.toString();
    }

    public static String replaceNotVisable(String str) {
        char[] ary = str.toCharArray();
        ArrayList<Character> list = new ArrayList<Character>();
        for (int i = 0; i < ary.length; ++i) {
            char c = ary[i];
            if (!StrUtil.isViable(c)) continue;
            list.add(Character.valueOf(c));
        }
        Object[] aryc = list.toArray();
        char[] arycc = new char[aryc.length];
        for (int i = 0; i < aryc.length; ++i) {
            arycc[i] = ((Character)aryc[i]).charValue();
        }
        String out = new String(arycc);
        return out;
    }

    private static boolean isViable(int i) {
        return i == 0 || i == 13 || i >= 9 && i <= 10 || i >= 11 && i <= 12 || i >= 28 && i <= 126 || i >= 19968 && i <= 40869;
    }

    public static String replaceAll(String toReplace, String replace, String replaceBy) {
        replaceBy = replaceBy.replaceAll("\\\\", "&#92");
        replaceBy = replaceBy.replaceAll("\\$", "\\\\\\$").replaceAll("\"", "&quot");
        return toReplace.replaceAll(replace, replaceBy);
    }

    public static String stringFormat2Json(String json) {
        StringBuilder sb = new StringBuilder();
        int size = json.length();
        block7: for (int i = 0; i < size; ++i) {
            char c = json.charAt(i);
            switch (c) {
                case '\b': {
                    sb.append("\\b");
                    continue block7;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block7;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block7;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block7;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block7;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String getNumber(Object value, Object isShowComdify, Object decimalValue, Object coinValue) {
        boolean foundPoint;
        int len;
        if (value == null) {
            return EMPTY_STRING;
        }
        String val = value.toString();
        if (isShowComdify != null) {
            short result = 0;
            String temp = isShowComdify.toString();
            boolean isInteger = temp.matches("^[0-9]*$");
            if (isInteger) {
                result = Short.parseShort(temp);
            } else if ("true".equals(temp)) {
                result = 1;
            } else if ("false".equals(temp)) {
                result = 0;
            }
            Double douvalue = Double.parseDouble(val);
            DecimalFormat df = new DecimalFormat(EMPTY_STRING);
            val = df.format(douvalue);
            if (result != 1) {
                val = val.replace(",", EMPTY_STRING);
            }
        }
        if (decimalValue != null && (len = Integer.parseInt(decimalValue.toString())) > 0) {
            int idx = val.indexOf(".");
            if (idx == -1) {
                val = val + "." + StrUtil.getZeroLen(len);
            } else {
                String intStr = val.substring(0, val.indexOf("."));
                String decimal = val.substring(val.indexOf(".") + 1);
                if (decimal.length() > len) {
                    Double douvalue = Double.parseDouble(val.replace(",", EMPTY_STRING));
                    DecimalFormat df = new DecimalFormat(EMPTY_STRING);
                    df.setMaximumFractionDigits(len);
                    String tmp = df.format(douvalue);
                    if (tmp.indexOf(".") == -1) {
                        val = intStr + "." + StrUtil.getZeroLen(len);
                    } else {
                        decimal = tmp.substring(tmp.indexOf(".") + 1);
                        val = intStr + "." + decimal;
                    }
                } else if (decimal.length() < len) {
                    int tmp = len - decimal.length();
                    val = val + StrUtil.getZeroLen(tmp);
                }
            }
        }
        if (foundPoint = val.matches("^\\.\\d+")) {
            val = 0 + val;
        }
        if (coinValue != null) {
            val = coinValue.toString() + val;
        }
        return val;
    }

    private static String getZeroLen(int len) {
        String str = EMPTY_STRING;
        for (int i = 0; i < len; ++i) {
            str = str + "0";
        }
        return str;
    }

    public static String removeHTMLTag(String htmlStr) {
        if (StrUtil.isEmpty((CharSequence)htmlStr)) {
            return EMPTY_STRING;
        }
        htmlStr = Jsoup.clean((String)htmlStr, (Whitelist)Whitelist.none());
        htmlStr = StrUtil.htmlEntityToString(htmlStr);
        return htmlStr.trim();
    }

    public static boolean contain(String str, String searchStr) {
        return StrUtil.contain(str, searchStr, ",", true);
    }

    public static boolean contain(String str, String searchStr, String argumentSeparator, boolean isIgnoreCase) {
        if (StrUtil.isEmpty((CharSequence)str)) {
            return false;
        }
        if (StrUtil.isEmpty((CharSequence)argumentSeparator)) {
            argumentSeparator = ",";
        }
        String[] aryStr = str.split(argumentSeparator);
        return StrUtil.contain(aryStr, searchStr, isIgnoreCase);
    }

    public static boolean contain(String[] aryStr, String searchStr, boolean isIgnoreCase) {
        if (BeanUtil.isEmpty(aryStr)) {
            return false;
        }
        for (String str : aryStr) {
            if (!(isIgnoreCase ? str.equalsIgnoreCase(searchStr) : str.equals(searchStr))) continue;
            return true;
        }
        return false;
    }

    public static int getCount(String str, int type) {
        int len = str.length();
        int chineseCount = 0;
        int letterCount = 0;
        int blankCount = 0;
        int numCount = 0;
        int otherCount = 0;
        for (int i = 0; i < len; ++i) {
            char tem = str.charAt(i);
            Character.UnicodeBlock ub = Character.UnicodeBlock.of(tem);
            if (tem > 'A' && tem < 'Z' || tem > 'a' && tem < 'z') {
                ++letterCount;
                continue;
            }
            if (tem == ' ') {
                ++blankCount;
                continue;
            }
            if (tem > '0' && tem < '9') {
                ++numCount;
                continue;
            }
            if (ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B || ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS || ub == Character.UnicodeBlock.GENERAL_PUNCTUATION) {
                ++chineseCount;
                continue;
            }
            ++otherCount;
        }
        switch (type) {
            case -1: {
                return chineseCount;
            }
            case 0: {
                return letterCount;
            }
            case 1: {
                return blankCount;
            }
            case 2: {
                return numCount;
            }
            case 3: {
                return otherCount;
            }
        }
        return otherCount;
    }

    public static int getTotalSize(String str) {
        int chineseCount = StrUtil.getCount(str, -1);
        int letterCount = StrUtil.getCount(str, 0);
        int blankCount = StrUtil.getCount(str, 1);
        int numCount = StrUtil.getCount(str, 2);
        int otherCount = StrUtil.getCount(str, 3);
        return chineseCount + (letterCount + numCount) / 3 + blankCount / 4 + otherCount * 3 / 4;
    }

    public static String getUrl(String url, String params) {
        if (StrUtil.isEmpty((CharSequence)url)) {
            return url;
        }
        if (url.indexOf("?") > 0) {
            url = StrUtil.isNotEmpty((CharSequence)params) ? url + "&" + params : url + "?" + params;
        } else if (StrUtil.isNotEmpty((CharSequence)params)) {
            url = url + "?" + params;
        }
        return url;
    }

    public static String camelToUnderline(String param) {
        if (param == null || EMPTY_STRING.equals(param.trim())) {
            return EMPTY_STRING;
        }
        int len = param.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = param.charAt(i);
            if (Character.isUpperCase(c)) {
                sb.append('_');
                sb.append(Character.toLowerCase(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String underlineToCamel(String param) {
        if (param == null || EMPTY_STRING.equals(param.trim())) {
            return EMPTY_STRING;
        }
        int len = param.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = param.charAt(i);
            if (c == '_') {
                if (++i >= len) continue;
                sb.append(Character.toUpperCase(param.charAt(i)));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static List<String> stringToList(String str) {
        ArrayList<String> list = new ArrayList<String>();
        if (str != null && !str.equals(EMPTY_STRING)) {
            if (str.contains("[") || str.contains("]")) {
                String[] strs;
                for (String str1 : strs = str.split(",")) {
                    if (str1.contains("[")) {
                        str1 = str1.replace("[", EMPTY_STRING);
                    }
                    if (str1.contains("]")) {
                        str1 = str1.replace("]", EMPTY_STRING);
                    }
                    str1 = str1.replaceAll("\"", EMPTY_STRING);
                    list.add(str1);
                }
                return list;
            }
            list.add(str);
        }
        return list;
    }

    public static String getParam(String mrthor) {
        Pattern p = Pattern.compile("\\(.*?\\)");
        Matcher m = p.matcher(mrthor);
        String param = null;
        while (m.find()) {
            param = m.group().replaceAll("\\(\\)", EMPTY_STRING);
            param = param.replace("(", EMPTY_STRING);
            param = param.replace(")", EMPTY_STRING);
            param = param.replace("\"", EMPTY_STRING);
        }
        return param;
    }

    public static Integer[] StringToInt(String[] arrs) {
        Integer[] ints = new Integer[arrs.length];
        for (int i = 0; i < arrs.length; ++i) {
            ints[i] = Integer.parseInt(arrs[i]);
        }
        return ints;
    }

    public static Object parserObject(Object obj, String type) {
        if (BeanUtil.isEmpty(obj)) {
            return null;
        }
        Object val = obj;
        try {
            String str = obj.toString();
            if (type.equalsIgnoreCase("string")) {
                val = str;
            } else if (type.equalsIgnoreCase("int")) {
                val = Integer.parseInt(str);
            } else if (type.equalsIgnoreCase("float")) {
                val = Float.valueOf(Float.parseFloat(str));
            } else if (type.equalsIgnoreCase("double")) {
                val = Double.parseDouble(str);
            } else if (type.equalsIgnoreCase("byte")) {
                val = Byte.parseByte(str);
            } else if (type.equalsIgnoreCase("short")) {
                val = Short.parseShort(str);
            } else if (type.equalsIgnoreCase("long")) {
                val = Long.parseLong(str);
            } else if (type.equalsIgnoreCase("boolean")) {
                if (StringUtils.isNumeric((CharSequence)str)) {
                    val = Integer.parseInt(str) == 1;
                }
                val = Boolean.parseBoolean(str);
            } else {
                val = type.equalsIgnoreCase("date") ? DateFormatUtil.parse(str) : str;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return val;
    }

    public static String defaultString(String str, String defaultStr) {
        return str == null ? defaultStr : str;
    }

    public static String substringBetween(String str, String open, String close) {
        int end;
        if (str == null || open == null || close == null) {
            return null;
        }
        int start = str.indexOf(open);
        if (start != -1 && (end = str.indexOf(close, start + open.length())) != -1) {
            return str.substring(start + open.length(), end);
        }
        return null;
    }

    public static int getInt(String val) {
        return StrUtil.getInt(val, -1);
    }

    public static int getInt(Object val) {
        if (val == null) {
            return -1;
        }
        return StrUtil.getInt(val.toString(), -1);
    }

    public static int getInt(Object val, int def) {
        try {
            return Integer.parseInt(val.toString().trim());
        }
        catch (Exception e) {
            return def;
        }
    }

    public static long getLong(String val) {
        return StrUtil.getLong(val, -1L);
    }

    public static long getLong(String val, long def) {
        try {
            return Long.parseLong(val.trim());
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public static double getDouble(String value) {
        return StrUtil.getDouble(value, 0.0);
    }

    public static double getDouble(String value, double def) {
        try {
            return Double.valueOf(value);
        }
        catch (Exception e) {
            return def;
        }
    }

    public static BigDecimal getBigDecimal(String str) {
        try {
            BigDecimal bd = new BigDecimal(str);
            return bd;
        }
        catch (Exception e) {
            return BigDecimal.valueOf(-1.0);
        }
    }

    public static BigDecimal getBigDecimal(String str, double def) {
        try {
            BigDecimal bd = new BigDecimal(str);
            return bd;
        }
        catch (Exception e) {
            return BigDecimal.valueOf(def);
        }
    }

    public static String format(CharSequence template, Object ... params) {
        if (null == template) {
            return null;
        }
        if (ArrayUtil.isEmpty((Object[])params) || StrUtil.isBlank((CharSequence)template)) {
            return template.toString();
        }
        return StrFormatter.format(template.toString(), params);
    }

    public static String utf8Str(Object obj) {
        return StrUtil.str(obj, CharsetUtil.CHARSET_UTF_8);
    }

    public static String str(Object obj, String charsetName) {
        return StrUtil.str(obj, Charset.forName(charsetName));
    }

    public static String str(Object obj, Charset charset) {
        if (null == obj) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof byte[]) {
            return StrUtil.str((byte[])obj, charset);
        }
        if (obj instanceof Byte[]) {
            return StrUtil.str((Byte[])obj, charset);
        }
        if (obj instanceof ByteBuffer) {
            return StrUtil.str((ByteBuffer)obj, charset);
        }
        if (ArrayUtil.isArray(obj)) {
            return ArrayUtil.toString(obj);
        }
        return obj.toString();
    }

    public static String str(byte[] bytes, String charset) {
        return StrUtil.str(bytes, StrUtil.isBlank((CharSequence)charset) ? Charset.defaultCharset() : Charset.forName(charset));
    }

    public static String str(byte[] data, Charset charset) {
        if (data == null) {
            return null;
        }
        if (null == charset) {
            return new String(data);
        }
        return new String(data, charset);
    }

    public static String str(Byte[] bytes, String charset) {
        return StrUtil.str(bytes, StrUtil.isBlank((CharSequence)charset) ? Charset.defaultCharset() : Charset.forName(charset));
    }

    public static String str(Byte[] data, Charset charset) {
        if (data == null) {
            return null;
        }
        byte[] bytes = new byte[data.length];
        for (int i = 0; i < data.length; ++i) {
            Byte dataByte = data[i];
            bytes[i] = null == dataByte ? -1 : (int)dataByte.byteValue();
        }
        return StrUtil.str(bytes, charset);
    }

    public static String str(ByteBuffer data, String charset) {
        if (data == null) {
            return null;
        }
        return StrUtil.str(data, Charset.forName(charset));
    }

    public static String str(ByteBuffer data, Charset charset) {
        if (null == charset) {
            charset = Charset.defaultCharset();
        }
        return charset.decode(data).toString();
    }

    public static String str(CharSequence cs) {
        return null == cs ? null : cs.toString();
    }

    public static String toString(Object obj) {
        return null == obj ? "null" : obj.toString();
    }

    public static String subTract(String str) {
        if (str.length() == 0) {
            return EMPTY_STRING;
        }
        return str.substring(0, str.length() - 1);
    }

    public static boolean isRegexContains(String str, String regex) {
        Pattern pat = Pattern.compile(regex);
        Matcher matcher = pat.matcher(str);
        return matcher.find();
    }

    public static boolean existUrl(String str) {
        return StrUtil.isRegexContains(str, REGEX_URL);
    }

    public static String toString(float[] a) {
        return StrUtil.toString(a, DEFAULT_GLUE);
    }

    public static String toString(float[] a, String glue) {
        return StrUtil.toString(a, glue);
    }

    public static String toString(double[] a) {
        return StrUtil.toString(a, DEFAULT_GLUE);
    }

    public static String toString(double[] a, String glue) {
        return StrUtil.toString(a, glue);
    }

    public static String toString(short[] a) {
        return StrUtil.toString(a, DEFAULT_GLUE);
    }

    public static String toString(short[] a, String glue) {
        return StrUtil.toString(a, glue);
    }

    public static String toString(int[] a) {
        return StrUtil.toString(a, DEFAULT_GLUE);
    }

    public static String toString(int[] a, String glue) {
        return StrUtil.toString(a, glue);
    }

    public static String toString(long[] a) {
        return StrUtil.toString(a, DEFAULT_GLUE);
    }

    public static String toString(long[] a, String glue) {
        return StrUtil.toString(a, glue);
    }

    public static String toString(byte[] a) {
        return StrUtil.toString(a, DEFAULT_GLUE);
    }

    public static String toString(byte[] a, String glue) {
        return StrUtil.toString(a, glue);
    }

    public static String toString(char[] a) {
        return StrUtil.toString(a, DEFAULT_GLUE);
    }

    public static String toString(char[] a, String glue) {
        return StrUtil.toString(a, glue);
    }

    public static String toString(boolean[] a) {
        return StrUtil.toString(a, DEFAULT_GLUE);
    }

    public static String toString(boolean[] a, String glue) {
        return StrUtil.toString(a, glue);
    }

    public static <O> String toString(O[] a) {
        return StrUtil.toString(a, DEFAULT_GLUE);
    }

    public static <O> String toString(O[] a, String glue) {
        if (a == null) {
            return null;
        }
        if (a.length == 0) {
            return EMPTY_STRING;
        }
        String glueSep = glue == null ? DEFAULT_GLUE : glue;
        StringBuilder sb = new StringBuilder();
        int iMax = a.length - 1;
        int i = 0;
        while (true) {
            sb.append(a[i]);
            if (i == iMax) {
                return sb.toString();
            }
            sb.append(glueSep);
            ++i;
        }
    }

    public static final <O> List<O> toList(O[] a) {
        return a == null ? null : Arrays.asList(a);
    }

    public static final <O> Set<O> toSet(O[] a) {
        if (a == null) {
            return null;
        }
        LinkedHashSet<O> result = new LinkedHashSet<O>(a.length);
        for (O e : a) {
            result.add(e);
        }
        return result;
    }
}

