/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.util;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.util.DigestUtils;

public class SignUtil {
    private static final SignUtil SIGN_UTILS = new SignUtil();

    private SignUtil() {
    }

    public static SignUtil getInstance() {
        return SIGN_UTILS;
    }

    public String generateSign(String signKey, Map<String, String> params) {
        List storedKeys = Arrays.stream(params.keySet().toArray(new String[0])).sorted(Comparator.naturalOrder()).collect(Collectors.toList());
        String sign = storedKeys.stream().filter(key -> !Objects.equals(key, "sign")).map(key -> String.join((CharSequence)"", key, (CharSequence)params.get(key))).collect(Collectors.joining()).trim().concat(signKey);
        return DigestUtils.md5DigestAsHex((byte[])sign.getBytes()).toUpperCase();
    }

    public boolean isValid(String sign, Map<String, String> params, String signKey) {
        return Objects.equals(sign, this.generateSign(signKey, params));
    }
}

