/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.util;

import cn.dolphin.core.util.Charsets;
import cn.dolphin.core.web.util.UrlUtil;
import java.io.File;
import java.net.URL;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class PathUtil {
    public static final String FILE_PROTOCOL = "file";
    public static final String JAR_PROTOCOL = "jar";
    public static final String ZIP_PROTOCOL = "zip";
    public static final String FILE_PROTOCOL_PREFIX = "file:";
    public static final String JAR_FILE_SEPARATOR = "!/";
    public static final String PATH_SEPERATOR = "/";
    public static final char PATH_SEPERATOR_CHAR = '/';
    public static final String WINDOWS_PATH_SEPERATOR = "\\";
    public static final String SCHEMA_SEPERATOR = ":";

    public static String standardize(String path) {
        path = StringUtils.trimAllWhitespace((String)path);
        path = StringUtils.cleanPath((String)path);
        if ((path = PathUtil.cleanRepeatlySeperator(path)).endsWith(PATH_SEPERATOR)) {
            return path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static String absolute(String path) {
        if (path.startsWith(PATH_SEPERATOR)) {
            return path;
        }
        if (path.indexOf(SCHEMA_SEPERATOR) >= 0) {
            return path;
        }
        return PATH_SEPERATOR + path;
    }

    public static String cleanRepeatlySeperator(String path) {
        String schema = "";
        String pathToProcess = path;
        int index = path.indexOf("://");
        if (index >= 0) {
            schema = path.substring(0, index + 3);
            index += 3;
            while (index < path.length() && path.charAt(index) == '/') {
                ++index;
            }
            pathToProcess = path.substring(index);
        }
        StringBuilder pathToUse = new StringBuilder();
        boolean hit = false;
        for (int i = 0; i < pathToProcess.length(); ++i) {
            char ch = pathToProcess.charAt(i);
            if (ch == '/') {
                if (hit) continue;
                hit = true;
            } else {
                hit = false;
            }
            pathToUse.append(ch);
        }
        return schema + pathToUse;
    }

    public static String concatPaths(String ... paths) {
        if (paths == null || paths.length == 0) {
            return "";
        }
        StringBuilder path = new StringBuilder();
        for (String p : paths) {
            path.append(p);
            path.append('/');
        }
        return PathUtil.standardize(path.toString());
    }

    @Nullable
    public static String getJarPath() {
        try {
            URL url = PathUtil.class.getResource(PATH_SEPERATOR).toURI().toURL();
            return PathUtil.toFilePath(url);
        }
        catch (Exception e) {
            String path = PathUtil.class.getResource("").getPath();
            return new File(path).getParentFile().getParentFile().getAbsolutePath();
        }
    }

    @Nullable
    public static String toFilePath(@Nullable URL url) {
        if (url == null) {
            return null;
        }
        String protocol = url.getProtocol();
        String file = UrlUtil.decodeURL(url.getPath(), Charsets.UTF_8);
        if (FILE_PROTOCOL.equals(protocol)) {
            return new File(file).getParentFile().getParentFile().getAbsolutePath();
        }
        if (JAR_PROTOCOL.equals(protocol) || ZIP_PROTOCOL.equals(protocol)) {
            int ipos = file.indexOf(JAR_FILE_SEPARATOR);
            if (ipos > 0) {
                file = file.substring(0, ipos);
            }
            if (file.startsWith(FILE_PROTOCOL_PREFIX)) {
                file = file.substring(FILE_PROTOCOL_PREFIX.length());
            }
            return new File(file).getParentFile().getAbsolutePath();
        }
        return file;
    }
}

