/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.util;

import cn.dolphin.core.util.ConvertUtil;
import cn.dolphin.core.util.DoubleUtil;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.util.Assert;

public final class NumberUtil
extends NumberUtils {
    public static final String PRICE_FORMAT_1 = "#,##0.00";
    public static final String PRICE_FORMAT_2 = "0.00";
    public static final String INT = "0";
    public static final String PERCENT_FORMAT_1 = "0%";
    public static final String PERCENT_FORMAT_2 = "0.00%";
    private static char[] cnArr = new char[]{'\u4e00', '\u4e8c', '\u4e09', '\u56db', '\u4e94', '\u516d', '\u4e03', '\u516b', '\u4e5d'};
    private static char[] chArr = new char[]{'\u5341', '\u767e', '\u5343', '\u4e07', '\u4ebf'};

    private NumberUtil() {
    }

    public static boolean isNumber(Class<?> clazz) {
        return clazz == Byte.TYPE || clazz == Short.TYPE || clazz == Integer.TYPE || clazz == Long.TYPE || clazz == Byte.class || clazz == Short.class || clazz == Integer.class || clazz == Long.class || clazz == Float.TYPE || clazz == Double.TYPE || clazz == Float.class || clazz == Double.class;
    }

    public static boolean isInteger(Class<?> clazz) {
        return clazz == Byte.TYPE || clazz == Short.TYPE || clazz == Integer.TYPE || clazz == Long.TYPE || clazz == Byte.class || clazz == Short.class || clazz == Integer.class || clazz == Long.class;
    }

    public static boolean isFloat(Class<?> clazz) {
        return clazz == Float.TYPE || clazz == Double.TYPE || clazz == Float.class || clazz == Double.class;
    }

    public static int toInt(byte[] bytes) {
        int length = bytes.length > 4 ? 4 : bytes.length;
        int result = 0;
        for (int i = 0; i < length; ++i) {
            result = (result << 8) - -128 + bytes[i];
        }
        return result;
    }

    public static String toHexString(byte val) {
        return Integer.toHexString(val & 0xFF | 0x100).substring(1);
    }

    public static byte toByte(String val) {
        try {
            int i = Integer.parseInt(val, 16);
            return (byte)(i % 255);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static String toHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            sb.append(Integer.toHexString(b & 0xFF | 0x100).substring(1));
        }
        return sb.toString();
    }

    public static byte[] toBytes(String val) {
        int j;
        int length = val.length();
        boolean mod2 = (length & 1) == 0;
        int size = mod2 ? length / 2 : length / 2 + 1;
        int k = j = mod2 ? 2 : 1;
        byte[] bytes = new byte[size];
        String s = val.substring(0, j);
        bytes[0] = NumberUtil.toByte(s);
        j += k;
        int i = 1;
        while (i < bytes.length) {
            s = val.substring(j - 2, j);
            bytes[i] = NumberUtil.toByte(s);
            ++i;
            j += 2;
        }
        return bytes;
    }

    public static String toHexString(short val) {
        return Integer.toHexString(val & 0xFFFF | 0x10000).substring(1);
    }

    public static String toHexString(int val) {
        String tmp = Integer.toHexString(val);
        StringBuilder sb = new StringBuilder("00000000");
        sb.replace(8 - tmp.length(), 8, tmp);
        return sb.toString();
    }

    public static String toHexString(long val) {
        String tmp = Long.toHexString(val);
        StringBuilder sb = new StringBuilder("0000000000000000");
        sb.replace(16 - tmp.length(), 16, tmp);
        return sb.toString();
    }

    public static String byteFormat(long size) {
        String[] a = new String[]{"B", "KB", "MB", "GB", "TB", "PB"};
        double val = size;
        int pos = 0;
        while (val >= 1024.0) {
            val /= 1024.0;
            ++pos;
        }
        String s = String.format("%.2f%s", val, a[pos]);
        return s;
    }

    public static int chnToInt(String chn) {
        Assert.hasText((String)chn, (String)"\u4e2d\u6587\u6570\u5b57\u4e0d\u80fd\u4e3a\u7a7a");
        if (NumberUtils.isDigits((String)chn)) {
            return Integer.parseInt(chn);
        }
        int result = 0;
        int temp = 1;
        int count = 0;
        for (int i = 0; i < chn.length(); ++i) {
            int j;
            boolean b = true;
            char c = chn.charAt(i);
            for (j = 0; j < cnArr.length; ++j) {
                if (c != cnArr[j]) continue;
                if (0 != count) {
                    result += temp;
                    temp = 1;
                    count = 0;
                }
                temp = j + 1;
                b = false;
                break;
            }
            if (b) {
                for (j = 0; j < chArr.length; ++j) {
                    if (c != chArr[j]) continue;
                    switch (j) {
                        case 0: {
                            temp *= 10;
                            break;
                        }
                        case 1: {
                            temp *= 100;
                            break;
                        }
                        case 2: {
                            temp *= 1000;
                            break;
                        }
                        case 3: {
                            temp *= 10000;
                            break;
                        }
                        case 4: {
                            temp *= 100000000;
                            break;
                        }
                    }
                    ++count;
                }
            }
            if (i != chn.length() - 1) continue;
            result += temp;
        }
        return result;
    }

    public static final boolean isBlank(Number num) {
        return num == null || num.intValue() == 0;
    }

    public static final String format(Number src, String format) {
        if (src == null) {
            src = 0;
        }
        return new DecimalFormat(format).format(src);
    }

    public static final String format(String src, String format) {
        return NumberUtil.format(DoubleUtil.valueOf(src), format);
    }

    public static final String toString(String num) {
        if (StringUtils.isBlank((CharSequence)num)) {
            num = INT;
        }
        return new BigDecimal(num).toPlainString();
    }

    public static final String toString(double num) {
        return new BigDecimal(num).toPlainString();
    }

    public static final String toString(long num) {
        return new BigDecimal(num).toPlainString();
    }

    public static final String toString(String num, int scale) {
        if (StringUtils.isBlank((CharSequence)num)) {
            num = INT;
        }
        return new BigDecimal(num).setScale(scale, 4).toPlainString();
    }

    public static final String toString(double num, int scale) {
        return new BigDecimal(num).setScale(scale, 4).toPlainString();
    }

    public static final String toString(long num, int scale) {
        return new BigDecimal(num).setScale(scale, 4).toPlainString();
    }

    public static float numFormat2(float f) {
        return new BigDecimal(f).setScale(2, 4).floatValue();
    }

    public static double numFormat2(double d) {
        return new BigDecimal(d).setScale(2, 4).doubleValue();
    }

    public static long numFormat2(long l) {
        return new BigDecimal(l).setScale(0, 4).longValue();
    }

    public static int numFormat2(int i) {
        return new BigDecimal(i).setScale(0, 4).intValue();
    }

    public static boolean isNumber(char ch) {
        return ch > '/' && ch < ':';
    }

    public static String percent(Number number) {
        return new DecimalFormat("##.##%").format(number);
    }

    public static BigDecimal roundHalfUp2(Number number) {
        return NumberUtil.roundHalfUp(2, number);
    }

    public static BigDecimal roundHalfUp(int scale, Number number) {
        return ConvertUtil.toBigDecimal(number).setScale(scale, 4);
    }

    public static String permil(Number number) {
        return new DecimalFormat("##.##\u2030").format(number);
    }

    public static String money(Number number) {
        return new DecimalFormat("##.##\u00a4").format(number);
    }

    public static String ukNumber(Number number) {
        return new DecimalFormat("#,###.#").format(number);
    }

    public static Number parseChnNumber(String number) throws ParseException {
        return new DecimalFormat("#,###.#").parse(number);
    }
}

