/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.util;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NumberFormatUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(NumberFormatUtil.class);

    private NumberFormatUtil() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static String format(Number value, String numberPattern, RoundingMode roundingMode) {
        Validate.notNull((Object)value, (String)"value can't be null!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)numberPattern, (String)"numberPattern can't be null!", (Object[])new Object[0]);
        DecimalFormat decimalFormat = new DecimalFormat(numberPattern);
        decimalFormat.setRoundingMode((RoundingMode)((Object)ObjectUtils.defaultIfNull((Object)((Object)roundingMode), (Object)((Object)RoundingMode.HALF_UP))));
        String result = decimalFormat.format(value);
        if (LOGGER.isTraceEnabled()) {
            String message = "input:[{}],with:[{}]=[{}],localizedPattern:[{}]";
            LOGGER.trace(message, new Object[]{value, numberPattern, result, decimalFormat.toLocalizedPattern()});
        }
        return result;
    }
}

