/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.util;

import cn.dolphin.core.util.UUIDUtil;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.helper.StringUtil;

public final class NameUtil {
    private static final String MOBILE_DIM = "****";
    private static final String EMAIL_DIM = "****";
    private static final String QQ_DIM = "****";
    private static final String IDCARD_DIM = "****************";
    private static final String BANKCARD_DIM = "********";

    public static String mobileDim(String mobile) {
        return mobile.substring(0, 3) + "****" + mobile.substring(mobile.length() - 4);
    }

    public static String emailDim(String email) {
        String[] parts = email.split("@");
        return parts[0].substring(0, 1) + "****" + parts[0].substring(parts[0].length() - 1) + "@" + parts[1];
    }

    public static String qqDim(String qq) {
        return qq.substring(0, 2) + "****" + qq.substring(qq.length() - 2);
    }

    public static String idcardDim(String idcard) {
        if (StringUtils.isBlank((CharSequence)idcard)) {
            return "";
        }
        return idcard.substring(0, 1) + IDCARD_DIM + idcard.substring(idcard.length() - 1);
    }

    public static String bankCardDim(String bankCard) {
        return bankCard.substring(0, 4) + BANKCARD_DIM + bankCard.substring(bankCard.length() - 3);
    }

    public static String getCamelName(String name) {
        if (StringUtil.isBlank((String)name)) {
            return null;
        }
        name = name.toLowerCase();
        while (name.startsWith("_")) {
            name = name.substring(1);
        }
        while (name.endsWith("_")) {
            name = name.substring(0, name.length() - 1);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == '_') {
                sb.append(Character.toUpperCase(name.charAt(++i)));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String getUnderlineName(String name) {
        if (StringUtil.isBlank((String)name)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (i > 0 && Character.isUpperCase(c)) {
                sb.append("_");
            }
            sb.append(c);
        }
        return sb.toString().toLowerCase();
    }

    public static String getFirstUpperName(String name) {
        if (StringUtil.isBlank((String)name)) {
            return null;
        }
        String firstChar = name.substring(0, 1).toUpperCase();
        return firstChar + name.substring(1);
    }

    public static String getFirstLowerName(String name) {
        if (StringUtil.isBlank((String)name)) {
            return null;
        }
        String firstChar = name.substring(0, 1).toLowerCase();
        return firstChar + name.substring(1);
    }

    public static String createUniqueFileName(String fileName) {
        int index = fileName.lastIndexOf(".");
        String suffix = fileName.substring(index);
        String uqName = UUIDUtil.getUUID16() + suffix;
        return uqName;
    }

    public static String createEndSuffixFileName(String fileName, String endSuffix) {
        int index = fileName.lastIndexOf(".");
        String preFileName = fileName.substring(0, index);
        String suffix = fileName.substring(index);
        return preFileName + endSuffix + suffix;
    }
}

