/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.util;

import cn.dolphin.core.exception.ParamRuntimeException;
import cn.dolphin.core.regex.RegexUtil;
import cn.dolphin.core.util.NumberUtil;
import org.apache.commons.lang3.StringUtils;

public final class MoneyUtil {
    public static final String toChinese(String money, boolean isBig) {
        if (StringUtils.isBlank((CharSequence)money) || "0".equals(money)) {
            return "\u96f6\u5143";
        }
        boolean matcher = RegexUtil.matcher(money, "^[1-9]{1}[0-9]*$");
        if (!matcher) {
            throw new ParamRuntimeException("\u91d1\u989d\u5fc5\u987b\u4e3a\u6b63\u6574\u6570");
        }
        if (money.length() > 18) {
            throw new ParamRuntimeException("\u6700\u5927\u8f6c\u6362\u5343\u4e07\u4ebf\u7ea7\u7684\u91d1\u989d");
        }
        char[] hunit = null;
        char[] vunit = null;
        char[] digit = null;
        if (isBig) {
            hunit = new char[]{'\u62fe', '\u4f70', '\u4edf'};
            vunit = new char[]{'\u4e07', '\u4ebf', '\u4e07'};
            digit = new char[]{'\u96f6', '\u58f9', '\u8d30', '\u53c1', '\u8086', '\u4f0d', '\u9646', '\u67d2', '\u634c', '\u7396'};
        } else {
            hunit = new char[]{'\u5341', '\u767e', '\u5343'};
            vunit = new char[]{'\u4e07', '\u4ebf', '\u4e07'};
            digit = new char[]{'\u96f6', '\u4e00', '\u4e8c', '\u4e09', '\u56db', '\u4e94', '\u516d', '\u4e03', '\u516b', '\u4e5d'};
        }
        if (money.length() == 2) {
            return digit[money.charAt(0) - 48] + "\u89d2" + digit[money.charAt(1) - 48] + "\u5206";
        }
        if (money.length() == 1) {
            return digit[money.charAt(0) - 48] + "\u5206";
        }
        String head = money.substring(0, money.length() - 2);
        String rail = money.substring(money.length() - 2);
        String prefix = "";
        String suffix = "";
        suffix = rail.equals("00") ? "\u6574" : digit[rail.charAt(0) - 48] + "\u89d2" + digit[rail.charAt(1) - 48] + "\u5206";
        char[] chDig = head.toCharArray();
        boolean preZero = false;
        int zeroSerNum = 0;
        for (int i = 0; i < chDig.length; ++i) {
            int idx = (chDig.length - i - 1) % 4;
            int vidx = (chDig.length - i - 1) / 4;
            if (chDig[i] == '0') {
                preZero = true;
                zeroSerNum = (byte)(zeroSerNum + 1);
                if (idx != 0 || vidx <= 0 || zeroSerNum >= 4) continue;
                prefix = prefix + vunit[vidx - 1];
                preZero = false;
                continue;
            }
            zeroSerNum = 0;
            if (preZero) {
                prefix = prefix + digit[0];
                preZero = false;
            }
            prefix = prefix + digit[chDig[i] - 48];
            if (idx > 0) {
                prefix = prefix + hunit[idx - 1];
            }
            if (idx != 0 || vidx <= 0) continue;
            prefix = prefix + vunit[vidx - 1];
        }
        return prefix + "\u5143" + suffix;
    }

    public static final String toChinese(long money, boolean isBig) {
        return MoneyUtil.toChinese(String.valueOf(money), isBig);
    }

    public static final String toChinese(double money, boolean isBig) {
        return MoneyUtil.toChinese((long)(money * 100.0), isBig);
    }

    public static final String toYuan(String fen) {
        return NumberUtil.format(fen, "0.00");
    }

    public static final Long toFen(String yuan) {
        String fen;
        String[] arr = yuan.split("\\.");
        yuan = arr.length == 1 ? arr[0] + "00" : ((fen = arr[1]).length() == 1 ? arr[0] + fen + "0" : (fen.length() == 2 ? arr[0] + fen : arr[0] + fen.substring(0, 2)));
        return Long.valueOf(yuan);
    }
}

