/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.util;

public final class MathUtil {
    public static int ceilDiv(int x, int y) {
        if (x % y > 0) {
            return x / y + 1;
        }
        return x / y;
    }

    public static long ceilDiv(long x, long y) {
        if (x % y > 0L) {
            return x / y + 1L;
        }
        return x / y;
    }

    public static long ceilDiv(long x, int y) {
        if (x % (long)y > 0L) {
            return x / (long)y + 1L;
        }
        return x / (long)y;
    }

    public static long ceilDiv(int x, long y) {
        if ((long)x % y > 0L) {
            return (long)x / y + 1L;
        }
        return (long)x / y;
    }

    public static int add(int a, int b) {
        int xor = a ^ b;
        int temp = (a & b) << 1;
        if (temp == 0) {
            return xor;
        }
        return MathUtil.add(xor, temp);
    }

    public static int minus(int a, int b) {
        int minus = ~(b - 1);
        return MathUtil.add(a, minus);
    }

    public static int multi(int a, int b) {
        int sum = 0;
        int index = 0;
        while (b != 0) {
            if ((b & 1) == 1) {
                sum = MathUtil.add(sum, a << index);
            }
            b >>= 1;
            index = MathUtil.add(index, 1);
        }
        return sum;
    }

    public static int sub(int a, int b) {
        int xor = a ^ b;
        a = a < 0 ? -a : a;
        int n = b = b < 0 ? -b : b;
        if (b == 0) {
            throw new IllegalArgumentException("\u9664\u6570\u4e0d\u80fd\u4e3a0");
        }
        int minus = 0;
        int index = -1;
        while (minus >= 0) {
            a = minus = MathUtil.minus(a, b);
            index = MathUtil.add(index, 1);
        }
        if (xor > 0) {
            return index;
        }
        return -index;
    }
}

