/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.util;

public class MaskUtil {
    private MaskUtil() {
    }

    public static String mobile(String mobile) {
        if (mobile == null || mobile.equals("")) {
            return "\u6ca1\u6709\u586b\u5199";
        }
        if (mobile.length() < 9) {
            return "\u624b\u673a\u53f7\u7801\u9519\u8bef";
        }
        StringBuilder sb = new StringBuilder(16);
        sb.append(mobile.substring(0, 3));
        sb.append("****");
        sb.append(mobile.substring(7));
        return sb.toString();
    }

    public static String maskMobileNo(String mobileNo) {
        if (null == mobileNo || "".equals(mobileNo) || mobileNo.length() < 6) {
            return mobileNo;
        }
        String maskStr = MaskUtil.getMaskStr(mobileNo.length() - 5);
        String prefix = mobileNo.substring(0, 3);
        String subfix = mobileNo.substring(mobileNo.length() - 2);
        return prefix + maskStr + subfix;
    }

    public static String maskUserName(String userName) {
        if (null == userName || "".equals(userName) || userName.length() < 2) {
            return userName;
        }
        String maskStr = MaskUtil.getMaskStr(userName.length() - 1);
        String subfix = userName.substring(userName.length() - 1);
        return maskStr + subfix;
    }

    public static String maskIdNo(String idNo) {
        if (null == idNo || "".equals(idNo) || idNo.length() < 3) {
            return idNo;
        }
        String maskStr = MaskUtil.getMaskStr(idNo.length() - 2);
        String prefix = idNo.substring(0, 1);
        String subfix = idNo.substring(idNo.length() - 1);
        return prefix + maskStr + subfix;
    }

    public static String maskBankCardNo(String bankCardNo) {
        if (null == bankCardNo || "".equals(bankCardNo) || bankCardNo.length() < 5) {
            return bankCardNo;
        }
        String maskStr = MaskUtil.getMaskStr(bankCardNo.length() - 4);
        String subfix = bankCardNo.substring(bankCardNo.length() - 4);
        return maskStr + subfix;
    }

    private static String getMaskStr(int len) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            sb.append("*");
        }
        return sb.toString();
    }

    public static String email(String email) {
        if (email == null || email.equals("")) {
            return "\u6ca1\u6709\u586b\u5199";
        }
        int at = email.indexOf(64);
        if (at < 0) {
            return "\u7535\u5b50\u90ae\u7bb1\u9519\u8bef";
        }
        String pre = email.substring(0, at);
        StringBuilder sb = new StringBuilder(16);
        sb.append(pre.substring(0, pre.length() / 2));
        sb.append("****");
        sb.append(email.substring(at));
        return sb.toString();
    }

    public static String token(String token) {
        if (token == null || token.isEmpty()) {
            return "\u6ca1\u6709\u586b\u5199";
        }
        int start = token.length() / 2;
        StringBuilder t = new StringBuilder(token);
        t.replace(start, t.length() - start, "*****");
        return t.toString();
    }
}

