/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.util;

import cn.dolphin.core.util.StrUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.AuthenticationFailedException;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailUtil.class);
    private MimeMessage mimeMsg;
    private Session session;
    private Properties props;
    private String username;
    private String password;
    private Multipart multiPart;
    private Boolean isSend;
    private List<String> attachFileNames;

    public MailUtil(String smtp, String from, String username, String password) {
        this(smtp, from, username, password, true);
    }

    public MailUtil(String smtp, String from, String username, String password, Boolean isSend) {
        this.username = username;
        this.password = password;
        this.isSend = isSend;
        this.props = System.getProperties();
        this.props.put("mail.smtp.host", smtp);
        this.props.put("mail.smtp.auth", "true");
        try {
            this.session = Session.getDefaultInstance((Properties)this.props, null);
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u90ae\u4ef6\u4f1a\u8bdd\u9519\u8bef\uff01" + e);
            return;
        }
        try {
            this.mimeMsg = new MimeMessage(this.session);
        }
        catch (Exception e) {
            LOGGER.error("\u521b\u5efaMIME\u90ae\u4ef6\u5bf9\u8c61\u5931\u8d25\uff01" + e);
            return;
        }
        try {
            this.mimeMsg.setFrom((Address)new InternetAddress(from));
        }
        catch (Exception e) {
            LOGGER.error("\u53d1\u9001\u90ae\u4ef6\u5f02\u5e38: " + e.getMessage(), (Throwable)e);
            return;
        }
    }

    public boolean setSubject(String mailSubject) {
        try {
            this.mimeMsg.setSubject(mailSubject);
            return true;
        }
        catch (Exception e) {
            LOGGER.error("\u5b9a\u4e49\u90ae\u4ef6\u4e3b\u9898\u53d1\u751f\u9519\u8bef\uff01");
            return false;
        }
    }

    public boolean setBody(String mailBody) {
        try {
            MimeBodyPart bodyPart = new MimeBodyPart();
            bodyPart.setContent((Object)mailBody, "text/html;charset=UTF-8");
            if (this.multiPart == null) {
                this.multiPart = new MimeMultipart();
            }
            this.multiPart.addBodyPart((BodyPart)bodyPart);
            List<String> afns = this.getAttachFileNames();
            if (afns != null && afns.size() != 0) {
                for (String attachFile : afns) {
                    bodyPart = new MimeBodyPart();
                    FileDataSource fds = new FileDataSource(attachFile);
                    bodyPart.setDataHandler(new DataHandler((DataSource)fds));
                    bodyPart.setFileName(MimeUtility.encodeText((String)fds.getName()));
                    this.multiPart.addBodyPart((BodyPart)bodyPart);
                }
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.error("\u5b9a\u4e49\u90ae\u4ef6\u6b63\u6587\u65f6\u53d1\u751f\u9519\u8bef\uff01" + e);
            return false;
        }
    }

    public boolean setTo(String tos) {
        if (StrUtil.isEmpty((CharSequence)tos)) {
            return false;
        }
        try {
            List<String> toArr = StrUtil.toArray(tos, ",");
            ArrayList<InternetAddress> address = new ArrayList<InternetAddress>();
            for (String to : toArr) {
                if (!StrUtil.isNotEmpty((CharSequence)to)) continue;
                address.add(new InternetAddress(to));
            }
            this.mimeMsg.setRecipients(Message.RecipientType.TO, (Address[])address.toArray(new InternetAddress[address.size()]));
            return true;
        }
        catch (Exception e) {
            LOGGER.error("\u8bbe\u7f6e\u6536\u4ef6\u4eba\u5f02\u5e38: " + e.getMessage());
            return false;
        }
    }

    public boolean setCopyTo(String copyto) {
        if (copyto == null) {
            return false;
        }
        try {
            this.mimeMsg.setRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)copyto));
            return true;
        }
        catch (Exception e) {
            LOGGER.error("\u8bbe\u7f6e\u6284\u9001\u4eba\u5f02\u5e38: " + e.getMessage());
            return false;
        }
    }

    private boolean sendOut() {
        if (this.isSend != null && !this.isSend.booleanValue()) {
            return false;
        }
        String host = (String)this.props.get("mail.smtp.host");
        try {
            this.mimeMsg.setContent(this.multiPart);
            this.mimeMsg.saveChanges();
            LOGGER.info("\u90ae\u4ef6\u53d1\u9001\u4e2d....");
            Session mailSession = Session.getInstance((Properties)this.props, null);
            Transport transport = mailSession.getTransport("smtp");
            transport.connect(host, this.username, this.password);
            transport.sendMessage((Message)this.mimeMsg, this.mimeMsg.getRecipients(Message.RecipientType.TO));
            LOGGER.info("\u53d1\u9001\u6210\u529f\uff01");
            transport.close();
            return true;
        }
        catch (AuthenticationFailedException e) {
            LOGGER.error("host[" + host + "]-username[" + this.username + "]-password[" + this.password + "] \u9274\u6743\u5931\u8d25!" + e.getMessage());
            return false;
        }
        catch (Exception e) {
            LOGGER.error("\u53d1\u9001\u5931\u8d25\uff01" + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean send(String tos, String title, String content) {
        if (this.isSend != null && !this.isSend.booleanValue()) {
            return false;
        }
        if (!this.setSubject(title)) {
            return false;
        }
        if (!this.setBody(content)) {
            return false;
        }
        if (!this.setTo(tos)) {
            return false;
        }
        return this.sendOut();
    }

    public boolean send(String tos, String copyto, String title, String content) {
        if (this.isSend != null && !this.isSend.booleanValue()) {
            return false;
        }
        if (!this.setSubject(title)) {
            return false;
        }
        if (!this.setBody(content)) {
            return false;
        }
        if (!this.setTo(tos)) {
            return false;
        }
        if (!this.setCopyTo(copyto)) {
            return false;
        }
        return this.sendOut();
    }

    public List<String> getAttachFileNames() {
        return this.attachFileNames;
    }

    public void setAttachFileNames(List<String> attachFileNames) {
        this.attachFileNames = attachFileNames;
    }
}

