/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class MacUtil {
    public static String getOSName() {
        return System.getProperty("os.name").toLowerCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUnixMACAddress() {
        String mac = null;
        BufferedReader bufferedReader = null;
        Process process = null;
        try {
            process = Runtime.getRuntime().exec("ifconfig eth0");
            bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = null;
            int index = -1;
            while ((line = bufferedReader.readLine()) != null) {
                index = line.toLowerCase().indexOf("hwaddr");
                if (index == -1) continue;
                mac = line.substring(index + "hwaddr".length() + 1).trim();
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            bufferedReader = null;
            process = null;
        }
        return mac;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getLinuxMACAddress() {
        String mac = null;
        BufferedReader bufferedReader = null;
        Process process = null;
        try {
            process = Runtime.getRuntime().exec("ifconfig eth0");
            bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = null;
            int index = -1;
            while ((line = bufferedReader.readLine()) != null) {
                index = line.toLowerCase().indexOf("\u786c\u4ef6\u5730\u5740");
                if (index == -1) continue;
                mac = line.substring(index + 4).trim();
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            bufferedReader = null;
            process = null;
        }
        if (mac == null) {
            return MacUtil.getUnixMACAddress();
        }
        return mac;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getWindowsMACAddress() {
        String mac = null;
        BufferedReader bufferedReader = null;
        Process process = null;
        try {
            process = Runtime.getRuntime().exec("ipconfig /all");
            bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = null;
            int index = -1;
            while ((line = bufferedReader.readLine()) != null) {
                if (line.split("-").length == 6) {
                    index = line.indexOf(":");
                    if (index != -1) {
                        mac = line.substring(index + 1).trim();
                    }
                } else {
                    index = line.toLowerCase().indexOf("\u7269\u7406\u5730\u5740");
                    if (index == -1) continue;
                    index = line.indexOf(":");
                    if (index != -1) {
                        mac = line.substring(index + 1).trim();
                    }
                }
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            bufferedReader = null;
            process = null;
        }
        return mac;
    }

    public static String getMac() {
        String os = MacUtil.getOSName();
        String mac = os.startsWith("windows") ? MacUtil.getWindowsMACAddress() : (os.startsWith("linux") ? MacUtil.getLinuxMACAddress() : MacUtil.getUnixMACAddress());
        return mac == null ? "" : mac;
    }

    public static String getMacAddress() {
        String os = MacUtil.getOSName();
        if (os.startsWith("windows")) {
            return MacUtil.getWindowsMACAddress();
        }
        if (os.startsWith("linux")) {
            return MacUtil.getLinuxMACAddress();
        }
        return MacUtil.getUnixMACAddress();
    }

    public static boolean isWindowsOS() {
        boolean isWindowsOS = false;
        String osName = System.getProperty("os.name");
        if (osName.toLowerCase().indexOf("windows") > -1) {
            isWindowsOS = true;
        }
        return isWindowsOS;
    }
}

