/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MD5Util {
    private static final Logger logger = LoggerFactory.getLogger(MD5Util.class);
    private static final String[] hexDigits = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static MessageDigest messageDigest = null;
    private static byte[] lock = new byte[1];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileMD5String(File file) {
        String ret = "";
        byte[] byArray = lock;
        synchronized (lock) {
            FileInputStream in = null;
            FileChannel ch = null;
            try {
                in = new FileInputStream(file);
                ch = in.getChannel();
                MappedByteBuffer byteBuffer = ch.map(FileChannel.MapMode.READ_ONLY, 0L, file.length());
                messageDigest.update(byteBuffer);
                ret = MD5Util.bytesToHex(messageDigest.digest());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (ch != null) {
                    try {
                        ch.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return ret;
        }
    }

    public static String getFileMD5String(String fileName) {
        return MD5Util.getFileMD5String(new File(fileName));
    }

    public static String getMD5String(String str) {
        return MD5Util.getMD5String(str.getBytes());
    }

    public static String md5(String target) {
        return DigestUtils.md5Hex((String)target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMD5String(byte[] bytes) {
        String result = null;
        byte[] byArray = lock;
        synchronized (lock) {
            messageDigest.update(bytes);
            result = MD5Util.bytesToHex(messageDigest.digest());
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return result;
        }
    }

    public static String digest(byte[] data) {
        return DigestUtils.md5Hex((byte[])data);
    }

    public static String digest(String data) {
        return DigestUtils.md5Hex((String)data);
    }

    public static String digest(InputStream data) {
        try {
            return DigestUtils.md5Hex((InputStream)data);
        }
        catch (IOException e) {
            throw new RuntimeException("MD5\u7b7e\u540d\u5931\u8d25", e);
        }
    }

    public static boolean checkPassword(String pwd, String md5) {
        return MD5Util.getMD5String(pwd).equalsIgnoreCase(md5);
    }

    public static boolean checkPassword(char[] pwd, String md5) {
        return MD5Util.checkPassword(new String(pwd), md5);
    }

    public static boolean checkFileMD5(File file, String md5) {
        return MD5Util.getFileMD5String(file).equalsIgnoreCase(md5);
    }

    public static boolean checkFileMD5(String fileName, String md5) {
        return MD5Util.checkFileMD5(new File(fileName), md5);
    }

    public static String bytesToHex(byte[] bytes) {
        return MD5Util.bytesToHex(bytes, 0, bytes.length);
    }

    public static String bytesToHex(byte[] bytes, int start, int end) {
        StringBuilder sb = new StringBuilder();
        for (int i = start; i < start + end; ++i) {
            sb.append(MD5Util.byteToHex(bytes[i]));
        }
        return sb.toString();
    }

    public static String byteToHex(byte bt) {
        return HEX_DIGITS[(bt & 0xF0) >> 4] + "" + HEX_DIGITS[bt & 0xF];
    }

    public static String md5(InputStream is) {
        try {
            StringBuffer md5 = new StringBuffer();
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] dataBytes = new byte[1024];
            int nread = 0;
            while ((nread = is.read(dataBytes)) != -1) {
                md.update(dataBytes, 0, nread);
            }
            byte[] mdbytes = md.digest();
            for (int i = 0; i < mdbytes.length; ++i) {
                md5.append(Integer.toString((mdbytes[i] & 0xFF) + 256, 16).substring(1));
            }
            return md5.toString();
        }
        catch (Exception e) {
            logger.error("md5 InputStream  failed:" + e.getMessage());
            return null;
        }
    }

    public static Map<String, Object> getUrlParams(String param) {
        HashMap<String, Object> map = new HashMap<String, Object>(0);
        if (StringUtils.isBlank((CharSequence)param)) {
            return map;
        }
        String[] params = param.split("&");
        for (int i = 0; i < params.length; ++i) {
            String[] p = params[i].split("=");
            if (p.length != 2) continue;
            map.put(p[0], p[1]);
        }
        return map;
    }

    public static String getUrlParamsByMap(Map<String, Object> map) {
        if (map == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            sb.append(entry.getKey() + "=" + entry.getValue());
            sb.append("&");
        }
        String s = sb.toString();
        if (s.endsWith("&")) {
            s = StringUtils.substringBeforeLast((String)s, (String)"&");
        }
        return s;
    }

    private static String byteArrayToHexString(byte[] b) {
        StringBuffer resultSb = new StringBuffer();
        for (int i = 0; i < b.length; ++i) {
            resultSb.append(MD5Util.byteToHexString(b[i]));
        }
        return resultSb.toString();
    }

    private static String byteToHexString(byte b) {
        int n = b;
        if (n < 0) {
            n += 256;
        }
        int d1 = n / 16;
        int d2 = n % 16;
        return hexDigits[d1] + hexDigits[d2];
    }

    public static String MD5Encode(String origin, String charsetname) {
        String resultString = null;
        try {
            resultString = new String(origin);
            MessageDigest md = MessageDigest.getInstance("MD5");
            resultString = charsetname == null || "".equals(charsetname) ? MD5Util.byteArrayToHexString(md.digest(resultString.getBytes())) : MD5Util.byteArrayToHexString(md.digest(resultString.getBytes(charsetname)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return resultString;
    }

    public static String encryptPasswordOnce(String pasw) {
        try {
            MessageDigest digest = MessageDigest.getInstance("md5");
            byte[] result = digest.digest(pasw.getBytes());
            StringBuffer buffer = new StringBuffer();
            for (byte b : result) {
                int number = b & 0xFF;
                String str = Integer.toHexString(number);
                if (str.length() == 1) {
                    buffer.append("0");
                }
                buffer.append(str);
            }
            return buffer.toString();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String encryptPasswordTwice(String pasw) {
        return MD5Util.encryptPasswordOnce(MD5Util.encryptPasswordOnce(pasw));
    }

    public static String encode(String code) {
        if (code == null || "".equals(code.trim())) {
            throw new RuntimeException("the code which will be encoded with 'MD5' must not be null or empty!");
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(code.getBytes("utf-8"));
            byte[] bs = md.digest();
            StringBuilder sb = new StringBuilder();
            for (byte b : bs) {
                int v = b & 0xFF;
                if (v < 16) {
                    sb.append(0);
                }
                sb.append(Integer.toHexString(v));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return null;
    }

    static {
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException ne) {
            logger.error("NoSuchAlgorithmException: md5", (Throwable)ne);
        }
    }
}

