/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.util;

import cn.dolphin.core.util.ArrayUtil;
import cn.dolphin.core.util.StrUtil;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Spliterators;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class ListUtil {
    private static Pattern kk = Pattern.compile("(\\{[^\\}]*\\})");

    public static List<String> extractMessageByRegular(String msg) {
        ArrayList<String> list = new ArrayList<String>();
        Matcher m = kk.matcher(msg);
        while (m.find()) {
            list.add(m.group().substring(1, m.group().length() - 1));
        }
        return list;
    }

    public static boolean isEmpty(List list) {
        return list == null || list.size() == 0;
    }

    public static boolean isNotEmpty(List list) {
        return list != null && list.size() != 0;
    }

    public static List distinct(List list) {
        HashSet set = new HashSet();
        ArrayList newList = new ArrayList();
        for (Object element : list) {
            if (!set.add(element)) continue;
            newList.add(element);
        }
        return newList;
    }

    public static List<String> toStringList(List list) {
        ArrayList<String> newList = new ArrayList<String>(list.size());
        if (ListUtil.isEmpty(list)) {
            return newList;
        }
        for (int i = 0; i < list.size(); ++i) {
            newList.add(i, String.valueOf(list.get(i)));
        }
        return newList;
    }

    public static List<Integer> toIntList(List list) {
        ArrayList<Integer> newList = new ArrayList<Integer>(list.size());
        if (ListUtil.isEmpty(list)) {
            return newList;
        }
        for (int i = 0; i < list.size(); ++i) {
            newList.add(i, (int)((Integer)list.get(i)));
        }
        return newList;
    }

    public static List<Integer> toIntListByBoolean(List<Boolean> list) {
        ArrayList<Integer> newList = new ArrayList<Integer>(list.size());
        if (ListUtil.isEmpty(list)) {
            return newList;
        }
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).booleanValue()) {
                newList.add(i, 0);
                continue;
            }
            newList.add(i, 1);
        }
        return newList;
    }

    public static List<Double> toDoubleList(List list) {
        ArrayList<Double> newList = new ArrayList<Double>(list.size());
        if (ListUtil.isEmpty(list)) {
            return newList;
        }
        for (int i = 0; i < list.size(); ++i) {
            newList.add(i, (double)((Double)list.get(i)));
        }
        return newList;
    }

    public static List<Float> toFloatList(List list) {
        ArrayList<Float> newList = new ArrayList<Float>(list.size());
        if (ListUtil.isEmpty(list)) {
            return newList;
        }
        for (int i = 0; i < list.size(); ++i) {
            newList.add(i, Float.valueOf(((Float)list.get(i)).floatValue()));
        }
        return newList;
    }

    public static List<Long> toLongList(List list) {
        ArrayList<Long> newList = new ArrayList<Long>(list.size());
        if (ListUtil.isEmpty(list)) {
            return newList;
        }
        for (int i = 0; i < list.size(); ++i) {
            newList.add(i, (long)((Long)list.get(i)));
        }
        return newList;
    }

    public static List<Short> toShortList(List list) {
        ArrayList<Short> newList = new ArrayList<Short>(list.size());
        if (ListUtil.isEmpty(list)) {
            return newList;
        }
        for (int i = 0; i < list.size(); ++i) {
            newList.add(i, (short)((Short)list.get(i)));
        }
        return newList;
    }

    public static List<Byte> toByteList(List list) {
        ArrayList<Byte> newList = new ArrayList<Byte>(list.size());
        if (ListUtil.isEmpty(list)) {
            return newList;
        }
        for (int i = 0; i < list.size(); ++i) {
            newList.add(i, (byte)((Byte)list.get(i)));
        }
        return newList;
    }

    public static String join(List list) {
        if (ListUtil.isEmpty(list)) {
            return "";
        }
        if (list.size() == 1) {
            return "[" + String.valueOf(list.get(0)) + "]";
        }
        StringBuffer result = new StringBuffer("[");
        for (int i = 0; i < list.size(); ++i) {
            if (i == list.size() - 1) {
                result.append(list.get(i) + "]");
                continue;
            }
            result.append(list.get(i) + ",");
        }
        return result.toString();
    }

    public static String join(List list, String splitStr) {
        if (list == null || list.size() == 0) {
            return "";
        }
        if (list.size() == 1) {
            return String.valueOf(list.get(0));
        }
        StringBuffer result = new StringBuffer("");
        for (int i = 0; i < list.size(); ++i) {
            if (i == list.size() - 1) {
                result.append(list.get(i));
                continue;
            }
            result.append(list.get(i) + splitStr);
        }
        return result.toString();
    }

    public static List shuffle(List list) {
        Collections.shuffle(list);
        return list;
    }

    public static final <T> Set<T> toSet(List<T> list) {
        if (ListUtil.isEmpty(list)) {
            return null;
        }
        return new LinkedHashSet<T>(list);
    }

    public static <T> List<List<T>> spliteList(List<T> list, int batch) {
        Double size = Math.ceil((float)list.size() * 1.0f / (float)batch);
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        for (int i = 0; i < size.intValue(); ++i) {
            int fromIndex = i * batch;
            int endIndex = fromIndex + batch > list.size() ? list.size() : fromIndex + batch;
            result.add(list.subList(fromIndex, endIndex));
        }
        return result;
    }

    public static int size(Object[] list) {
        if (list == null) {
            return 0;
        }
        return list.length;
    }

    public static int size(List<?> list) {
        if (list == null) {
            return 0;
        }
        return list.size();
    }

    public static List<String> uniq(List<String> list) {
        if (list == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String str : list) {
            if (result.contains(str)) continue;
            result.add(str);
        }
        return result;
    }

    public static List<?> removeNull(List<?> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        Iterator<?> iterator = list.iterator();
        while (iterator.hasNext()) {
            Object next = iterator.next();
            if (next != null) continue;
            iterator.remove();
        }
        return list;
    }

    public static <E> Map<String, E> listToMap(List<E> list, String filedName) throws Exception {
        if (null == filedName || "".equals(filedName)) {
            throw new Exception("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == list) {
            throw new Exception("list\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String[] filedNameArr = filedName.split(",");
        ArrayList<String> nameListtemp = new ArrayList<String>();
        for (String s : filedNameArr) {
            if (null == s || "".equals(s)) {
                throw new Exception("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String name = "get" + StrUtil.makeFirstLetterUpperCase(s);
            nameListtemp.add(name);
        }
        final ArrayList<String> nameList = nameListtemp;
        ImmutableMap returnMap = new HashMap();
        if (list.get(0) instanceof Map) {
            for (int i = 0; i < list.size(); ++i) {
                Map ma = (Map)list.get(i);
                String returnStr = "";
                for (int j = 0; j < filedNameArr.length; ++j) {
                    returnStr = returnStr + ma.get(filedNameArr[j]).toString();
                    if (j >= filedNameArr.length - 1) continue;
                    returnStr = returnStr + ",";
                }
                returnMap.put(returnStr, list.get(i));
            }
        } else {
            returnMap = Maps.uniqueIndex(list, (Function)new Function<E, String>(){

                public String apply(E site) {
                    String returnStr = "";
                    ArrayList<Method> methodList = new ArrayList<Method>();
                    try {
                        int i;
                        for (i = 0; i < nameList.size(); ++i) {
                            methodList.add(site.getClass().getMethod((String)nameList.get(i), new Class[0]));
                        }
                        if (methodList.size() > 0) {
                            for (i = 0; i < methodList.size(); ++i) {
                                returnStr = returnStr + (((Method)methodList.get(i)).invoke(site, new Object[0]) == null ? "" : ((Method)methodList.get(i)).invoke(site, new Object[0]));
                                if (i >= methodList.size() - 1) continue;
                                returnStr = returnStr + ",";
                            }
                        }
                        return returnStr;
                    }
                    catch (NoSuchMethodException e) {
                        e.printStackTrace();
                    }
                    catch (SecurityException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                    return returnStr;
                }
            });
        }
        if (null == returnMap) {
            return null;
        }
        return returnMap;
    }

    public static List<String> removeSameItem(List<String> list) {
        ArrayList<String> difList = new ArrayList<String>();
        for (String t : list) {
            if (t == null || difList.contains(t)) continue;
            difList.add(t);
        }
        return difList;
    }

    public static String[] toArray(List<String> list) {
        if (ListUtil.isEmpty(list)) {
            return new String[0];
        }
        return (String[])list.stream().toArray(String[]::new);
    }

    public static List<String> toArray(String[] arrays) {
        if (ArrayUtil.isEmpty((Object[])arrays)) {
            return null;
        }
        List<String> list = Stream.of(arrays).collect(Collectors.toList());
        return list;
    }

    public static <T> ArrayList<T> toArrayList(Iterator<T> iterator) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false).collect(Collectors.toCollection(ArrayList::new));
    }

    public static <T> ArrayList<T> newArrayList(Collection<T> src) {
        ArrayList<T> l = new ArrayList<T>(src.size());
        Iterator<T> ite = src.iterator();
        while (ite.hasNext()) {
            l.add(ite.next());
        }
        return l;
    }

    @SafeVarargs
    public static <T> ArrayList<T> newArrayList(T ... t) {
        ArrayList l = new ArrayList();
        Collections.addAll(l, t);
        return l;
    }

    @SafeVarargs
    public static <T> LinkedList<T> newLinkedList(T ... t) {
        LinkedList l = new LinkedList();
        Collections.addAll(l, t);
        return l;
    }
}

