/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;

public class JarUtil {
    public static File createTempDirectory() {
        String tmpPath = System.getProperty("java.io.tmpdir");
        long current = System.currentTimeMillis();
        File tmpDir = new File(tmpPath + File.separator + "patchDir" + current);
        if (tmpDir.exists()) {
            tmpDir.delete();
            return JarUtil.createTempDirectory();
        }
        tmpDir.mkdirs();
        return tmpDir;
    }

    public static void unJar(String jarFile, String destination) {
        File jar = new File(jarFile);
        File dir = new File(destination);
        JarUtil.unJar(jar, dir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unJar(File jarFile, File destination) {
        ZipFile jar = null;
        try {
            if (!destination.exists()) {
                destination.mkdirs();
            }
            jar = new JarFile(jarFile);
            Enumeration<JarEntry> en = ((JarFile)jar).entries();
            JarEntry entry = null;
            InputStream input = null;
            BufferedOutputStream bos = null;
            File file = null;
            while (en.hasMoreElements()) {
                entry = en.nextElement();
                input = ((JarFile)jar).getInputStream(entry);
                file = new File(destination, entry.getName());
                if (entry.isDirectory()) {
                    file.mkdirs();
                    continue;
                }
                file.getParentFile().mkdirs();
                bos = new BufferedOutputStream(new FileOutputStream(file));
                byte[] buffer = new byte[8192];
                int length = -1;
                while ((length = input.read(buffer)) != -1) {
                    bos.write(buffer, 0, length);
                }
                bos.close();
                input.close();
            }
            Manifest mf = ((JarFile)jar).getManifest();
            if (mf != null) {
                File f = new File(destination, "META-INF/MANIFEST.MF");
                File parent = f.getParentFile();
                if (!parent.exists()) {
                    parent.mkdirs();
                }
                FileOutputStream out = new FileOutputStream(f);
                mf.write(out);
                out.flush();
                ((OutputStream)out).close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (jar != null) {
                try {
                    jar.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static String convertPackageToPath(String packageName) {
        String sep = File.separator;
        if (packageName.equals("")) {
            return sep;
        }
        return packageName.replace(".", sep) + sep;
    }

    public static void addFileToJar(String packageName, File sourceFile, File targetJarFile) {
        try {
            File tmpDir = JarUtil.createTempDirectory();
            JarUtil.unJar(targetJarFile, tmpDir);
            String packagePath = JarUtil.convertPackageToPath(packageName);
            File targetFile = new File(tmpDir, packagePath);
            if (sourceFile.isDirectory()) {
                FileUtils.copyDirectoryToDirectory((File)sourceFile, (File)targetFile);
            } else {
                FileUtils.copyFileToDirectory((File)sourceFile, (File)targetFile);
            }
            JarUtil.jar(targetJarFile, tmpDir);
            FileUtils.deleteDirectory((File)tmpDir);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void delFileFromJar(String packageName, File sourceFile, File targetJarFile) {
        try {
            File tmpDir = JarUtil.createTempDirectory();
            JarUtil.unJar(targetJarFile, tmpDir);
            String packagePath = JarUtil.convertPackageToPath(packageName);
            File targetFile = new File(tmpDir, packagePath);
            targetFile = new File(targetFile, sourceFile.getName());
            if (targetFile.exists()) {
                targetFile.delete();
            }
            JarUtil.jar(targetJarFile, tmpDir);
            FileUtils.deleteDirectory((File)tmpDir);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void jar(File jarFile, File tmpDirectory) {
        if (jarFile == null || tmpDirectory == null || !jarFile.exists() || !tmpDirectory.exists()) {
            return;
        }
        try {
            ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(jarFile));
            List<File> fileList = JarUtil.getAllFiles(tmpDirectory);
            for (int i = 0; i < fileList.size(); ++i) {
                File file = fileList.get(i);
                zos.putNextEntry(new ZipEntry(JarUtil.getEntryName(tmpDirectory, file)));
                if (file.isDirectory()) continue;
                BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
                byte[] buffer = new byte[8192];
                int length = -1;
                while ((length = bis.read(buffer)) != -1) {
                    zos.write(buffer, 0, length);
                }
                bis.close();
                zos.closeEntry();
            }
            zos.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static List<File> getAllFiles(File file) {
        ArrayList<File> result = new ArrayList<File>();
        if (file != null) {
            if (file.isDirectory()) {
                File[] ls;
                for (File t : ls = file.listFiles()) {
                    List<File> tLst = JarUtil.getAllFiles(t);
                    result.addAll(tLst);
                }
            } else {
                result.add(file);
            }
        }
        return result;
    }

    public static String getEntryName(File baseFile, File file) {
        String fileName = file.getPath();
        String result = "";
        try {
            result = baseFile.getParentFile().getParentFile() == null ? fileName.substring(baseFile.getPath().length()) : fileName.substring(baseFile.getPath().length() + 1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }
}

