/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class GZipUtil {
    public static byte[] compress(String source, String charsetName) throws IOException {
        return GZipUtil.compress(source.getBytes(charsetName));
    }

    public static byte[] compress(String source) throws IOException {
        return GZipUtil.compress(source.getBytes());
    }

    public static void compress(byte[] source, OutputStream out) throws IOException {
        GZIPOutputStream gzip = null;
        try {
            gzip = new GZIPOutputStream(out);
            gzip.write(source);
            gzip.finish();
            out.flush();
        }
        catch (IOException e) {
            if (gzip != null) {
                try {
                    gzip.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw e;
        }
    }

    public static byte[] compress(byte[] source) throws IOException {
        ByteArrayOutputStream out = null;
        try {
            out = new ByteArrayOutputStream();
            GZipUtil.compress(source, out);
            return out.toByteArray();
        }
        catch (IOException e) {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw e;
        }
    }

    public static byte[] decompressBytes(InputStream in) throws IOException {
        GZIPInputStream gzip = null;
        byte[] rtn = null;
        try {
            gzip = new GZIPInputStream(in);
            byte[] cache = null;
            int readSize = 1;
            ArrayList<byte[]> al = new ArrayList<byte[]>();
            ArrayList<Integer> al2 = new ArrayList<Integer>();
            while (readSize > 0) {
                cache = new byte[1024];
                readSize = gzip.read(cache);
                if (readSize <= 0) continue;
                al.add(cache);
                al2.add(new Integer(readSize));
            }
            int Len = 0;
            for (Integer inte : al2) {
                Len += inte.intValue();
            }
            rtn = new byte[Len];
            int k = 0;
            for (int i = 0; i < al.size(); ++i) {
                byte[] bytes = (byte[])al.get(i);
                for (int j = 0; j < (Integer)al2.get(i); ++j) {
                    rtn[k] = bytes[j];
                    ++k;
                }
            }
            return rtn;
        }
        catch (IOException e) {
            if (gzip != null) {
                try {
                    gzip.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw e;
        }
    }

    public static byte[] decompressBytes(byte[] value) throws IOException {
        ByteArrayInputStream in = null;
        try {
            in = new ByteArrayInputStream(value);
            return GZipUtil.decompressBytes(in);
        }
        catch (IOException e) {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw e;
        }
    }

    public static String decompressString(InputStream in) throws IOException {
        return new String(GZipUtil.decompressBytes(in));
    }

    public static String decompressString(byte[] value) throws IOException {
        return new String(GZipUtil.decompressBytes(value));
    }

    public static String decompressString(byte[] value, String charsetName) throws IOException {
        return new String(GZipUtil.decompressBytes(value), charsetName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String gzip(String primStr) {
        if (primStr == null || primStr.length() == 0) {
            return primStr;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        GZIPOutputStream gzip = null;
        try {
            gzip = new GZIPOutputStream(out);
            gzip.write(primStr.getBytes());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (gzip != null) {
                try {
                    gzip.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return Base64.getEncoder().encodeToString(out.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String gunzip(String compressedStr) {
        if (compressedStr == null) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayInputStream in = null;
        GZIPInputStream ginzip = null;
        byte[] compressed = null;
        String decompressed = null;
        try {
            compressed = Base64.getDecoder().decode(compressedStr);
            in = new ByteArrayInputStream(compressed);
            ginzip = new GZIPInputStream(in);
            byte[] buffer = new byte[1024];
            int offset = -1;
            while ((offset = ginzip.read(buffer)) != -1) {
                out.write(buffer, 0, offset);
            }
            decompressed = out.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (ginzip != null) {
                try {
                    ginzip.close();
                }
                catch (IOException iOException) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
        return decompressed;
    }
}

