/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.util;

import cn.dolphin.core.util.EmptyUtil;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public class ExecutorUtil {
    private ExecutorUtil() {
        throw new UnsupportedOperationException("EmptyUtil can not be instantiated");
    }

    public static <T> void executeBySingleThread(Collection<T> data, Consumer<T> consumer) throws InterruptedException {
        if (EmptyUtil.isEmpty(data).booleanValue()) {
            return;
        }
        ExecutorService service = Executors.newSingleThreadExecutor();
        data.forEach(t -> service.execute(() -> consumer.accept(t)));
        service.shutdown();
        service.awaitTermination(1L, TimeUnit.DAYS);
    }

    public static <T> void executeByCacheThread(Collection<T> data, Consumer<T> consumer) throws InterruptedException {
        if (EmptyUtil.isEmpty(data).booleanValue()) {
            return;
        }
        ExecutorService service = Executors.newCachedThreadPool();
        data.forEach(t -> service.execute(() -> consumer.accept(t)));
        service.shutdown();
        service.awaitTermination(1L, TimeUnit.DAYS);
    }

    public static <T> void executeByFixedThread(Collection<T> data, Consumer<T> consumer) throws InterruptedException {
        ExecutorUtil.executeByFixedThread(Runtime.getRuntime().availableProcessors(), data, consumer);
    }

    public static <T> void executeByFixedThread(int threadCount, Collection<T> data, Consumer<T> consumer) throws InterruptedException {
        if (EmptyUtil.isEmpty(data).booleanValue()) {
            return;
        }
        ExecutorService service = Executors.newFixedThreadPool(threadCount == 0 ? Runtime.getRuntime().availableProcessors() : threadCount);
        data.forEach(t -> service.execute(() -> consumer.accept(t)));
        service.shutdown();
        service.awaitTermination(1L, TimeUnit.DAYS);
    }
}

