/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.util;

import cn.dolphin.core.enums.ErrorEnum;
import cn.dolphin.core.regex.RegexUtil;
import cn.dolphin.core.result.BaseResult;
import cn.dolphin.core.util.ClassUtil;
import cn.dolphin.core.util.StrUtil;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.jdbc.UncategorizedSQLException;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingPathVariableException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.json.MappingJackson2JsonView;

public final class ExceptionUtil {
    private static final Logger log = LoggerFactory.getLogger(ExceptionUtil.class);

    private ExceptionUtil() {
    }

    public static String getMessage(Throwable e) {
        return StrUtil.formatParamMsg("{}: {}", e.getClass().getSimpleName(), e.getMessage());
    }

    public static RuntimeException wrapRuntime(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            return (RuntimeException)throwable;
        }
        return new RuntimeException(throwable);
    }

    public static Throwable unwrap(Throwable wrapped) {
        Throwable unwrapped = wrapped;
        while (true) {
            if (unwrapped instanceof InvocationTargetException) {
                unwrapped = ((InvocationTargetException)unwrapped).getTargetException();
                continue;
            }
            if (!(unwrapped instanceof UndeclaredThrowableException)) break;
            unwrapped = ((UndeclaredThrowableException)unwrapped).getUndeclaredThrowable();
        }
        return unwrapped;
    }

    public static StackTraceElement[] getStackElements() {
        return new Throwable().getStackTrace();
    }

    public static ModelAndView printErrorInfo(Throwable ex) {
        ExceptionUtil.printStackTrace(ex);
        BaseResult result = ExceptionUtil.gatherErrorInfos(ex);
        ModelAndView mav = new ModelAndView();
        mav.addObject("code", result.getCode());
        mav.addObject("message", (Object)result.getMessage());
        mav.setView((View)new MappingJackson2JsonView());
        return mav;
    }

    public static BaseResult printErrorInfos(Throwable ex) {
        ExceptionUtil.printStackTrace(ex);
        return ExceptionUtil.gatherErrorInfos(ex);
    }

    private static BaseResult gatherErrorInfos(Throwable ex) {
        BaseResult result = new BaseResult();
        if (ex instanceof DuplicateKeyException) {
            ExceptionUtil.handleDuplicateKeyInfo(ex, result);
        } else if (ex instanceof MethodArgumentTypeMismatchException) {
            ExceptionUtil.handleArumentTypeExceptionInfo(ex, result);
        } else if (ex instanceof HttpRequestMethodNotSupportedException) {
            ExceptionUtil.handleRequestMethodExceptionInfo(ex, result);
        } else if (ex instanceof UncategorizedSQLException) {
            ExceptionUtil.handleSQLExceptionInfo(ex, result);
        } else if (ex instanceof MissingServletRequestParameterException) {
            ExceptionUtil.handleRequiredBindException(ex, result);
        } else if (ex instanceof MissingPathVariableException) {
            ExceptionUtil.handleRequiredPathException(ex, result);
        } else if (ex instanceof MethodArgumentNotValidException) {
            ExceptionUtil.handleMethodBindException(ex, result);
        } else if (ex instanceof BindException) {
            ExceptionUtil.handleBindException(ex, result);
        } else {
            ExceptionUtil.handleBusinessExceptionInfo(ex, result);
        }
        return result;
    }

    public static void printStackTrace(Throwable e) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream pout = new PrintStream(out);
        e.printStackTrace(pout);
        String sw = new String(out.toByteArray());
        pout.close();
        try {
            out.close();
        }
        catch (Exception ex) {
            log.error("{}", (Throwable)ex);
        }
        log.error(sw);
    }

    private static void handleDuplicateKeyInfo(Throwable ex, BaseResult result) {
        DuplicateKeyException unique = (DuplicateKeyException)ex;
        Throwable throwable = unique.getCause();
        if (throwable instanceof SQLIntegrityConstraintViolationException) {
            ExceptionUtil.handleConstraintViolationInfo(throwable, result);
        }
    }

    private static void handleConstraintViolationInfo(Throwable ex, BaseResult result) {
        SQLIntegrityConstraintViolationException unique = (SQLIntegrityConstraintViolationException)ex;
        String message = unique.getMessage();
        if (message.contains("Duplicate")) {
            message = "\u8fdd\u53cd\u6570\u636e\u5e93\u552f\u4e00\u7d22\u5f15\u7ea6\u675f";
        }
        result.setCode(ErrorEnum.SQL_UNIQUE_KEY_ERROR.getCode());
        result.setMessage(message);
    }

    private static void handleArumentTypeExceptionInfo(Throwable ex, BaseResult result) {
        MethodArgumentTypeMismatchException argumentTypeException = (MethodArgumentTypeMismatchException)ex;
        result.setCode(ErrorEnum.REQUEST_PARAM_TYPE_ERROR.getCode());
        Class requiredType = argumentTypeException.getRequiredType();
        String message = "\u53c2\u6570\u7c7b\u578b\u9519\u8bef:" + argumentTypeException.getName() + "(" + (null != requiredType ? requiredType.getName() : "null") + "),\u5b9e\u9645\u7684\u4f20\u5165\u503c\u4e3a:" + argumentTypeException.getValue();
        result.setMessage(message);
    }

    private static void handleRequestMethodExceptionInfo(Throwable ex, BaseResult result) {
        HttpRequestMethodNotSupportedException methodException = (HttpRequestMethodNotSupportedException)ex;
        result.setCode(ErrorEnum.REQUEST_METHOD_ERROR.getCode());
        String message = "\u8be5\u65b9\u6cd5\u4e0d\u652f\u6301" + methodException.getMethod() + "\u8bf7\u6c42";
        result.setMessage(message);
    }

    private static void handleSQLExceptionInfo(Throwable ex, BaseResult mav) {
        UncategorizedSQLException e = (UncategorizedSQLException)ex;
        String msg = e.getMessage();
        if (!StringUtils.isEmpty((CharSequence)msg) && msg.contains("Incorrect string value: '\\x")) {
            mav.setCode(ErrorEnum.MYSQL_EMOJI_UNSUPPORT_CODE.getCode());
            mav.setMessage(ErrorEnum.MYSQL_EMOJI_UNSUPPORT_CODE.getMessage());
        } else {
            ExceptionUtil.handleUnExpectedExceptionInfo(ex, mav);
        }
    }

    private static void handleRequiredBindException(Throwable ex, BaseResult mav) {
        MissingServletRequestParameterException bindException = (MissingServletRequestParameterException)ex;
        mav.setCode(ErrorEnum.FORM_VALID_ERROR.getCode());
        String message = "\u7f3a\u5c11\u5fc5\u4f20\u53c2\u6570:" + bindException.getParameterName();
        mav.setMessage(message);
    }

    private static void handleRequiredPathException(Throwable ex, BaseResult mav) {
        MissingPathVariableException pathVariableException = (MissingPathVariableException)ex;
        mav.setCode(ErrorEnum.FORM_VALID_ERROR.getCode());
        String message = "\u7f3a\u5c11\u5fc5\u4f20\u53c2\u6570:" + pathVariableException.getVariableName();
        mav.setMessage(message);
    }

    private static void handleMethodBindException(Throwable ex, BaseResult mav) {
        MethodArgumentNotValidException bindException = (MethodArgumentNotValidException)ex;
        ExceptionUtil.handleBindError(mav, bindException.getBindingResult());
    }

    private static void handleBindException(Throwable ex, BaseResult mav) {
        BindException bindException = (BindException)ex;
        ExceptionUtil.handleBindError(mav, bindException.getBindingResult());
    }

    private static void handleBindError(BaseResult mav, BindingResult br) {
        if (br.hasFieldErrors()) {
            FieldError fieldError = br.getFieldError();
            if (null != fieldError && StringUtils.isNotBlank((CharSequence)fieldError.getDefaultMessage())) {
                String error = fieldError.getDefaultMessage();
                mav.setMessage(error);
            } else {
                mav.setMessage(ErrorEnum.FORM_VALID_ERROR.getMessage());
            }
            mav.setCode(ErrorEnum.FORM_VALID_ERROR.getCode());
        }
    }

    private static void handleBusinessExceptionInfo(Throwable ex, BaseResult mav) {
        Object code = null;
        Method method = ClassUtil.getMethod(ex.getClass(), "getCode");
        try {
            if (Objects.nonNull(method)) {
                code = method.invoke((Object)ex, new Object[0]);
            }
        }
        catch (Exception e) {
            ExceptionUtil.printStackTrace(e);
        }
        if (Objects.isNull(code)) {
            ExceptionUtil.handleUnExpectedExceptionInfo(ex, mav);
        } else {
            mav.setCode(code);
            ExceptionUtil.setMessage(ex, mav);
            ExceptionUtil.setData(ex, mav);
        }
    }

    private static void handleUnExpectedExceptionInfo(Throwable ex, BaseResult mav) {
        mav.setCode(ErrorEnum.SYSTEM_ERROR.getCode());
        String message = ex.getMessage();
        Throwable cause = ex.getCause();
        if (Objects.nonNull(cause)) {
            message = ex.getCause().getMessage();
        }
        if (StringUtils.isBlank((CharSequence)message)) {
            return;
        }
        if (RegexUtil.containChinese(message)) {
            mav.setMessage(message);
        } else {
            mav.setMessage(ErrorEnum.SYSTEM_ERROR.getMessage());
        }
    }

    private static void setMessage(Throwable ex, BaseResult mav) {
        Object message = null;
        Method method = ClassUtil.getMethod(ex.getClass(), "getMessage");
        try {
            if (Objects.nonNull(method)) {
                message = method.invoke((Object)ex, new Object[0]);
            }
        }
        catch (Exception e) {
            log.error("{}", (Object)e.getMessage());
        }
        if (Objects.nonNull(message)) {
            mav.setMessage(String.valueOf(message));
        }
    }

    private static void setData(Throwable ex, BaseResult mav) {
        Object data = null;
        Method method = ClassUtil.getMethod(ex.getClass(), "getData");
        try {
            if (Objects.nonNull(method)) {
                data = method.invoke((Object)ex, new Object[0]);
            }
        }
        catch (Exception e) {
            log.error("{}", (Object)e.getMessage());
        }
        if (Objects.nonNull(data)) {
            mav.setData(data);
        }
    }
}

