/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.util;

import com.vdurmont.emoji.EmojiParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmojiUtil {
    private static final Logger logger = LoggerFactory.getLogger(EmojiUtil.class);

    public static String toAliases(String input) {
        return EmojiParser.parseToAliases(input);
    }

    public static String toUnicode(String input) {
        return EmojiParser.parseToUnicode(input);
    }

    public static String parseToHtmlHexadecimal(String emoji_str) {
        return EmojiParser.parseToHtmlHexadecimal(emoji_str);
    }

    public static String parseToHtmlTag(String emoji_str) {
        if (emoji_str != null) {
            String str = EmojiParser.parseToHtmlHexadecimal(emoji_str);
            return EmojiUtil.htmlHexadecimalToHtmlTag(str);
        }
        return null;
    }

    public static String parseToAliases(String emoji_str) {
        return EmojiParser.parseToAliases(emoji_str);
    }

    public static String parseToHtmlDecimal(String emoji_str) {
        return EmojiParser.parseToHtmlDecimal(emoji_str);
    }

    public static String removeAllEmojis(String emoji_str) {
        return EmojiParser.removeAllEmojis(emoji_str);
    }

    public static String htmlHexadecimalToHtmlTag(String emoji_str) {
        if (emoji_str != null) {
            return emoji_str.replaceAll("&#x([^;]*);", "<span class='emoji emoji$1'></span>");
        }
        return null;
    }

    public static String parse(String emoji_str, int type) {
        switch (type) {
            case 1: {
                return EmojiUtil.parseToHtmlHexadecimal(emoji_str);
            }
            case 2: {
                return EmojiUtil.parseToHtmlTag(emoji_str);
            }
            case 3: {
                return EmojiUtil.parseToAliases(emoji_str);
            }
            case 4: {
                return EmojiUtil.parseToHtmlDecimal(emoji_str);
            }
            case 5: {
                return EmojiUtil.removeAllEmojis(emoji_str);
            }
        }
        return null;
    }
}

