/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.util;

import cn.dolphin.core.bean.EhcacheStatistic;
import cn.dolphin.core.exception.CacheException;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.List;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.statistics.StatisticsGateway;
import org.apache.commons.lang3.StringUtils;

public class EhCacheUtil {
    private static CacheManager cacheManager = null;
    private static Cache cache = null;
    private static final String EHCACHE_CONF_FILE = "ehcache.xml";
    public static int MAXELEMENTSINMEMORY = 50000;
    public static boolean OVERFLOWTODISK = true;
    public static boolean ETERNAL = false;
    public static int TIMETOIDLESECONDS = 600;
    public static int TIMETOlIVESECONDS = 86400;
    public static boolean DISKPERSISTENT = false;
    public static String MEMORYSTOREEVICTIONPOLICY = "LFU";

    private EhCacheUtil() {
    }

    public static CacheManager initCacheManager() {
        try {
            if (cacheManager == null) {
                cacheManager = CacheManager.getInstance();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cacheManager;
    }

    public static CacheManager initCacheManager(String path) {
        try {
            if (cacheManager == null) {
                if (StringUtils.isBlank((CharSequence)path)) {
                    String epath = EhCacheUtil.class.getClassLoader().getResource(EHCACHE_CONF_FILE).getPath();
                    CacheManager.getInstance();
                    cacheManager = CacheManager.create((String)epath);
                }
                CacheManager.getInstance();
                cacheManager = CacheManager.create((String)path);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cacheManager;
    }

    public static Cache initCache(String cacheName) {
        EhCacheUtil.checkCacheManager();
        if (null == cacheManager.getCache(cacheName)) {
            cacheManager.addCache(cacheName);
        }
        cache = cacheManager.getCache(cacheName);
        return cache;
    }

    public static void put(Object key, Object value) {
        EhCacheUtil.checkCache();
        Element element = new Element(key, value);
        cache.put(element);
    }

    public static Object get(Object key) {
        EhCacheUtil.checkCache();
        Element element = cache.get(key);
        if (null == element) {
            return null;
        }
        return element.getObjectValue();
    }

    public static Cache initCache(String cacheName, int maxElementsInMemory, boolean overflowToDisk, boolean eternal, long timeToLiveSeconds, long timeToIdleSeconds) throws Exception {
        try {
            CacheManager singletonManager = CacheManager.create();
            Cache myCache = singletonManager.getCache(cacheName);
            if (myCache != null) {
                CacheConfiguration config = cache.getCacheConfiguration();
                config.setTimeToLiveSeconds(timeToLiveSeconds);
                config.setMaxElementsInMemory(maxElementsInMemory);
                config.setOverflowToDisk(overflowToDisk);
                config.setEternal(eternal);
                config.setTimeToIdleSeconds(timeToIdleSeconds);
            }
            if (myCache == null) {
                Cache memoryOnlyCache = new Cache(cacheName, maxElementsInMemory, overflowToDisk, eternal, timeToLiveSeconds, timeToIdleSeconds);
                singletonManager.addCache(memoryOnlyCache);
                myCache = singletonManager.getCache(cacheName);
            }
            return myCache;
        }
        catch (Exception e) {
            throw new Exception("init cache " + cacheName + " failed!!!");
        }
    }

    public static Cache initCache(String cacheName, long timeToLiveSeconds) throws Exception {
        return EhCacheUtil.initCache(cacheName, MAXELEMENTSINMEMORY, OVERFLOWTODISK, ETERNAL, timeToLiveSeconds, TIMETOIDLESECONDS);
    }

    public static Cache initMyCache(String cacheName) throws Exception {
        return EhCacheUtil.initCache(cacheName, TIMETOlIVESECONDS);
    }

    public static boolean modifyCache(String cacheName, long timeToLiveSeconds, int maxElementsInMemory) throws Exception {
        try {
            if (StringUtils.isNotBlank((CharSequence)cacheName) && timeToLiveSeconds != 0L && maxElementsInMemory != 0) {
                CacheManager myManager = CacheManager.create();
                Cache myCache = myManager.getCache(cacheName);
                CacheConfiguration config = myCache.getCacheConfiguration();
                config.setTimeToLiveSeconds(timeToLiveSeconds);
                config.setMaxElementsInMemory(maxElementsInMemory);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw new Exception("modify cache " + cacheName + " failed!!!");
        }
    }

    public static boolean setValue(String cacheName, String key, Object value) throws Exception {
        try {
            CacheManager myManager = CacheManager.create();
            Cache myCache = myManager.getCache(cacheName);
            if (myCache == null) {
                myCache = EhCacheUtil.initCache(cacheName);
            }
            myCache.put(new Element((Object)key, value));
            return true;
        }
        catch (Exception e) {
            throw new Exception("set cache " + cacheName + " failed!!!");
        }
    }

    public static boolean setValue(String cacheName, String key, Object value, Integer timeToLiveSeconds) throws Exception {
        try {
            CacheManager myManager = CacheManager.create();
            Cache myCache = myManager.getCache(cacheName);
            if (myCache == null) {
                EhCacheUtil.initCache(cacheName, timeToLiveSeconds.intValue());
                myCache = myManager.getCache(cacheName);
            }
            myCache.put(new Element((Object)key, value, TIMETOIDLESECONDS, timeToLiveSeconds.intValue()));
            return true;
        }
        catch (Exception e) {
            throw new Exception("set cache " + cacheName + " failed!!!");
        }
    }

    public static Object getValue(String cacheName, String key) throws Exception {
        try {
            CacheManager myManager = CacheManager.create();
            Cache myCache = myManager.getCache(cacheName);
            if (myCache == null) {
                myCache = EhCacheUtil.initMyCache(cacheName);
            }
            return myCache.get((Serializable)((Object)key)).getObjectValue();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean removeEhcache(String cacheName) throws Exception {
        try {
            CacheManager myManager = CacheManager.create();
            myManager.removeCache(cacheName);
            return true;
        }
        catch (Exception e) {
            throw new Exception("remove cache " + cacheName + " failed!!!");
        }
    }

    public static boolean removeAllEhcache(String cacheName) throws Exception {
        try {
            CacheManager myManager = CacheManager.create();
            myManager.removeAllCaches();
            return true;
        }
        catch (Exception e) {
            throw new Exception("remove cache " + cacheName + " failed!!!");
        }
    }

    public static boolean removeElment(String cacheName, String key) throws Exception {
        try {
            CacheManager myManager = CacheManager.create();
            Cache myCache = myManager.getCache(cacheName);
            myCache.remove((Serializable)((Object)key));
            return true;
        }
        catch (Exception e) {
            throw new Exception("remove cache " + cacheName + " failed!!!");
        }
    }

    public static boolean removeAllElment(String cacheName, String key) throws Exception {
        try {
            CacheManager myManager = CacheManager.create();
            Cache myCache = myManager.getCache(cacheName);
            myCache.removeAll();
            return true;
        }
        catch (Exception e) {
            throw new Exception("remove cache " + cacheName + " failed!!!");
        }
    }

    public static void shutdown() {
        cacheManager.shutdown();
    }

    public static void removeCache(String cacheName) {
        EhCacheUtil.checkCacheManager();
        cache = cacheManager.getCache(cacheName);
        if (null != cache) {
            cacheManager.removeCache(cacheName);
        }
    }

    public static void remove(String key) {
        EhCacheUtil.checkCache();
        cache.remove((Serializable)((Object)key));
    }

    public static void removeAllCache() {
        EhCacheUtil.checkCacheManager();
        cacheManager.removeAllCaches();
    }

    public static void removeAllKey() {
        EhCacheUtil.checkCache();
        cache.removeAll();
    }

    public static String[] getAllCaches() {
        EhCacheUtil.checkCacheManager();
        return cacheManager.getCacheNames();
    }

    public static List getKeys() {
        EhCacheUtil.checkCache();
        return cache.getKeys();
    }

    private static void checkCacheManager() {
        if (null == cacheManager) {
            throw new IllegalArgumentException("\u8c03\u7528\u524d\u8bf7\u5148\u521d\u59cb\u5316CacheManager\u503c\uff1aEHCacheUtil.initCacheManager");
        }
    }

    private static void checkCache() {
        if (null == cache) {
            throw new IllegalArgumentException("\u8c03\u7528\u524d\u8bf7\u5148\u521d\u59cb\u5316Cache\u503c\uff1aEHCacheUtil.initCache(\u53c2\u6570)");
        }
    }

    public static EhcacheStatistic getCacheStatistic(String cacheName) throws CacheException {
        Cache cache = EhCacheUtil.initCache(cacheName);
        EhcacheStatistic statistic = new EhcacheStatistic();
        StatisticsGateway gateway = cache.getStatistics();
        statistic.setMemoryStoreSize(gateway.getLocalHeapSize());
        statistic.setMemoryStoreSizeInMB(EhCacheUtil.formatDouble((double)gateway.getLocalHeapSizeInBytes() / 1024.0 / 1024.0));
        statistic.setDiskStoreSize(gateway.getLocalDiskSize());
        statistic.setDiskStoreSizeInMB(EhCacheUtil.formatDouble((double)gateway.getLocalDiskSizeInBytes() / 1024.0 / 1024.0));
        statistic.setHitCount(gateway.cacheHitCount());
        statistic.setMissCount(gateway.cacheMissCount());
        statistic.setSize(cache.getSize());
        return statistic;
    }

    private static Double formatDouble(double number) {
        if (Double.isNaN(number)) {
            return new Double(0.0);
        }
        DecimalFormat df = new DecimalFormat("0.##");
        return Double.valueOf(df.format(number));
    }

    public static void main(String[] arg) throws Exception {
        System.out.println(EhCacheUtil.formatDouble(Double.NaN));
        EhCacheUtil.initCacheManager("");
        EhCacheUtil.initCache("cache");
        EhCacheUtil.put("A", "AAAAA");
        EhCacheUtil.put("B", "BBBBB");
        EhCacheUtil.put("F", "FFFFF");
        EhCacheUtil.put("F1", "FFFFF");
        System.out.println(EhCacheUtil.get("F"));
        List keys = EhCacheUtil.getKeys();
        for (int i = 0; i < keys.size(); ++i) {
            System.out.println(keys.get(i));
        }
        System.out.println(EhCacheUtil.getCacheStatistic("cache"));
        EhCacheUtil.removeAllCache();
    }
}

