/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.util;

import cn.dolphin.core.util.StrUtil;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DoubleUtil {
    private static final Logger logger = LoggerFactory.getLogger(DoubleUtil.class);
    private static final int DEF_DIV_SCALE = 10;

    private DoubleUtil() {
    }

    public static double add(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.add(b2).doubleValue();
    }

    public static double sub(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.subtract(b2).doubleValue();
    }

    public static double mul(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.multiply(b2).doubleValue();
    }

    public static double div(double v1, double v2) {
        return DoubleUtil.div(v1, v2, 10);
    }

    public static double div(double v1, double v2, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.divide(b2, scale, 4).doubleValue();
    }

    public static double round(double v, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        BigDecimal b = new BigDecimal(Double.toString(v));
        BigDecimal one = new BigDecimal("1");
        return b.divide(one, scale, 4).doubleValue();
    }

    public static final Double toEmpty(Double o) {
        return o == null ? 0.0 : o;
    }

    public static final Double valueOf(String num) {
        if (StrUtil.isBlank((CharSequence)num)) {
            return null;
        }
        return Double.valueOf(num.trim());
    }

    public static final Double valueOfZero(String num) {
        if (StrUtil.isBlank((CharSequence)num)) {
            return 0.0;
        }
        return Double.valueOf(num.trim());
    }

    public static Double fmtDouble(Double num) {
        if (num == null || 0.0 == num) {
            logger.warn("num is null == {}", (Object)num);
            return 0.0;
        }
        try {
            return new BigDecimal(num).setScale(2, 4).doubleValue();
        }
        catch (Exception e) {
            logger.warn("fmt double error : num = {} , error = {}", (Object)num, (Object)e.getMessage());
            return 0.0;
        }
    }

    public static boolean compareDouble(Double x, Double y) {
        BigDecimal data2;
        if (null == x || null == y) {
            return false;
        }
        BigDecimal data1 = new BigDecimal(x);
        return data1.compareTo(data2 = new BigDecimal(y)) == 0;
    }
}

