/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.util;

import cn.dolphin.core.util.BigDecimalUtil;
import cn.dolphin.core.util.CastUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.NumberFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataHandleUtil {
    private static final Logger log = LoggerFactory.getLogger(DataHandleUtil.class);

    public static BigDecimal perToDecimal(String percent) {
        String decimal = percent.substring(0, percent.indexOf("%"));
        BigDecimal bigDecimal = new BigDecimal(decimal);
        bigDecimal.divide(new BigDecimal("100"), 4, 4);
        return bigDecimal;
    }

    public static Double doubleBit(Double d, Integer bit) {
        if (d == null || bit == null) {
            return null;
        }
        BigDecimal bg = new BigDecimal(d).setScale((int)bit, RoundingMode.DOWN);
        return bg.doubleValue();
    }

    public static String division(Float divisor, Float dividend, Integer bit) {
        if (dividend == null || divisor == null || bit == null) {
            return null;
        }
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(bit);
        String result = numberFormat.format(divisor.floatValue() / dividend.floatValue() * 100.0f);
        return result + "%";
    }

    public static String division(Integer divisor, Integer dividend) {
        if (dividend == null || divisor == null) {
            return null;
        }
        String division = DataHandleUtil.division(CastUtil.castFloat(divisor), CastUtil.castFloat(dividend), 2);
        return division;
    }

    public static String division(Float divisor, Float dividend) {
        return DataHandleUtil.division(divisor, dividend, 2);
    }

    public static void main(String[] args) {
        System.out.println(DataHandleUtil.division(CastUtil.castFloat(0.8000000000000007), CastUtil.castFloat(8)));
        System.out.println(DataHandleUtil.perToDecimal("67.89%"));
        BigDecimal newZero = new BigDecimal(0.0);
        System.out.println(BigDecimal.ZERO.compareTo(newZero));
        BigDecimal stringNewZero = new BigDecimal("0.0");
        System.out.println(BigDecimal.ZERO.compareTo(stringNewZero));
        BigDecimal noScaleZero = BigDecimal.valueOf(0.0);
        System.out.println(BigDecimal.ZERO.compareTo(noScaleZero));
        BigDecimal scaleZero = BigDecimal.valueOf(0.0).setScale(1);
        System.out.println(BigDecimal.ZERO.compareTo(scaleZero));
        System.out.println(1);
        System.out.println(BigDecimalUtil.lessEqual(DataHandleUtil.perToDecimal("20.01%"), CastUtil.castStringToBigDecimal("20")));
    }
}

