/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.util;

import cn.dolphin.core.consts.P;
import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.beanutils.ConvertUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class ConvertUtil {
    public static List<Long> splitStr2LongList(String content, String splitChar) {
        if (StringUtils.isEmpty((Object)content)) {
            return new ArrayList<Long>();
        }
        String[] split = content.split(splitChar);
        Long[] longArr = (Long[])ConvertUtils.convert((String[])split, Long.class);
        return new ArrayList<Long>(Arrays.asList(longArr));
    }

    public static String[] splitStr2StrArray(String content, String splitChar) {
        if (StringUtils.isEmpty((Object)content)) {
            return new String[0];
        }
        String[] split = content.split(splitChar);
        return split;
    }

    public static <T, S> List<T> convertList(List<S> sourceList, Class<T> targetClazz) {
        if (CollectionUtils.isEmpty(sourceList)) {
            return new ArrayList();
        }
        return JSON.parseArray((String)JSON.toJSONString(sourceList), targetClazz);
    }

    public static <T> T convert(Object obj, T def) {
        Object t = ConvertUtil.convert(obj, def.getClass().getName());
        return (T)(t == null ? def : t);
    }

    public static <T> T convert(Object obj, Class<T> clazz) {
        return (T)ConvertUtil.convert(obj, clazz.getName());
    }

    public static Object convert(Object obj, String type) {
        if (obj == null) {
            return null;
        }
        switch (type) {
            case "java.lang.Object": {
                return obj;
            }
            case "java.lang.String": {
                return ConvertUtil.toString(obj);
            }
            case "java.lang.Boolean": {
                return ConvertUtil.toBool(obj);
            }
            case "boolean": {
                return ConvertUtil.toBool(obj, false);
            }
            case "java.lang.Double": {
                return ConvertUtil.toDouble(obj);
            }
            case "double": {
                return ConvertUtil.toDouble(obj, 0.0);
            }
            case "java.lang.Long": {
                return ConvertUtil.toLong(obj);
            }
            case "long": {
                return ConvertUtil.toLong(obj, 0L);
            }
            case "java.lang.Float": {
                return ConvertUtil.toFloat(obj);
            }
            case "float": {
                return ConvertUtil.toFloat(obj, Float.valueOf(0.0f));
            }
            case "java.lang.Integer": {
                return ConvertUtil.toInteger(obj);
            }
            case "int": {
                return ConvertUtil.toInteger(obj, 0);
            }
            case "java.math.BigDecimal": {
                return ConvertUtil.toBigDecimal(obj);
            }
            case "java.sql.Date": {
                return ConvertUtil.toDate(obj);
            }
            case "java.sql.Time": {
                return ConvertUtil.toTime(obj);
            }
            case "java.sql.Timestamp": {
                return ConvertUtil.toTimestamp(obj);
            }
            case "java.util.Date": {
                return ConvertUtil.toUtilDate(obj);
            }
        }
        return obj;
    }

    public static String toString(Object obj, String def) {
        return ConvertUtil.nvl(ConvertUtil.toString(obj), def);
    }

    public static String toString(Object obj) {
        try {
            if (obj == null) {
                return null;
            }
            if (obj instanceof Number) {
                return ConvertUtil.getNf().format(((Number)obj).doubleValue());
            }
            if (obj instanceof String) {
                return obj.toString().length() == 0 ? null : obj.toString();
            }
            return obj.toString();
        }
        catch (Exception e) {
            return obj.toString();
        }
    }

    public static String toString2(Object obj, String pattern, String def) {
        return ConvertUtil.nvl(ConvertUtil.toString2(obj, pattern), def);
    }

    public static String toString2(Object obj, String pattern) {
        try {
            if (obj == null) {
                return null;
            }
            if (pattern == null) {
                return ConvertUtil.toString(obj);
            }
            if (obj instanceof Number) {
                return new DecimalFormat(pattern).format(obj);
            }
            if (obj instanceof java.util.Date) {
                return new SimpleDateFormat(pattern).format(obj);
            }
            if (obj instanceof String) {
                return obj.toString().length() == 0 ? null : obj.toString();
            }
            return obj.toString();
        }
        catch (Exception e) {
            return obj.toString();
        }
    }

    public static BigDecimal toBigDecimal(Object obj, BigDecimal def) {
        return ConvertUtil.nvl(ConvertUtil.toBigDecimal(obj), def);
    }

    public static BigDecimal toBigDecimal(Object obj) {
        try {
            if (obj == null) {
                return null;
            }
            if (obj instanceof String) {
                String str = (String)obj;
                BigDecimal retBig = new BigDecimal(str);
                int iscale = str.indexOf(".");
                int keylen = str.length();
                if (iscale > -1) {
                    iscale = keylen - (iscale + 1);
                    return retBig.setScale(iscale, 5);
                }
                return retBig.setScale(0, 5);
            }
            if (obj instanceof BigDecimal) {
                return (BigDecimal)obj;
            }
            if (obj instanceof Number) {
                return new BigDecimal(((Number)obj).doubleValue());
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Double toDouble(Object obj, Double def) {
        return ConvertUtil.nvl(ConvertUtil.toDouble(obj), def);
    }

    public static Double toDouble(Object obj) {
        try {
            if (obj == null) {
                return null;
            }
            if (obj instanceof String) {
                return new Double(ConvertUtil.getNf().parse((String)obj).doubleValue());
            }
            if (obj instanceof Number) {
                return ((Number)obj).doubleValue();
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Long toLong(Object obj, Long def) {
        return ConvertUtil.nvl(ConvertUtil.toLong(obj), def);
    }

    public static Long toLong(Object obj) {
        try {
            if (obj == null) {
                return null;
            }
            if (obj instanceof String) {
                NumberFormat nf = ConvertUtil.getNf();
                nf.setMaximumFractionDigits(0);
                return new Long(nf.parse((String)obj).longValue());
            }
            if (obj instanceof Number) {
                return ((Number)obj).longValue();
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Float toFloat(Object obj, Float def) {
        return ConvertUtil.nvl(ConvertUtil.toFloat(obj), def);
    }

    public static Float toFloat(Object obj) {
        try {
            if (obj == null) {
                return null;
            }
            if (obj instanceof Number) {
                return Float.valueOf(((Number)obj).floatValue());
            }
            if (obj instanceof String) {
                return new Float(ConvertUtil.getNf().parse((String)obj).floatValue());
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Integer toInteger(Object obj, Integer def) {
        return ConvertUtil.nvl(ConvertUtil.toInteger(obj), def);
    }

    public static Integer toInteger(Object obj) {
        try {
            if (obj == null) {
                return null;
            }
            if (obj instanceof Number) {
                return ((Number)obj).intValue();
            }
            if (obj instanceof String) {
                NumberFormat nf = ConvertUtil.getNf();
                nf.setMaximumFractionDigits(0);
                return new Integer(nf.parse((String)obj).intValue());
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Boolean toBool(Object obj, Boolean def) {
        return ConvertUtil.nvl(ConvertUtil.toBool(obj), def);
    }

    public static Boolean toBool(Object obj) {
        try {
            if (obj == null) {
                return null;
            }
            if (obj instanceof String) {
                String str = ((String)obj).toLowerCase();
                return "true".equals(str) || "1".equals(str) || "yes".equals(str) || "on".equals(str);
            }
            if (obj instanceof Number) {
                return ((Number)obj).intValue() != 0;
            }
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Date toDate(Object obj, String format, java.util.Date def) {
        return ConvertUtil.nvl(ConvertUtil.toDate(obj, format), new Date(def.getTime()));
    }

    public static Date toDate(Object obj, String format, Date def) {
        return ConvertUtil.nvl(ConvertUtil.toDate(obj, format), def);
    }

    public static Date toDate(Object obj) {
        return ConvertUtil.toDate(obj, "yyyy-MM-dd");
    }

    public static Date toDate(Object obj, String format) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Long) {
            return new Date((Long)obj);
        }
        if (obj instanceof java.util.Date) {
            return new Date(((java.util.Date)obj).getTime());
        }
        if (obj instanceof String) {
            String str = (String)obj;
            try {
                return Date.valueOf(str);
            }
            catch (IllegalArgumentException e) {
                try {
                    return new Date(new SimpleDateFormat(format).parse(str).getTime());
                }
                catch (Exception e1) {
                    return null;
                }
            }
        }
        if (obj instanceof Date) {
            return (Date)obj;
        }
        return null;
    }

    public static java.util.Date toUtilDate(Object obj, String format, java.util.Date def) {
        return ConvertUtil.nvl(ConvertUtil.toUtilDate(obj, format), def);
    }

    public static java.util.Date toUtilDate(Object obj, String format, Date def) {
        return ConvertUtil.nvl(ConvertUtil.toUtilDate(obj, format), def);
    }

    public static java.util.Date toUtilDate(Object obj) {
        return ConvertUtil.toUtilDate(obj, "yyyy-MM-dd HH:mm:ss");
    }

    public static java.util.Date toUtilDate(Object obj, String format) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof java.util.Date) {
            return (java.util.Date)obj;
        }
        if (obj instanceof Date) {
            return (java.util.Date)obj;
        }
        if (obj instanceof Long) {
            return new java.util.Date((Long)obj);
        }
        if (obj instanceof String) {
            String str = (String)obj;
            try {
                if (format == null) {
                    return Date.valueOf(str);
                }
                return new SimpleDateFormat(format).parse(str);
            }
            catch (IllegalArgumentException | ParseException e) {
                return null;
            }
        }
        return null;
    }

    public static Time toTime(Object obj, String format, java.util.Date def) {
        return ConvertUtil.nvl(ConvertUtil.toTime(obj, format), new Time(def.getTime()));
    }

    public static Time toTime(Object obj) {
        return ConvertUtil.toTime(obj, "HH:mm:ss");
    }

    public static Time toTime(Object obj, String format) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Long) {
            return new Time((Long)obj);
        }
        if (obj instanceof java.util.Date) {
            return new Time(((java.util.Date)obj).getTime());
        }
        if (obj instanceof String) {
            String str = (String)obj;
            try {
                return Time.valueOf(str);
            }
            catch (IllegalArgumentException e) {
                try {
                    return new Time(new SimpleDateFormat(format).parse(str).getTime());
                }
                catch (Exception e1) {
                    return null;
                }
            }
        }
        if (obj instanceof Time) {
            return (Time)obj;
        }
        return null;
    }

    public static Timestamp toTimestamp(Object obj, String format, java.util.Date def) {
        return ConvertUtil.nvl(ConvertUtil.toTimestamp(obj, format), new Timestamp(def.getTime()));
    }

    public static Timestamp toTimestamp(Object obj) {
        return ConvertUtil.toTimestamp(obj, "yyyy-MM-dd HH:mm:ss");
    }

    public static Timestamp toTimestamp(Object obj, String format) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Long) {
            return new Timestamp((Long)obj);
        }
        if (obj instanceof java.util.Date) {
            return new Timestamp(((java.util.Date)obj).getTime());
        }
        if (obj instanceof String) {
            String str = (String)obj;
            try {
                return Timestamp.valueOf(str);
            }
            catch (IllegalArgumentException e) {
                try {
                    return new Timestamp(new SimpleDateFormat(format).parse(str).getTime());
                }
                catch (Exception e1) {
                    return null;
                }
            }
        }
        if (obj instanceof Timestamp) {
            return (Timestamp)obj;
        }
        return null;
    }

    private static NumberFormat getNf() {
        NumberFormat nf = NumberFormat.getNumberInstance(P.LOCALE);
        nf.setGroupingUsed(false);
        return nf;
    }

    private static final <T> T nvl(T src, T newObj) {
        return src == null ? newObj : src;
    }
}

