/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.util;

import java.awt.Color;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public final class CommonUtil {
    private static final Logger logger = LoggerFactory.getLogger(CommonUtil.class);

    private CommonUtil() {
    }

    public static Color getRandomColor() {
        int r = (int)(Math.random() * 256.0);
        int g = (int)(Math.random() * 256.0);
        int b = (int)(Math.random() * 256.0);
        return new Color(r, g, b);
    }

    public static String getSysJournalNo() {
        return CommonUtil.getSysJournalNo(20, true);
    }

    public static String getSysJournalNo(int length, boolean isNumber) {
        String uuid = UUID.randomUUID().toString().replaceAll("-", "");
        if (uuid.length() > length) {
            uuid = uuid.substring(0, length);
        } else if (uuid.length() < length) {
            for (int i = 0; i < length - uuid.length(); ++i) {
                uuid = uuid + Math.round(Math.random() * 9.0);
            }
        }
        if (isNumber) {
            return uuid.replaceAll("a", "1").replaceAll("b", "2").replaceAll("c", "3").replaceAll("d", "4").replaceAll("e", "5").replaceAll("f", "6");
        }
        return uuid;
    }

    public static boolean isEmpty(String input) {
        return null == input || 0 == input.length() || 0 == input.replaceAll("\\s", "").length();
    }

    public static final boolean isEmpty(Collection<? extends Object> value) {
        return value == null || value.isEmpty();
    }

    public static final boolean isEmpty(Map<? extends Object, ? extends Object> value) {
        return value == null || value.isEmpty();
    }

    public static final boolean isEmpty(Object value) {
        if (value != null && value instanceof String) {
            return CommonUtil.isEmpty((String)value);
        }
        if (value != null && value instanceof Collection) {
            return CommonUtil.isEmpty((Collection)value);
        }
        if (value != null && value instanceof Map) {
            return CommonUtil.isEmpty((Map)value);
        }
        return value == null;
    }

    public static final boolean isEmpty(Object[] value) {
        return value == null || value.length < 1;
    }

    public static final boolean isNotEmpty(Object value) {
        return !CommonUtil.isEmpty(value);
    }

    public static boolean isEmpty(byte[] bytes) {
        return null == bytes || 0 == bytes.length;
    }

    public static String getStringFromObjectForByte(Object obj) {
        StringBuilder sb = new StringBuilder();
        sb.append(obj.getClass().getName()).append("@").append(obj.hashCode()).append("[");
        for (Field field : obj.getClass().getDeclaredFields()) {
            String methodName = "get" + StringUtils.capitalize((String)field.getName());
            Object fieldValue = null;
            try {
                fieldValue = obj.getClass().getDeclaredMethod(methodName, new Class[0]).invoke(obj, new Object[0]);
            }
            catch (Exception e) {
                sb.append("\n").append(field.getName()).append("=UnKnown");
                continue;
            }
            if (fieldValue == null) {
                sb.append("\n").append(field.getName()).append("=null");
                continue;
            }
            sb.append("\n").append(field.getName()).append("=").append(new String((byte[])fieldValue));
        }
        return sb.append("\n]").toString();
    }

    public static String getStringFromMap(Map<String, String> map) {
        StringBuilder sb = new StringBuilder();
        sb.append(map.getClass().getName()).append("@").append(map.hashCode()).append("[");
        for (Map.Entry<String, String> entry : map.entrySet()) {
            sb.append("\n").append(entry.getKey()).append("=").append(entry.getValue());
        }
        return sb.append("\n]").toString();
    }

    public static String getStringFromMapForByte(Map<String, byte[]> map) {
        StringBuilder sb = new StringBuilder();
        sb.append(map.getClass().getName()).append("@").append(map.hashCode()).append("[");
        for (Map.Entry<String, byte[]> entry : map.entrySet()) {
            sb.append("\n").append(entry.getKey()).append("=").append(new String(entry.getValue()));
        }
        return sb.append("\n]").toString();
    }

    public static String getStringFromMapForObject(Map<String, Object> map) {
        StringBuilder sb = new StringBuilder();
        sb.append(map.getClass().getName()).append("@").append(map.hashCode()).append("[");
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            sb.append("\n").append(entry.getKey()).append("=").append(entry.getValue().toString());
        }
        return sb.append("\n]").toString();
    }

    public static String getString(byte[] data) {
        return CommonUtil.getString(data, "ISO-8859-1");
    }

    public static String getString(byte[] data, String charset) {
        if (CommonUtil.isEmpty(data)) {
            return "";
        }
        if (CommonUtil.isEmpty(charset)) {
            return new String(data);
        }
        try {
            return new String(data, charset);
        }
        catch (UnsupportedEncodingException e) {
            logger.error("\u5c06byte\u6570\u7ec4[" + data + "]\u8f6c\u4e3aString\u65f6\u53d1\u751f\u5f02\u5e38:\u7cfb\u7edf\u4e0d\u652f\u6301\u8be5\u5b57\u7b26\u96c6[" + charset + "]");
            return new String(data);
        }
    }

    public static String getStringSimple(String data) {
        return data.substring(0, 4) + "***" + data.substring(data.length() - 4);
    }

    public static byte[] getBytes(String data) {
        return CommonUtil.getBytes(data, "ISO-8859-1");
    }

    public static byte[] getBytes(String data, String charset) {
        String string = data = data == null ? "" : data;
        if (CommonUtil.isEmpty(charset)) {
            return data.getBytes();
        }
        try {
            return data.getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            logger.error("\u5c06\u5b57\u7b26\u4e32[" + data + "]\u8f6c\u4e3abyte[]\u65f6\u53d1\u751f\u5f02\u5e38:\u7cfb\u7edf\u4e0d\u652f\u6301\u8be5\u5b57\u7b26\u96c6[" + charset + "]");
            return data.getBytes();
        }
    }

    public static String getHexSign(Map<String, String> param, String charset, String algorithm, String signKey) {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> keys = new ArrayList<String>(param.keySet());
        Collections.sort(keys);
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            String value = param.get(key);
            if (key.equalsIgnoreCase("cert") || key.equalsIgnoreCase("hmac") || key.equalsIgnoreCase("signMsg") || value == null || value.length() == 0) continue;
            sb.append(key).append("=").append(value).append("|");
        }
        sb.append("key=").append(signKey);
        return CommonUtil.getHexSign(sb.toString(), charset, algorithm, true);
    }

    public static String getHexSign(String data, String charset, String algorithm, boolean toLowerCase) {
        char[] DIGITS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        char[] DIGITS_UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] DIGITS = toLowerCase ? DIGITS_LOWER : DIGITS_UPPER;
        byte[] dataBytes = CommonUtil.getBytes(data, charset);
        byte[] algorithmData = null;
        try {
            algorithmData = MessageDigest.getInstance(algorithm).digest(dataBytes);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("\u7b7e\u540d\u5b57\u7b26\u4e32[" + data + "]\u65f6\u53d1\u751f\u5f02\u5e38:System doesn't support this algorithm[" + algorithm + "]");
            return "";
        }
        char[] respData = new char[algorithmData.length << 1];
        int j = 0;
        for (int i = 0; i < algorithmData.length; ++i) {
            respData[j++] = DIGITS[(0xF0 & algorithmData[i]) >>> 4];
            respData[j++] = DIGITS[0xF & algorithmData[i]];
        }
        return new String(respData);
    }

    public static String encode(String chinese) {
        return CommonUtil.encode(chinese, "UTF-8");
    }

    public static String encode(String chinese, String charset) {
        chinese = chinese == null ? "" : chinese;
        try {
            return URLEncoder.encode(chinese, charset);
        }
        catch (UnsupportedEncodingException e) {
            logger.error("\u7f16\u7801\u5b57\u7b26\u4e32[" + chinese + "]\u65f6\u53d1\u751f\u5f02\u5e38:\u7cfb\u7edf\u4e0d\u652f\u6301\u8be5\u5b57\u7b26\u96c6[" + charset + "]");
            return chinese;
        }
    }

    public static String decode(String chinese) {
        return CommonUtil.decode(chinese, "UTF-8");
    }

    public static String decode(String chinese, String charset) {
        chinese = chinese == null ? "" : chinese;
        try {
            return URLDecoder.decode(chinese, charset);
        }
        catch (UnsupportedEncodingException e) {
            logger.error("\u89e3\u7801\u5b57\u7b26\u4e32[" + chinese + "]\u65f6\u53d1\u751f\u5f02\u5e38:\u7cfb\u7edf\u4e0d\u652f\u6301\u8be5\u5b57\u7b26\u96c6[" + charset + "]");
            return chinese;
        }
    }

    public static String rightPadForByte(String str, int size) {
        return CommonUtil.rightPadForByte(str, size, 32);
    }

    public static String rightPadForByte(String str, int size, int padStrByASCII) {
        byte[] srcByte = str.getBytes();
        byte[] destByte = null;
        if (srcByte.length >= size) {
            destByte = Arrays.copyOf(srcByte, size);
        } else {
            destByte = Arrays.copyOf(srcByte, size);
            Arrays.fill(destByte, srcByte.length, size, (byte)padStrByASCII);
        }
        return new String(destByte);
    }

    public static String leftPadForByte(String str, int size) {
        return CommonUtil.leftPadForByte(str, size, 32);
    }

    public static String leftPadForByte(String str, int size, int padStrByASCII) {
        byte[] srcByte = str.getBytes();
        byte[] destByte = new byte[size];
        Arrays.fill(destByte, (byte)padStrByASCII);
        if (srcByte.length >= size) {
            System.arraycopy(srcByte, 0, destByte, 0, size);
        } else {
            System.arraycopy(srcByte, 0, destByte, size - srcByte.length, srcByte.length);
        }
        return new String(destByte);
    }

    public static String getYestoday() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        return new SimpleDateFormat("yyyyMMdd").format(calendar.getTime());
    }

    public static String getCurrentDate() {
        return new SimpleDateFormat("yyyyMMdd").format(new Date());
    }

    public static String getCurrentTime() {
        return new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
    }

    public static String htmlEscape(String input) {
        if (CommonUtil.isEmpty(input)) {
            return input;
        }
        input = input.replaceAll("&", "&amp;");
        input = input.replaceAll("<", "&lt;");
        input = input.replaceAll(">", "&gt;");
        input = input.replaceAll(" ", "&nbsp;");
        input = input.replaceAll("'", "&#39;");
        input = input.replaceAll("\"", "&quot;");
        input = input.replaceAll("\n", "<br/>");
        return input;
    }

    public static HttpServletRequest getHttpRequest() {
        return ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
    }

    public static String getFileExtension(String fileName) {
        if (CommonUtil.isEmpty(fileName)) {
            return null;
        }
        return fileName.substring(fileName.lastIndexOf(".") + 1, fileName.length());
    }

    public static String getFileName(String fileName) {
        String fileExtension = CommonUtil.getFileExtension(fileName);
        return fileName.substring(0, fileName.lastIndexOf(fileExtension) - 1);
    }
}

