/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.util;

import cn.dolphin.core.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.springframework.util.CollectionUtils;

public class CollectionUtil
extends CollectionUtils {
    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || org.apache.commons.collections.CollectionUtils.isEmpty(collection);
    }

    public static boolean isNotEmpty(Collection<?> collection) {
        return !CollectionUtil.isEmpty(collection);
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || MapUtils.isEmpty(map);
    }

    public static <T> boolean isNotEmpty(Map<?, ?> map) {
        return !CollectionUtil.isEmpty(map);
    }

    public static <T> boolean isEmpty(T[] array) {
        return array == null || array.length <= 0;
    }

    public static <T> boolean isNotEmpty(T[] array) {
        return !CollectionUtil.isEmpty(array);
    }

    public static <T> boolean isAllNull(Collection<T> collection) {
        for (T el : collection) {
            if (el == null) continue;
            return true;
        }
        return false;
    }

    public static <E> boolean addNotNullElement(Collection<E> c, E e) {
        if (c == null) {
            return false;
        }
        if (e == null) {
            return false;
        }
        c.add(e);
        return true;
    }

    public static <E> boolean addNotNullElements(Collection<E> c, Collection<E> es) {
        if (c == null) {
            return false;
        }
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(es)) {
            return false;
        }
        c.addAll(es);
        return true;
    }

    public static <E> E getNotNullElement(List<E> l, int index) {
        if (null == l) {
            return null;
        }
        if (l.size() <= index) {
            return null;
        }
        return l.get(index);
    }

    public static final List<String> toStrList(String ids) {
        return ArrayUtil.convertList(ids.split(","));
    }

    public static final List<Integer> toIntList(String ids) {
        String[] split = ids.split(",");
        ArrayList<Integer> ls = new ArrayList<Integer>(split.length);
        for (int i = 0; i < split.length; ++i) {
            ls.add(Integer.valueOf(split[i]));
        }
        return ls;
    }

    public static final List<Long> toLongList(String ids) {
        String[] split = ids.split(",");
        ArrayList<Long> ls = new ArrayList<Long>(split.length);
        for (int i = 0; i < split.length; ++i) {
            ls.add(Long.valueOf(split[i]));
        }
        return ls;
    }

    public static <E> List<E> arrayToList(E[] es) {
        ArrayList<E> list = new ArrayList<E>(es.length);
        for (E e : es) {
            list.add(e);
        }
        return list;
    }

    public static String[] toArrray(Collection<String> collection) {
        String[] arr = new String[collection.size()];
        int i = 0;
        Iterator<String> iterator = collection.iterator();
        while (iterator.hasNext()) {
            String e;
            arr[i] = e = iterator.next();
            ++i;
        }
        return arr;
    }

    public static Long[] toLongArrray(Collection<Long> collection) {
        Long[] arr = new Long[collection.size()];
        int i = 0;
        Iterator<Long> iterator = collection.iterator();
        while (iterator.hasNext()) {
            Long e;
            arr[i] = e = iterator.next();
            ++i;
        }
        return arr;
    }

    public static Integer[] toIntArrray(Collection<Integer> collection) {
        Integer[] arr = new Integer[collection.size()];
        int i = 0;
        Iterator<Integer> iterator = collection.iterator();
        while (iterator.hasNext()) {
            Integer e;
            arr[i] = e = iterator.next();
            ++i;
        }
        return arr;
    }

    public static <T> Collection<T> union(Collection<T> t1, Collection<T> t2) {
        return org.apache.commons.collections.CollectionUtils.union(t1, t2);
    }

    public static <T> Collection<T> intersection(Collection<T> t1, Collection<T> t2) {
        return org.apache.commons.collections.CollectionUtils.intersection(t1, t2);
    }

    public static <T> Collection<T> subtract(Collection<T> t1, Collection<T> t2) {
        return org.apache.commons.collections.CollectionUtils.subtract(t1, t2);
    }

    public static LinkedHashMap<String, LinkedHashMap<String, LinkedHashMap<String, ArrayList<String>>>> castMap2list1ToMap3null1(LinkedHashMap<String, LinkedHashMap<String, ArrayList<String>>> src) {
        LinkedHashMap<String, LinkedHashMap<String, LinkedHashMap<String, ArrayList<String>>>> desc = new LinkedHashMap<String, LinkedHashMap<String, LinkedHashMap<String, ArrayList<String>>>>();
        LinkedHashMap map1 = null;
        LinkedHashMap<String, ArrayList<String>> map2 = null;
        LinkedHashMap<String, Object> map3 = null;
        ArrayList<String> list1 = null;
        Set<String> twSet = src.keySet();
        for (String key : twSet) {
            map2 = src.get(key);
            Set<String> keySet = map2.keySet();
            map1 = new LinkedHashMap();
            for (String k : keySet) {
                list1 = map2.get(k);
                map3 = new LinkedHashMap<String, Object>();
                for (String s : list1) {
                    map3.put(s, null);
                }
                map1.put(k, map3);
            }
            desc.put(key, map1);
        }
        return desc;
    }

    public static LinkedHashMap<String, LinkedHashMap<String, LinkedHashMap<String, ArrayList<String>>>> castMap1list1ToMap3null2(LinkedHashMap<String, ArrayList<String>> src) {
        LinkedHashMap<String, LinkedHashMap<String, LinkedHashMap<String, ArrayList<String>>>> desc = new LinkedHashMap<String, LinkedHashMap<String, LinkedHashMap<String, ArrayList<String>>>>();
        LinkedHashMap<String, Object> map1 = null;
        ArrayList<String> list1 = null;
        Set<String> mcSet = src.keySet();
        for (String key : mcSet) {
            list1 = src.get(key);
            map1 = new LinkedHashMap<String, Object>();
            for (String k : list1) {
                map1.put(k, null);
            }
            desc.put(key, map1);
        }
        return desc;
    }

    public static <T> List<List<T>> split(List<T> resList, int splitSize) {
        ArrayList<T> itemList;
        if (resList == null || resList.isEmpty()) {
            return new ArrayList<List<T>>();
        }
        if (splitSize < 1) {
            splitSize = 1;
        }
        ArrayList<List<T>> ret = new ArrayList<List<T>>();
        int size = resList.size();
        if (size <= splitSize) {
            ret.add(resList);
            return ret;
        }
        int subCount = size / splitSize;
        for (int i = 0; i < subCount; ++i) {
            itemList = new ArrayList<T>();
            for (int j = 0; j < splitSize; ++j) {
                itemList.add(resList.get(i * splitSize + j));
            }
            ret.add(itemList);
        }
        int last = size % splitSize;
        if (last > 0) {
            itemList = new ArrayList();
            for (int i = 0; i < last; ++i) {
                itemList.add(resList.get(subCount * splitSize + i));
            }
            ret.add(itemList);
        }
        return ret;
    }

    public static <T> List<T> distinctList(Collection<T> collection) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(collection)) {
            return Collections.emptyList();
        }
        return collection.stream().distinct().collect(Collectors.toList());
    }
}

