/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.util;

import cn.dolphin.core.bean.BeanFieldCache;
import cn.dolphin.core.bean.IntrospectionCache;
import cn.dolphin.core.date.DateUtil;
import cn.dolphin.core.enums.DateEnum;
import cn.dolphin.core.exception.UtilsRuntimeException;
import cn.dolphin.core.util.ExceptionUtil;
import cn.dolphin.core.util.StrUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileFilter;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.SynthesizingMethodParameter;
import org.springframework.util.ClassUtils;
import org.springframework.web.method.HandlerMethod;

public class ClassUtil
extends ClassUtils {
    private static final String OBJECT_NAME = "java.lang.Object";
    private static final List<Class> BASE_CLASS = Lists.newArrayList((Object[])new Class[]{Integer.class, Integer.TYPE, Long.class, Long.TYPE, Short.class, Short.TYPE, Byte.class, Short.TYPE, Float.class, Float.TYPE, Double.class, Double.TYPE, BigDecimal.class, String.class, Date.class, Integer[].class, int[].class, Long[].class, long[].class, Short[].class, short[].class, Byte[].class, short[].class, Float[].class, float[].class, Double[].class, double[].class, BigDecimal[].class, String[].class, Map.class, Collection.class});
    private static final List<Class> NUMBER_CLASS = Lists.newArrayList((Object[])new Class[]{Integer.class, Integer.TYPE, Long.class, Long.TYPE, Short.class, Short.TYPE, Byte.class, Short.TYPE, Float.class, Float.TYPE, Double.class, Double.TYPE, BigDecimal.class});
    private static final List<Class> DECIMAL_CLASS = Lists.newArrayList((Object[])new Class[]{Float.class, Float.TYPE, Double.class, Double.TYPE, BigDecimal.class});
    private static final List<Class> INTEGER_CLASS = Lists.newArrayList((Object[])new Class[]{Integer.class, Integer.TYPE, Long.class, Long.TYPE, Short.class, Short.TYPE, Byte.class, Short.TYPE});
    private static final Map<String, Class> KEY_CLASS = Maps.newHashMap();
    private static final ParameterNameDiscoverer PARAMETER_NAME_DISCOVERER;

    public static MethodParameter getMethodParameter(Constructor<?> constructor, int parameterIndex) {
        SynthesizingMethodParameter methodParameter = new SynthesizingMethodParameter(constructor, parameterIndex);
        methodParameter.initParameterNameDiscovery(PARAMETER_NAME_DISCOVERER);
        return methodParameter;
    }

    public static MethodParameter getMethodParameter(Method method, int parameterIndex) {
        SynthesizingMethodParameter methodParameter = new SynthesizingMethodParameter(method, parameterIndex);
        methodParameter.initParameterNameDiscovery(PARAMETER_NAME_DISCOVERER);
        return methodParameter;
    }

    public static <A extends Annotation> A getAnnotation(Method method, Class<A> annotationType) {
        Class<?> targetClass = method.getDeclaringClass();
        Method specificMethod = ClassUtil.getMostSpecificMethod((Method)method, targetClass);
        Annotation annotation = AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)(specificMethod = BridgeMethodResolver.findBridgedMethod((Method)specificMethod)), annotationType);
        if (null != annotation) {
            return (A)annotation;
        }
        return (A)AnnotatedElementUtils.findMergedAnnotation(specificMethod.getDeclaringClass(), annotationType);
    }

    public static <A extends Annotation> A getAnnotation(HandlerMethod handlerMethod, Class<A> annotationType) {
        Annotation annotation = handlerMethod.getMethodAnnotation(annotationType);
        if (null != annotation) {
            return (A)annotation;
        }
        Class beanType = handlerMethod.getBeanType();
        return (A)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)beanType, annotationType);
    }

    public static String getPackageName(Class<?> clazz) {
        return clazz.getPackage().getName();
    }

    public static String getClassName(Class<?> clazz) {
        return clazz.getSimpleName();
    }

    public static String getClass(Class<?> clazz) {
        return clazz.getName();
    }

    public static boolean isBaseDataType(Class<?> clazz) {
        return BASE_CLASS.contains(clazz);
    }

    public static boolean isExtendDataType(Object data) {
        for (Class clazz : BASE_CLASS) {
            if (!clazz.isInstance(data)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNumberType(Class<?> clazz) {
        return NUMBER_CLASS.contains(clazz);
    }

    public static boolean isExtendNumberType(Object data) {
        for (Class clazz : NUMBER_CLASS) {
            if (!clazz.isInstance(data)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDecimalType(Class<?> clazz) {
        return DECIMAL_CLASS.contains(clazz);
    }

    public static boolean isExtendDecimalType(Object data) {
        for (Class clazz : DECIMAL_CLASS) {
            if (!clazz.isInstance(data)) continue;
            return true;
        }
        return false;
    }

    public static boolean isIntegerType(Class<?> clazz) {
        return INTEGER_CLASS.contains(clazz);
    }

    public static boolean isExtendIntegerType(Object data) {
        for (Class clazz : INTEGER_CLASS) {
            if (!clazz.isInstance(data)) continue;
            return true;
        }
        return false;
    }

    public static List<Field> getAllFields(Class clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        for (Class superClass = clazz.getSuperclass(); null != superClass && !OBJECT_NAME.equalsIgnoreCase(superClass.getName()); superClass = superClass.getSuperclass()) {
            ClassUtil.getFields(superClass, fields);
        }
        return fields;
    }

    public static Method getMethod(Class clazz, String methodName) {
        Method[] methods;
        for (Method method : methods = clazz.getDeclaredMethods()) {
            if (!method.getName().equals(methodName)) continue;
            return method;
        }
        return null;
    }

    public static Class<?> getFieldType(Class clazz, String fieldName) {
        Field field = ClassUtil.getField(clazz, fieldName);
        if (Objects.nonNull(field)) {
            return field.getType();
        }
        return null;
    }

    public static Field getField(Class clazz, String fieldName) {
        Field[] fields;
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (!field.getName().equals(fieldName)) continue;
            return field;
        }
        return null;
    }

    public static boolean hasField(Class clazz, String fieldName) {
        Field field = ClassUtil.getField(clazz, fieldName);
        return Objects.nonNull(field);
    }

    public static boolean hasField(Object data) {
        Field[] fields = data.getClass().getDeclaredFields();
        return fields.length > 0;
    }

    public static boolean setValue(Object entity, String fieldName, Object fieldValue) {
        try {
            PropertyDescriptor propertyDescriptor = PropertyUtils.getPropertyDescriptor((Object)entity, (String)fieldName);
            Class<?> fieldType = propertyDescriptor.getPropertyType();
            fieldValue = ClassUtil.transfer(fieldType, fieldValue);
            PropertyUtils.setSimpleProperty((Object)entity, (String)fieldName, (Object)fieldValue);
            return true;
        }
        catch (Exception e) {
            ExceptionUtil.printStackTrace(e);
            return false;
        }
    }

    public static <E, V> V getValue(E entity, String fieldName) {
        Object id = null;
        try {
            id = Map.class.isInstance(entity) ? ((Map)entity).get(fieldName) : PropertyUtils.getSimpleProperty(entity, (String)fieldName);
        }
        catch (Exception e) {
            ExceptionUtil.printStackTrace(e);
        }
        return (V)id;
    }

    @Deprecated
    public static <E, V> V getValue(String fieldName, E entity) {
        return ClassUtil.getValue(entity, fieldName);
    }

    public static Class<?> getBaseClass(String simpleClassName) {
        return KEY_CLASS.get(simpleClassName);
    }

    private static void getFields(Class clazz, List<Field> fields) {
        if (null == clazz) {
            return;
        }
        if (OBJECT_NAME.equalsIgnoreCase(clazz.getSimpleName())) {
            return;
        }
        fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
    }

    private static Object transfer(Class<?> fieldType, Object value) {
        if (Objects.isNull(value)) {
            return null;
        }
        if (fieldType.equals(Integer.class)) {
            return Integer.valueOf(value.toString());
        }
        if (fieldType.equals(Long.class)) {
            return Long.valueOf(value.toString());
        }
        if (fieldType.equals(Float.class)) {
            return Float.valueOf(value.toString());
        }
        if (fieldType.equals(Double.class)) {
            return Double.valueOf(value.toString());
        }
        if (fieldType.equals(Byte.class)) {
            return Byte.valueOf(value.toString());
        }
        if (fieldType.equals(Boolean.class)) {
            return Boolean.valueOf(value.toString());
        }
        if (fieldType.equals(String.class)) {
            return value;
        }
        if (fieldType.equals(BigDecimal.class)) {
            return new BigDecimal(value.toString());
        }
        if (fieldType.equals(Date.class)) {
            return DateUtil.format(DateUtil.create(((Date)value).getTime()), DateEnum.FORMAT_YYMMDDHMS_MID);
        }
        return value;
    }

    public static List<Class<?>> getClassList(String packageName, boolean isRecursive) {
        ArrayList classList = new ArrayList();
        try {
            Enumeration<URL> urls = Thread.currentThread().getContextClassLoader().getResources(packageName.replaceAll("\\.", "/"));
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                if (url == null) continue;
                String protocol = url.getProtocol();
                if (protocol.equals("file")) {
                    String packagePath = url.getPath();
                    ClassUtil.addClass(classList, packagePath, packageName, isRecursive);
                    continue;
                }
                if (!protocol.equals("jar")) continue;
                JarURLConnection jarURLConnection = (JarURLConnection)url.openConnection();
                JarFile jarFile = jarURLConnection.getJarFile();
                Enumeration<JarEntry> jarEntries = jarFile.entries();
                while (jarEntries.hasMoreElements()) {
                    JarEntry jarEntry = jarEntries.nextElement();
                    String jarEntryName = jarEntry.getName();
                    if (!jarEntryName.endsWith(".class")) continue;
                    String className = jarEntryName.substring(0, jarEntryName.lastIndexOf(".")).replaceAll("/", ".");
                    if (!isRecursive && !className.substring(0, className.lastIndexOf(".")).equals(packageName)) continue;
                    classList.add(Class.forName(className));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return classList;
    }

    public static List<Class<?>> getClassListByAnnotation(String packageName, Class<? extends Annotation> annotationClass) {
        ArrayList classList = new ArrayList();
        try {
            Enumeration<URL> urls = Thread.currentThread().getContextClassLoader().getResources(packageName.replaceAll("\\.", "/"));
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                if (url == null) continue;
                String protocol = url.getProtocol();
                if (protocol.equals("file")) {
                    String packagePath = url.getPath();
                    ClassUtil.addClassByAnnotation(classList, packagePath, packageName, annotationClass);
                    continue;
                }
                if (!protocol.equals("jar")) continue;
                JarURLConnection jarURLConnection = (JarURLConnection)url.openConnection();
                JarFile jarFile = jarURLConnection.getJarFile();
                Enumeration<JarEntry> jarEntries = jarFile.entries();
                while (jarEntries.hasMoreElements()) {
                    String className;
                    Class<?> cls;
                    JarEntry jarEntry = jarEntries.nextElement();
                    String jarEntryName = jarEntry.getName();
                    if (!jarEntryName.endsWith(".class") || !(cls = Class.forName(className = jarEntryName.substring(0, jarEntryName.lastIndexOf(".")).replaceAll("/", "."))).isAnnotationPresent(annotationClass)) continue;
                    classList.add(cls);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return classList;
    }

    public static List<Class<?>> getClassListBySuper(String packageName, Class<?> superClass) {
        ArrayList classList = new ArrayList();
        try {
            Enumeration<URL> urls = Thread.currentThread().getContextClassLoader().getResources(packageName.replaceAll("\\.", "/"));
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                if (url == null) continue;
                String protocol = url.getProtocol();
                if (protocol.equals("file")) {
                    String packagePath = url.getPath();
                    ClassUtil.addClassBySuper(classList, packagePath, packageName, superClass);
                    continue;
                }
                if (!protocol.equals("jar")) continue;
                JarURLConnection jarURLConnection = (JarURLConnection)url.openConnection();
                JarFile jarFile = jarURLConnection.getJarFile();
                Enumeration<JarEntry> jarEntries = jarFile.entries();
                while (jarEntries.hasMoreElements()) {
                    String className;
                    Class<?> cls;
                    JarEntry jarEntry = jarEntries.nextElement();
                    String jarEntryName = jarEntry.getName();
                    if (!jarEntryName.endsWith(".class") || !superClass.isAssignableFrom(cls = Class.forName(className = jarEntryName.substring(0, jarEntryName.lastIndexOf(".")).replaceAll("/", "."))) || superClass.equals(cls)) continue;
                    classList.add(cls);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return classList;
    }

    public static List<Class<?>> getClassListByInterface(String packageName, Class<?> interfaceClass) {
        ArrayList classList = new ArrayList();
        try {
            Enumeration<URL> urls = Thread.currentThread().getContextClassLoader().getResources(packageName.replaceAll("\\.", "/"));
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                if (url == null) continue;
                String protocol = url.getProtocol();
                if (protocol.equals("file")) {
                    String packagePath = url.getPath();
                    ClassUtil.addClassByInterface(classList, packagePath, packageName, interfaceClass);
                    continue;
                }
                if (!protocol.equals("jar")) continue;
                JarURLConnection jarURLConnection = (JarURLConnection)url.openConnection();
                JarFile jarFile = jarURLConnection.getJarFile();
                Enumeration<JarEntry> jarEntries = jarFile.entries();
                while (jarEntries.hasMoreElements()) {
                    String className;
                    Class<?> cls;
                    JarEntry jarEntry = jarEntries.nextElement();
                    String jarEntryName = jarEntry.getName();
                    if (!jarEntryName.endsWith(".class") || !interfaceClass.isAssignableFrom(cls = Class.forName(className = jarEntryName.substring(0, jarEntryName.lastIndexOf(".")).replaceAll("/", "."))) || interfaceClass.equals(cls)) continue;
                    classList.add(cls);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return classList;
    }

    private static void addClass(List<Class<?>> classList, String packagePath, String packageName, boolean isRecursive) {
        try {
            File[] files = ClassUtil.getClassFiles(packagePath);
            if (files != null) {
                for (File file : files) {
                    String fileName = file.getName();
                    if (file.isFile()) {
                        String className = ClassUtil.getClassName(packageName, fileName);
                        classList.add(Class.forName(className));
                        continue;
                    }
                    if (!isRecursive) continue;
                    String subPackagePath = ClassUtil.getSubPackagePath(packagePath, fileName);
                    String subPackageName = ClassUtil.getSubPackageName(packageName, fileName);
                    ClassUtil.addClass(classList, subPackagePath, subPackageName, isRecursive);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static File[] getClassFiles(String packagePath) {
        return new File(packagePath).listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile() && file.getName().endsWith(".class") || file.isDirectory();
            }
        });
    }

    private static String getClassName(String packageName, String fileName) {
        String className = fileName.substring(0, fileName.lastIndexOf("."));
        if (packageName != null) {
            className = packageName + "." + className;
        }
        return className;
    }

    private static String getSubPackagePath(String packagePath, String filePath) {
        String subPackagePath = filePath;
        if (packagePath != null) {
            subPackagePath = packagePath + "/" + subPackagePath;
        }
        return subPackagePath;
    }

    private static String getSubPackageName(String packageName, String filePath) {
        String subPackageName = filePath;
        if (packageName != null) {
            subPackageName = packageName + "." + subPackageName;
        }
        return subPackageName;
    }

    private static void addClassByAnnotation(List<Class<?>> classList, String packagePath, String packageName, Class<? extends Annotation> annotationClass) {
        try {
            File[] files = ClassUtil.getClassFiles(packagePath);
            if (files != null) {
                for (File file : files) {
                    String fileName = file.getName();
                    if (file.isFile()) {
                        String className = ClassUtil.getClassName(packageName, fileName);
                        Class<?> cls = Class.forName(className);
                        if (!cls.isAnnotationPresent(annotationClass)) continue;
                        classList.add(cls);
                        continue;
                    }
                    String subPackagePath = ClassUtil.getSubPackagePath(packagePath, fileName);
                    String subPackageName = ClassUtil.getSubPackageName(packageName, fileName);
                    ClassUtil.addClassByAnnotation(classList, subPackagePath, subPackageName, annotationClass);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void addClassBySuper(List<Class<?>> classList, String packagePath, String packageName, Class<?> superClass) {
        try {
            File[] files = ClassUtil.getClassFiles(packagePath);
            if (files != null) {
                for (File file : files) {
                    String fileName = file.getName();
                    if (file.isFile()) {
                        String className = ClassUtil.getClassName(packageName, fileName);
                        Class<?> cls = Class.forName(className);
                        if (!superClass.isAssignableFrom(cls) || superClass.equals(cls)) continue;
                        classList.add(cls);
                        continue;
                    }
                    String subPackagePath = ClassUtil.getSubPackagePath(packagePath, fileName);
                    String subPackageName = ClassUtil.getSubPackageName(packageName, fileName);
                    ClassUtil.addClassBySuper(classList, subPackagePath, subPackageName, superClass);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void addClassByInterface(List<Class<?>> classList, String packagePath, String packageName, Class<?> interfaceClass) {
        try {
            File[] files = ClassUtil.getClassFiles(packagePath);
            if (files != null) {
                for (File file : files) {
                    String fileName = file.getName();
                    if (file.isFile()) {
                        String className = ClassUtil.getClassName(packageName, fileName);
                        Class<?> cls = Class.forName(className);
                        if (!interfaceClass.isAssignableFrom(cls) || interfaceClass.equals(cls)) continue;
                        classList.add(cls);
                        continue;
                    }
                    String subPackagePath = ClassUtil.getSubPackagePath(packagePath, fileName);
                    String subPackageName = ClassUtil.getSubPackageName(packageName, fileName);
                    ClassUtil.addClassByInterface(classList, subPackagePath, subPackageName, interfaceClass);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static PropertyDescriptor[] getSelfPropertyDescriptors(Class<?> beanClass) {
        return ClassUtil.getPropertyDescriptors(beanClass, beanClass.getSuperclass());
    }

    public static PropertyDescriptor[] getPropertyDescriptors(Class<?> beanClass) {
        return ClassUtil.getPropertyDescriptors(beanClass, null);
    }

    public static PropertyDescriptor[] getPropertyDescriptors(Class<?> beanClass, Class<?> stopClass) {
        IntrospectionCache introspectionCache = IntrospectionCache.forClass(beanClass, stopClass);
        return introspectionCache.getPropertyDescriptors();
    }

    public static PropertyDescriptor getPropertyDescriptor(Class<?> beanClass, String propertyName) {
        IntrospectionCache introspectionCache = IntrospectionCache.forClass(beanClass);
        return introspectionCache.getPropertyDescriptor(propertyName);
    }

    public static Field[] getSelfFields(Class<?> beanClass) {
        return ClassUtil.getBeanFields(beanClass, beanClass.getSuperclass());
    }

    public static Field[] getBeanFields(Class<?> beanClass) {
        return ClassUtil.getBeanFields(beanClass, null);
    }

    public static Field[] getBeanFields(Class<?> beanClass, Class<?> stopClass) {
        BeanFieldCache beanFieldCache = BeanFieldCache.forClass(beanClass, stopClass);
        return beanFieldCache.getBeanFields();
    }

    public static Field getBeanField(Class<?> beanClass, String fieldName) {
        BeanFieldCache beanFieldCache = BeanFieldCache.forClass(beanClass);
        return beanFieldCache.getBeanField(fieldName);
    }

    public static Object getFieldValue(Class<?> clazz, Object obj, String fieldName) {
        PropertyDescriptor propertyDescriptor = ClassUtil.getPropertyDescriptor(clazz, fieldName);
        Method readMethod = propertyDescriptor.getReadMethod();
        return ClassUtil.invokeMethod(readMethod, obj);
    }

    public static Map<String, Object> getSelfBeanPropMap(Object object, Class<? extends Annotation> ignoreAnnotation) {
        HashMap<String, Object> propMap = new HashMap<String, Object>();
        PropertyDescriptor[] propertyDescriptors = ClassUtil.getSelfPropertyDescriptors(object.getClass());
        if (propertyDescriptors == null) {
            return propMap;
        }
        for (PropertyDescriptor pd : propertyDescriptors) {
            Method readMethod = pd.getReadMethod();
            if (readMethod == null || readMethod.getAnnotation(ignoreAnnotation) != null) continue;
            Object value = ClassUtil.invokeMethod(readMethod, object);
            propMap.put(pd.getName(), value);
        }
        return propMap;
    }

    public static Method getMethod(Class<?> beanClazz, String methodName, Class<?>[] paramTypes) {
        try {
            return beanClazz.getMethod(methodName, paramTypes);
        }
        catch (NoSuchMethodException e) {
            throw new UtilsRuntimeException("\u83b7\u53d6Method\u5931\u8d25:" + methodName, e);
        }
    }

    public static Object invokeMethod(Method method, Object bean, Object ... value) {
        try {
            ClassUtil.methodAccessible(method);
            Object[] parameters = new Object[value.length];
            Class<?>[] parameterTypes = method.getParameterTypes();
            for (int i = 0; i < value.length; ++i) {
                parameters[i] = parameterTypes[i] == value[i].getClass() ? value[i] : (parameterTypes[i] == Boolean.class || parameterTypes[i] == Boolean.TYPE ? Boolean.valueOf(BooleanUtils.toBoolean((String)String.valueOf(value[i]))) : (parameterTypes[i] == Integer.class || parameterTypes[i] == Integer.TYPE ? Integer.valueOf(String.valueOf(value[i])) : (parameterTypes[i] == Long.class || parameterTypes[i] == Long.TYPE ? Long.valueOf(String.valueOf(value[i])) : value[i])));
            }
            return method.invoke(bean, parameters);
        }
        catch (Exception e) {
            throw new UtilsRuntimeException("\u6267\u884cinvokeMethod\u5931\u8d25:" + (method == null ? "null" : method.getName()), e);
        }
    }

    public static Object invokeMethod(Method method, Object bean) {
        try {
            ClassUtil.methodAccessible(method);
            return method.invoke(bean, new Object[0]);
        }
        catch (Exception e) {
            throw new UtilsRuntimeException("\u6267\u884cinvokeMethod\u5931\u8d25:" + (method == null ? "null" : method.getName()), e);
        }
    }

    public static void methodAccessible(Method method) {
        if (!Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
            method.setAccessible(true);
        }
    }

    public static Object newInstance(Class<?> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new UtilsRuntimeException("\u6839\u636eclass\u521b\u5efa\u5b9e\u4f8b\u5931\u8d25:" + (clazz == null ? "null" : clazz.getName()), e);
        }
    }

    public static Object newInstance(String clazz) {
        try {
            Class<?> loadClass = ClassUtil.getDefaultClassLoader().loadClass(clazz);
            return loadClass.newInstance();
        }
        catch (Exception e) {
            throw new UtilsRuntimeException("\u6839\u636eclass\u521b\u5efa\u5b9e\u4f8b\u5931\u8d25:" + clazz, e);
        }
    }

    public static Class<?> loadClass(String clazz) {
        try {
            Class<?> loadClass = ClassUtil.getDefaultClassLoader().loadClass(clazz);
            return loadClass;
        }
        catch (Exception e) {
            throw new UtilsRuntimeException("\u6839\u636eclass\u540d\u79f0\u52a0\u8f7dclass\u5931\u8d25:" + clazz, e);
        }
    }

    public static Object toTargetTypeValue(Object value, Class<?> targetType) {
        String typeName = targetType.getName();
        if (StrUtil.equals((CharSequence)typeName, (CharSequence)Boolean.TYPE.getName()) || StrUtil.equals((CharSequence)typeName, (CharSequence)Boolean.class.getName())) {
            return Boolean.valueOf(value.toString());
        }
        if (StrUtil.equals((CharSequence)typeName, (CharSequence)Integer.TYPE.getName()) || StrUtil.equals((CharSequence)typeName, (CharSequence)Integer.class.getName())) {
            return Integer.valueOf(value.toString());
        }
        if (StrUtil.equals((CharSequence)typeName, (CharSequence)Long.TYPE.getName()) || StrUtil.equals((CharSequence)typeName, (CharSequence)Long.class.getName())) {
            return Long.valueOf(value.toString());
        }
        if (StrUtil.equals((CharSequence)typeName, (CharSequence)Short.TYPE.getName()) || StrUtil.equals((CharSequence)typeName, (CharSequence)Short.class.getName())) {
            return Short.valueOf(value.toString());
        }
        if (StrUtil.equals((CharSequence)typeName, (CharSequence)Float.TYPE.getName()) || StrUtil.equals((CharSequence)typeName, (CharSequence)Float.class.getName())) {
            return Float.valueOf(value.toString());
        }
        if (StrUtil.equals((CharSequence)typeName, (CharSequence)Double.TYPE.getName()) || StrUtil.equals((CharSequence)typeName, (CharSequence)Double.class.getName())) {
            return Double.valueOf(value.toString());
        }
        if (StrUtil.equals((CharSequence)typeName, (CharSequence)Byte.TYPE.getName()) || StrUtil.equals((CharSequence)typeName, (CharSequence)Byte.class.getName())) {
            return Byte.valueOf(value.toString());
        }
        return value;
    }

    public static ClassLoader getDefaultClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    private ClassUtil() {
    }

    static {
        for (Class clazz : BASE_CLASS) {
            KEY_CLASS.put(clazz.getSimpleName(), clazz);
            KEY_CLASS.put(clazz.getSimpleName().toLowerCase(), clazz);
        }
        PARAMETER_NAME_DISCOVERER = new DefaultParameterNameDiscoverer();
    }
}

