/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.util;

import java.time.LocalDate;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CircularCounter {
    private static final Logger logger = LoggerFactory.getLogger(CircularCounter.class);
    private static final AtomicReferenceFieldUpdater<CircularCounter, AtomicInteger> valueUpdater = AtomicReferenceFieldUpdater.newUpdater(CircularCounter.class, AtomicInteger.class, "value");
    private volatile String key = this.getCurrentDateString();
    private volatile AtomicInteger value = new AtomicInteger(0);

    public Integer addAndGet() {
        AtomicInteger oldValue = this.value;
        AtomicInteger newInteger = new AtomicInteger(0);
        int newVal = -1;
        String newDateStr = this.getCurrentDateString();
        if (this.isDateEquals(newDateStr)) {
            newVal = this.add(1);
            return newVal;
        }
        this.reSet(oldValue, newInteger, newDateStr);
        this.key = newDateStr;
        newVal = this.add(1);
        return newVal;
    }

    public Integer get() {
        return this.value.get();
    }

    private boolean isDateEquals(String newDateStr) {
        String oldDateStr = this.key;
        return !StringUtils.isBlank((CharSequence)oldDateStr) && oldDateStr.equals(newDateStr);
    }

    private void reSet(AtomicInteger oldValue, AtomicInteger newValue, String newDateStr) {
        if (valueUpdater.compareAndSet(this, oldValue, newValue)) {
            logger.debug("\u7ebf\u7a0b" + Thread.currentThread().getName() + "\u53d1\u73b0\u65e5\u671f\u53d1\u751f\u53d8\u5316");
        }
    }

    private String getCurrentDateString() {
        return LocalDate.now().toString();
    }

    public int add(int increment) {
        return this.value.addAndGet(increment);
    }
}

