/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.util;

import cn.dolphin.core.exception.UtilsRuntimeException;
import cn.dolphin.core.util.CollectionUtil;
import cn.dolphin.core.util.StrFormatter;
import cn.dolphin.core.util.StrUtil;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public final class CastUtil {
    private CastUtil() {
        throw new IllegalAccessError("Utility class");
    }

    public static Object convert(Object obj, String type, String format) throws UtilsRuntimeException {
        Locale locale = new Locale("zh", "CN", "");
        if (obj == null) {
            return null;
        }
        if (obj.getClass().getName().equals(type)) {
            return obj;
        }
        if ("Object".equals(type) || "java.lang.Object".equals(type)) {
            return obj;
        }
        String fromType = null;
        if (obj instanceof String) {
            fromType = "String";
            String str = (String)obj;
            if ("String".equals(type) || "java.lang.String".equals(type)) {
                return obj;
            }
            if (str.length() == 0) {
                return null;
            }
            if ("Boolean".equals(type) || "java.lang.Boolean".equals(type)) {
                Boolean value = null;
                value = str.equalsIgnoreCase("TRUE") ? new Boolean(true) : new Boolean(false);
                return value;
            }
            if ("Double".equals(type) || "java.lang.Double".equals(type)) {
                try {
                    Number tempNum = CastUtil.getNf(locale).parse(str);
                    return new Double(tempNum.doubleValue());
                }
                catch (ParseException e) {
                    throw new UtilsRuntimeException("Could not convert " + str + " to " + type + ". ", e);
                }
            }
            if ("BigDecimal".equals(type) || "java.math.BigDecimal".equals(type)) {
                try {
                    BigDecimal retBig = new BigDecimal(str);
                    int iscale = str.indexOf(".");
                    int keylen = str.length();
                    if (iscale > -1) {
                        iscale = keylen - (iscale + 1);
                        return retBig.setScale(iscale, 5);
                    }
                    return retBig.setScale(0, 5);
                }
                catch (Exception e) {
                    throw new UtilsRuntimeException("Could not convert " + str + " to " + type + ". ", e);
                }
            }
            if ("Float".equals(type) || "java.lang.Float".equals(type)) {
                try {
                    Number tempNum = CastUtil.getNf(locale).parse(str);
                    return new Float(tempNum.floatValue());
                }
                catch (ParseException e) {
                    throw new UtilsRuntimeException("Could not convert " + str + " to " + type + ". ", e);
                }
            }
            if ("Long".equals(type) || "java.lang.Long".equals(type)) {
                try {
                    NumberFormat nf = CastUtil.getNf(locale);
                    nf.setMaximumFractionDigits(0);
                    Number tempNum = nf.parse(str);
                    return new Long(tempNum.longValue());
                }
                catch (ParseException e) {
                    throw new UtilsRuntimeException("Could not convert " + str + " to " + type + ". ", e);
                }
            }
            if ("Integer".equals(type) || "java.lang.Integer".equals(type)) {
                try {
                    NumberFormat nf = CastUtil.getNf(locale);
                    nf.setMaximumFractionDigits(0);
                    Number tempNum = nf.parse(str);
                    return new Integer(tempNum.intValue());
                }
                catch (ParseException e) {
                    throw new UtilsRuntimeException("Could not convert " + str + " to " + type + ". ", e);
                }
            }
            if ("Date".equals(type) || "java.sql.Date".equals(type)) {
                if (format == null || format.length() == 0) {
                    try {
                        return Date.valueOf(str);
                    }
                    catch (Exception e) {
                        try {
                            DateFormat df = null;
                            df = locale != null ? DateFormat.getDateInstance(3, locale) : DateFormat.getDateInstance(3);
                            java.util.Date fieldDate = df.parse(str);
                            return new Date(fieldDate.getTime());
                        }
                        catch (ParseException e1) {
                            throw new UtilsRuntimeException("Could not convert " + str + " to " + type + ". ", e);
                        }
                    }
                }
                try {
                    SimpleDateFormat sdf = new SimpleDateFormat(format);
                    java.util.Date fieldDate = sdf.parse(str);
                    return new Date(fieldDate.getTime());
                }
                catch (ParseException e) {
                    throw new UtilsRuntimeException("Could not convert " + str + " to " + type + ". ", e);
                }
            }
            if ("Timestamp".equals(type) || "java.sql.Timestamp".equals(type)) {
                if (str.length() == 10) {
                    str = str + " 00:00:00";
                }
                if (format == null || format.length() == 0) {
                    try {
                        return Timestamp.valueOf(str);
                    }
                    catch (Exception e) {
                        try {
                            DateFormat df = null;
                            df = locale != null ? DateFormat.getDateTimeInstance(3, 3, locale) : DateFormat.getDateTimeInstance(3, 3);
                            java.util.Date fieldDate = df.parse(str);
                            return new Timestamp(fieldDate.getTime());
                        }
                        catch (ParseException e1) {
                            throw new UtilsRuntimeException("Could not convert " + str + " to " + type + ". ", e);
                        }
                    }
                }
                try {
                    SimpleDateFormat sdf = new SimpleDateFormat(format);
                    java.util.Date fieldDate = sdf.parse(str);
                    return new Timestamp(fieldDate.getTime());
                }
                catch (ParseException e) {
                    throw new UtilsRuntimeException("Could not convert " + str + " to " + type + ". ", e);
                }
            }
            throw new UtilsRuntimeException("Conversion from " + fromType + " to " + type + " not currently supported");
        }
        if (obj instanceof BigDecimal) {
            fromType = "BigDecimal";
            BigDecimal bigD = (BigDecimal)obj;
            if ("String".equals(type)) {
                return CastUtil.getNf(locale).format(bigD.doubleValue());
            }
            if ("BigDecimal".equals(type) || "java.math.BigDecimal".equals(type)) {
                return obj;
            }
            if ("Double".equals(type)) {
                return new Double(bigD.doubleValue());
            }
            if ("Float".equals(type)) {
                return new Float(bigD.floatValue());
            }
            if ("Long".equals(type)) {
                return new Long(Math.round(bigD.doubleValue()));
            }
            if ("Integer".equals(type)) {
                return new Integer((int)Math.round(bigD.doubleValue()));
            }
            throw new UtilsRuntimeException("Conversion from " + fromType + " to " + type + " not currently supported");
        }
        if (obj instanceof Double) {
            fromType = "Double";
            Double dbl = (Double)obj;
            if ("String".equals(type) || "java.lang.String".equals(type)) {
                return CastUtil.getNf(locale).format(dbl);
            }
            if ("Double".equals(type) || "java.lang.Double".equals(type)) {
                return obj;
            }
            if ("Float".equals(type) || "java.lang.Float".equals(type)) {
                return new Float(dbl.floatValue());
            }
            if ("Long".equals(type) || "java.lang.Long".equals(type)) {
                return new Long(Math.round(dbl));
            }
            if ("Integer".equals(type) || "java.lang.Integer".equals(type)) {
                return new Integer((int)Math.round(dbl));
            }
            if ("BigDecimal".equals(type) || "java.math.BigDecimal".equals(type)) {
                return new BigDecimal(dbl.toString());
            }
            throw new UtilsRuntimeException("Conversion from " + fromType + " to " + type + " not currently supported");
        }
        if (obj instanceof Float) {
            fromType = "Float";
            Float flt = (Float)obj;
            if ("String".equals(type)) {
                return CastUtil.getNf(locale).format(flt.doubleValue());
            }
            if ("BigDecimal".equals(type) || "java.math.BigDecimal".equals(type)) {
                return new BigDecimal(flt.doubleValue());
            }
            if ("Double".equals(type)) {
                return new Double(flt.doubleValue());
            }
            if ("Float".equals(type)) {
                return obj;
            }
            if ("Long".equals(type)) {
                return new Long(Math.round(flt.doubleValue()));
            }
            if ("Integer".equals(type)) {
                return new Integer((int)Math.round(flt.doubleValue()));
            }
            throw new UtilsRuntimeException("Conversion from " + fromType + " to " + type + " not currently supported");
        }
        if (obj instanceof Long) {
            fromType = "Long";
            Long lng = (Long)obj;
            if ("String".equals(type) || "java.lang.String".equals(type)) {
                return CastUtil.getNf(locale).format(lng);
            }
            if ("Double".equals(type) || "java.lang.Double".equals(type)) {
                return new Double(lng.doubleValue());
            }
            if ("Float".equals(type) || "java.lang.Float".equals(type)) {
                return new Float(lng.floatValue());
            }
            if ("BigDecimal".equals(type) || "java.math.BigDecimal".equals(type)) {
                return new BigDecimal(lng.toString());
            }
            if ("Long".equals(type) || "java.lang.Long".equals(type)) {
                return obj;
            }
            if ("Integer".equals(type) || "java.lang.Integer".equals(type)) {
                return new Integer(lng.intValue());
            }
            throw new UtilsRuntimeException("Conversion from " + fromType + " to " + type + " not currently supported");
        }
        if (obj instanceof Integer) {
            fromType = "Integer";
            Integer intgr = (Integer)obj;
            if ("String".equals(type) || "java.lang.String".equals(type)) {
                return CastUtil.getNf(locale).format(intgr.longValue());
            }
            if ("Double".equals(type) || "java.lang.Double".equals(type)) {
                return new Double(intgr.doubleValue());
            }
            if ("Float".equals(type) || "java.lang.Float".equals(type)) {
                return new Float(intgr.floatValue());
            }
            if ("BigDecimal".equals(type) || "java.math.BigDecimal".equals(type)) {
                String str = intgr.toString();
                BigDecimal retBig = new BigDecimal(intgr.doubleValue());
                int iscale = str.indexOf(".");
                int keylen = str.length();
                if (iscale > -1) {
                    iscale = keylen - (iscale + 1);
                    return retBig.setScale(iscale, 5);
                }
                return retBig.setScale(0, 5);
            }
            if ("Long".equals(type) || "java.lang.Long".equals(type)) {
                return new Long(intgr.longValue());
            }
            if ("Integer".equals(type) || "java.lang.Integer".equals(type)) {
                return obj;
            }
            throw new UtilsRuntimeException("Conversion from " + fromType + " to " + type + " not currently supported");
        }
        if (obj instanceof Date) {
            fromType = "Date";
            Date dte = (Date)obj;
            if ("String".equals(type) || "java.lang.String".equals(type)) {
                if (format == null || format.length() == 0) {
                    return dte.toString();
                }
                SimpleDateFormat sdf = new SimpleDateFormat(format);
                return sdf.format(new java.util.Date(dte.getTime()));
            }
            if ("Date".equals(type) || "java.sql.Date".equals(type)) {
                return obj;
            }
            if ("Time".equals(type) || "java.sql.Time".equals(type)) {
                throw new UtilsRuntimeException("Conversion from " + fromType + " to " + type + " not currently supported");
            }
            if ("Timestamp".equals(type) || "java.sql.Timestamp".equals(type)) {
                return new Timestamp(dte.getTime());
            }
            throw new UtilsRuntimeException("Conversion from " + fromType + " to " + type + " not currently supported");
        }
        if (obj instanceof Timestamp) {
            fromType = "Timestamp";
            Timestamp tme = (Timestamp)obj;
            if ("String".equals(type) || "java.lang.String".equals(type)) {
                if (format == null || format.length() == 0) {
                    return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(tme).toString();
                }
                SimpleDateFormat sdf = new SimpleDateFormat(format);
                return sdf.format(new java.util.Date(tme.getTime()));
            }
            if ("Date".equals(type) || "java.sql.Date".equals(type)) {
                return new Date(tme.getTime());
            }
            if ("Time".equals(type) || "java.sql.Time".equals(type)) {
                return new Time(tme.getTime());
            }
            if ("Timestamp".equals(type) || "java.sql.Timestamp".equals(type)) {
                return obj;
            }
            throw new UtilsRuntimeException("Conversion from " + fromType + " to " + type + " not currently supported");
        }
        if (obj instanceof Boolean) {
            fromType = "Boolean";
            Boolean bol = (Boolean)obj;
            if ("Boolean".equals(type) || "java.lang.Boolean".equals(type)) {
                return bol;
            }
            if ("String".equals(type) || "java.lang.String".equals(type)) {
                return bol.toString();
            }
            if ("Integer".equals(type) || "java.lang.Integer".equals(type)) {
                if (bol.booleanValue()) {
                    return new Integer(1);
                }
                return new Integer(0);
            }
            throw new UtilsRuntimeException("Conversion from " + fromType + " to " + type + " not currently supported");
        }
        if ("String".equals(type) || "java.lang.String".equals(type)) {
            return obj.toString();
        }
        throw new UtilsRuntimeException("Conversion from " + obj.getClass().getName() + " to " + type + " not currently supported");
    }

    public static String castString(Object obj) {
        return CastUtil.castString(obj, "");
    }

    public static String castString(Object obj, String defaultValue) {
        return obj != null ? String.valueOf(obj.toString().trim()) : defaultValue;
    }

    public static Integer castInt(Object obj) {
        return CastUtil.castInt(obj, null);
    }

    public static Integer castInt(Object obj, Integer defaultValue) {
        if (obj == null) {
            return defaultValue;
        }
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        if (obj instanceof Number) {
            return ((Number)obj).intValue();
        }
        String valueStr = CastUtil.castString(obj, null);
        if (StrUtil.isBlank((CharSequence)valueStr)) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(valueStr.trim());
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static Integer[] castIntToArray(boolean isIgnoreConvertError, Object ... values) throws Exception {
        if (CollectionUtil.isEmpty(values)) {
            return new Integer[0];
        }
        Integer[] ints = new Integer[values.length];
        for (int i = 0; i < values.length; ++i) {
            Integer v = CastUtil.castInt(values[i], null);
            if (null == v && !isIgnoreConvertError) {
                throw new Exception(StrFormatter.format("Convert [{}] to Integer error!", values[i]));
            }
            ints[i] = v;
        }
        return ints;
    }

    public static int castLongToInt(Long l) {
        long l1 = l;
        int i1 = (int)l1;
        return i1;
    }

    public static Long castLong(Object obj, Long defaultValue) {
        if (obj == null) {
            return defaultValue;
        }
        if (obj instanceof Long) {
            return (Long)obj;
        }
        if (obj instanceof Number) {
            return ((Number)obj).longValue();
        }
        String valueStr = CastUtil.castString(obj, null);
        if (StrUtil.isBlank((CharSequence)valueStr)) {
            return defaultValue;
        }
        try {
            return new BigDecimal(valueStr.trim()).longValue();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Long castLong(Object obj) {
        return CastUtil.castLong(obj, null);
    }

    public static Long[] castLongToArray(boolean isIgnoreConvertError, Object ... values) throws Exception {
        if (CollectionUtil.isEmpty(values)) {
            return new Long[0];
        }
        Long[] longs = new Long[values.length];
        for (int i = 0; i < values.length; ++i) {
            Long v = CastUtil.castLong(values[i], null);
            if (null == v && !isIgnoreConvertError) {
                throw new Exception(StrFormatter.format("Convert [{}] to Long error!", values[i]));
            }
            longs[i] = v;
        }
        return longs;
    }

    public static double castDouble(Object obj) {
        return CastUtil.castDouble(obj, 0.0);
    }

    public static double castDoubleScale(Object obj, int scale) {
        double dou = CastUtil.castDouble(obj);
        return CastUtil.castRound(dou, scale);
    }

    public static Integer castDoubleToInt(Double d) {
        double db = d;
        int i = (int)db;
        return i;
    }

    public static Integer castStringDoubleToInt(String sd) {
        Double d = Double.valueOf(sd);
        return CastUtil.castDoubleToInt(d);
    }

    private static double castDouble(Object obj, double defaultValue) {
        String strValue;
        double value = defaultValue;
        if (obj != null && StringUtils.isNotBlank((CharSequence)(strValue = CastUtil.castString(obj)))) {
            try {
                value = Double.parseDouble(strValue);
            }
            catch (NumberFormatException e) {
                value = defaultValue;
            }
        }
        return value;
    }

    public static double castRound(double v, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        BigDecimal b = new BigDecimal(Double.toString(v));
        BigDecimal one = new BigDecimal("1");
        return b.divide(one, scale, 4).doubleValue();
    }

    public static Long[] castStringToLong(String[] strs) {
        Long[] longs = new Long[strs.length];
        for (int i = 0; i < strs.length; ++i) {
            String str = strs[i];
            long thelong = Long.valueOf(str);
            longs[i] = thelong;
        }
        return longs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convertStreamToString(InputStream is) {
        StringBuilder sb1 = new StringBuilder();
        byte[] bytes = new byte[4096];
        int size = 0;
        try {
            while ((size = is.read(bytes)) > 0) {
                String str = new String(bytes, 0, size, "UTF-8");
                sb1.append(str);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return sb1.toString();
    }

    public static BigDecimal castStringToBigDecimal(String str) {
        return new BigDecimal(str.trim().replace(",", "").replace(" ", ""));
    }

    public static Character castChar(Object value, Character defaultValue) {
        if (null == value) {
            return defaultValue;
        }
        if (value instanceof Character) {
            return (Character)value;
        }
        String valueStr = CastUtil.castString(value, null);
        return Character.valueOf(StrUtil.isEmpty((CharSequence)valueStr) ? defaultValue.charValue() : valueStr.charAt(0));
    }

    public static Character castChar(Object value) {
        return CastUtil.castChar(value, null);
    }

    public static Byte castByte(Object value, Byte defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Byte) {
            return (Byte)value;
        }
        if (value instanceof Number) {
            return ((Number)value).byteValue();
        }
        String valueStr = CastUtil.castString(value, null);
        if (StrUtil.isBlank((CharSequence)valueStr)) {
            return defaultValue;
        }
        try {
            return Byte.parseByte(valueStr);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Byte castByte(Object value) {
        return CastUtil.castByte(value, null);
    }

    public static Short castShort(Object value, Short defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof Number) {
            return ((Number)value).shortValue();
        }
        String valueStr = CastUtil.castString(value, null);
        if (StrUtil.isBlank((CharSequence)valueStr)) {
            return defaultValue;
        }
        try {
            return Short.parseShort(valueStr.trim());
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Short castShort(Object value) {
        return CastUtil.castShort(value, null);
    }

    public static Number castNumber(Object value, Number defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Number) {
            return (Number)value;
        }
        String valueStr = CastUtil.castString(value, null);
        if (StrUtil.isBlank((CharSequence)valueStr)) {
            return defaultValue;
        }
        try {
            return NumberFormat.getInstance().parse(valueStr);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Number castNumber(Object value) {
        return CastUtil.castNumber(value, null);
    }

    public static Float castFloat(Object value, Float defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Float) {
            return (Float)value;
        }
        if (value instanceof Number) {
            return Float.valueOf(((Number)value).floatValue());
        }
        String valueStr = CastUtil.castString(value, null);
        if (StrUtil.isBlank((CharSequence)valueStr)) {
            return defaultValue;
        }
        try {
            return Float.valueOf(Float.parseFloat(valueStr.trim()));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Float castFloat(Object value) {
        return CastUtil.castFloat(value, null);
    }

    public static <T> Float[] castFloatToArray(boolean isIgnoreConvertError, Object ... values) throws Exception {
        if (CollectionUtil.isEmpty(values)) {
            return new Float[0];
        }
        Float[] floats = new Float[values.length];
        for (int i = 0; i < values.length; ++i) {
            Float v = CastUtil.castFloat(values[i], null);
            if (null == v && !isIgnoreConvertError) {
                throw new Exception(StrFormatter.format("Convert [{}] to Float error!", values[i]));
            }
            floats[i] = v;
        }
        return floats;
    }

    public static Boolean castBool(Object value, Boolean defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        String valueStr = CastUtil.castString(value, null);
        if (StrUtil.isBlank((CharSequence)valueStr)) {
            return defaultValue;
        }
        switch (valueStr = valueStr.trim().toLowerCase()) {
            case "true": {
                return true;
            }
            case "false": {
                return false;
            }
            case "yes": {
                return true;
            }
            case "ok": {
                return true;
            }
            case "no": {
                return false;
            }
            case "1": {
                return true;
            }
            case "0": {
                return false;
            }
        }
        return defaultValue;
    }

    public static Boolean castBool(Object value) {
        return CastUtil.castBool(value, null);
    }

    public static Boolean[] castBooleanToArray(boolean isIgnoreConvertError, Object ... values) throws Exception {
        if (CollectionUtil.isEmpty(values)) {
            return new Boolean[0];
        }
        Boolean[] bools = new Boolean[values.length];
        for (int i = 0; i < values.length; ++i) {
            Boolean v = CastUtil.castBool(values[i], null);
            if (null == v && !isIgnoreConvertError) {
                throw new Exception(StrFormatter.format("Convert [{}] to Boolean error!", values[i]));
            }
            bools[i] = v;
        }
        return bools;
    }

    public static <E extends Enum<E>> E castEnum(Class<E> clazz, Object value, E defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (clazz.isAssignableFrom(value.getClass())) {
            Enum myE = (Enum)value;
            return (E)myE;
        }
        String valueStr = CastUtil.castString(value, null);
        if (StrUtil.isBlank((CharSequence)valueStr)) {
            return defaultValue;
        }
        try {
            return Enum.valueOf(clazz, valueStr);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static <E extends Enum<E>> E castEnum(Class<E> clazz, Object value) {
        return CastUtil.castEnum(clazz, value, null);
    }

    public static BigInteger castBigInteger(Object value, BigInteger defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof BigInteger) {
            return (BigInteger)value;
        }
        if (value instanceof Long) {
            return BigInteger.valueOf((Long)value);
        }
        String valueStr = CastUtil.castString(value, null);
        if (StrUtil.isBlank((CharSequence)valueStr)) {
            return defaultValue;
        }
        try {
            return new BigInteger(valueStr);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static BigInteger castBigInteger(Object value) {
        return CastUtil.castBigInteger(value, null);
    }

    public static BigDecimal castBigDecimal(Object value, BigDecimal defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof Long) {
            return new BigDecimal((Long)value);
        }
        if (value instanceof Double) {
            return new BigDecimal((Double)value);
        }
        if (value instanceof Integer) {
            return new BigDecimal((Integer)value);
        }
        String valueStr = CastUtil.castString(value, null);
        if (StrUtil.isBlank((CharSequence)valueStr)) {
            return defaultValue;
        }
        try {
            return new BigDecimal(valueStr);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static BigDecimal castBigDecimal(Object value) {
        return CastUtil.castBigDecimal(value, null);
    }

    public static String castSBC(String input) {
        return CastUtil.castSBC(input, null);
    }

    public static String castSBC(String input, Set<Character> notConvertSet) {
        char[] c = input.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (null != notConvertSet && notConvertSet.contains(Character.valueOf(c[i]))) continue;
            if (c[i] == ' ') {
                c[i] = 12288;
                continue;
            }
            if (c[i] >= '\u007f') continue;
            c[i] = (char)(c[i] + 65248);
        }
        return new String(c);
    }

    public static String castDBC(String input) {
        return CastUtil.castDBC(input, null);
    }

    public static String castDBC(String text, Set<Character> notConvertSet) {
        char[] c = text.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (null != notConvertSet && notConvertSet.contains(Character.valueOf(c[i]))) continue;
            if (c[i] == '\u3000') {
                c[i] = 32;
                continue;
            }
            if (c[i] <= '\uff00' || c[i] >= '\uff5f') continue;
            c[i] = (char)(c[i] - 65248);
        }
        String returnString = new String(c);
        return returnString;
    }

    public static String castHex(byte[] bytes) {
        StringBuilder des = new StringBuilder();
        String tmp = null;
        for (int i = 0; i < bytes.length; ++i) {
            tmp = Integer.toHexString(bytes[i] & 0xFF);
            if (tmp.length() == 1) {
                des.append("0");
            }
            des.append(tmp);
        }
        return des.toString();
    }

    public static Date castSqlDate(Object obj, String format) throws UtilsRuntimeException {
        return (Date)CastUtil.convert(obj, "Date", format);
    }

    public static Timestamp castTimestamp(Object obj, String format) throws UtilsRuntimeException {
        return (Timestamp)CastUtil.convert(obj, "Timestamp", format);
    }

    private static NumberFormat getNf(Locale locale) {
        NumberFormat nf = null;
        nf = locale == null ? NumberFormat.getNumberInstance() : NumberFormat.getNumberInstance(locale);
        nf.setGroupingUsed(false);
        return nf;
    }
}

