/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.util;

public class CamelCaseUtil {
    private static final char SEPARATOR = '_';

    public static String toUnderlineName(String s) {
        return CamelCaseUtil.toUnderlineName(s, true);
    }

    public static String toUnderlineName(String s, boolean upper) {
        if (s == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean upperCase = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            boolean nextUpperCase = true;
            if (i < s.length() - 1) {
                nextUpperCase = Character.isUpperCase(s.charAt(i + 1));
            }
            if (i >= 0 && Character.isUpperCase(c)) {
                if (!(upperCase && nextUpperCase || i <= 0)) {
                    sb.append('_');
                }
                upperCase = true;
            } else {
                upperCase = false;
            }
            if (upper) {
                sb.append(Character.toUpperCase(c));
                continue;
            }
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString();
    }

    public static String toCamelCase(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(s.length());
        boolean upperCase = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '_') {
                upperCase = true;
                continue;
            }
            if (upperCase) {
                sb.append(Character.toUpperCase(c));
                upperCase = false;
                continue;
            }
            if (i == 0) {
                sb.append(Character.toLowerCase(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String toCapitalizeCamelCase(String s) {
        if (s == null) {
            return null;
        }
        s = CamelCaseUtil.toCamelCase(s);
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    public static void main(String[] args) {
        System.out.println(CamelCaseUtil.toUnderlineName("userName", false));
        System.out.println(CamelCaseUtil.toUnderlineName("ISOCertifiedStaff"));
        System.out.println(CamelCaseUtil.toUnderlineName("UserID"));
        System.out.println(CamelCaseUtil.toCamelCase("iso_certified_staff"));
        System.out.println(CamelCaseUtil.toCamelCase("certified_staff"));
        System.out.println(CamelCaseUtil.toCapitalizeCamelCase("user_id"));
    }
}

