/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.util;

import java.nio.charset.Charset;

public class Bytes {
    private static final String UTF8_ENCODING = "UTF-8";
    private static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    public static final int SIZEOF_INT = 4;
    public static final int SIZEOF_LONG = 8;
    public static final int SIZEOF_SHORT = 2;

    public static byte[] toBytes(String s) {
        return s.getBytes(UTF8_CHARSET);
    }

    public static byte[] toBytes(boolean b) {
        return new byte[]{b ? (byte)-1 : 0};
    }

    public static byte[] toBytes(short val) {
        byte[] b = new byte[2];
        b[1] = (byte)val;
        val = (short)(val >> 8);
        b[0] = (byte)val;
        return b;
    }

    public static byte[] toBytes(int val) {
        byte[] b = new byte[4];
        for (int i = 3; i > 0; --i) {
            b[i] = (byte)val;
            val >>>= 8;
        }
        b[0] = (byte)val;
        return b;
    }

    public static byte[] toBytes(long val) {
        byte[] b = new byte[8];
        for (int i = 7; i > 0; --i) {
            b[i] = (byte)val;
            val >>>= 8;
        }
        b[0] = (byte)val;
        return b;
    }

    public static byte[] toBytes(float f) {
        return Bytes.toBytes(Float.floatToRawIntBits(f));
    }

    public static byte[] toBytes(double d) {
        return Bytes.toBytes(Double.doubleToRawLongBits(d));
    }

    public static String toString(byte[] b) {
        if (b == null) {
            return null;
        }
        return new String(b, 0, b.length, UTF8_CHARSET);
    }

    public static boolean toBoolean(byte[] b) {
        if (b.length != 1) {
            throw new IllegalArgumentException("Array has wrong size: " + b.length);
        }
        return b[0] != 0;
    }

    public static short toShort(byte[] bytes) {
        short n = 0;
        n = (short)(n ^ bytes[0] & 0xFF);
        n = (short)(n << 8);
        n = (short)(n ^ bytes[1] & 0xFF);
        return n;
    }

    public static int toInt(byte[] bytes) {
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            n <<= 8;
            n ^= bytes[i] & 0xFF;
        }
        return n;
    }

    public static long toLong(byte[] bytes) {
        long l = 0L;
        int size = bytes.length == 4 ? 4 : 8;
        for (int i = 0; i < size; ++i) {
            l <<= 8;
            l ^= (long)(bytes[i] & 0xFF);
        }
        return l;
    }

    public static float toFloat(byte[] bytes) {
        return Float.intBitsToFloat(Bytes.toInt(bytes));
    }

    public static double toDouble(byte[] bytes) {
        return Double.longBitsToDouble(Bytes.toLong(bytes));
    }
}

