/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigDecimalUtil {
    private static final Logger logger = LoggerFactory.getLogger(BigDecimalUtil.class);
    private static final int DEF_DIV_SCALE = 10;

    private BigDecimalUtil() {
    }

    public static boolean lessThan(BigDecimal num1, BigDecimal num2) {
        return num1.compareTo(num2) == -1;
    }

    public static boolean lessEqual(BigDecimal num1, BigDecimal num2) {
        return num1.compareTo(num2) == -1 || num1.compareTo(num2) == 0;
    }

    public static boolean greaterThan(BigDecimal num1, BigDecimal num2) {
        return num1.compareTo(num2) == 1;
    }

    public static boolean greaterEqual(BigDecimal num1, BigDecimal num2) {
        return num1.compareTo(num2) == 1 || num1.compareTo(num2) == 0;
    }

    public static boolean equal(BigDecimal num1, BigDecimal num2) {
        return num1.compareTo(num2) == 0;
    }

    public static BigDecimal toBigDecimal(Object obj) {
        if (obj == null) {
            throw new NullPointerException("Parameter is null");
        }
        if (obj instanceof BigDecimal) {
            return (BigDecimal)obj;
        }
        if (obj instanceof BigInteger) {
            return new BigDecimal((BigInteger)obj);
        }
        if (obj instanceof Float) {
            return new BigDecimal(((Float)obj).floatValue());
        }
        if (obj instanceof Double) {
            return new BigDecimal((Double)obj);
        }
        if (obj instanceof Byte) {
            return new BigDecimal(((Byte)obj).byteValue());
        }
        if (obj instanceof Short) {
            return new BigDecimal(((Short)obj).shortValue());
        }
        if (obj instanceof Integer) {
            return new BigDecimal((Integer)obj);
        }
        if (obj instanceof Long) {
            return new BigDecimal((Long)obj);
        }
        if (obj instanceof String) {
            return new BigDecimal((String)obj);
        }
        throw new RuntimeException("Unknown type of parameter");
    }

    public static BigDecimal add(Object o1, Object o2) {
        return BigDecimalUtil.toBigDecimal(o1).add(BigDecimalUtil.toBigDecimal(o2));
    }

    public static BigDecimal addRounding(Object o1, Object o2, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("Passed an invalid or incorrect argument");
        }
        BigDecimal db = BigDecimalUtil.toBigDecimal(o1).add(BigDecimalUtil.toBigDecimal(o2));
        return db.setScale(scale, 4);
    }

    public static BigDecimal addTrunc(Object o1, Object o2, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("Passed an invalid or incorrect argument");
        }
        BigDecimal db = BigDecimalUtil.toBigDecimal(o1).add(BigDecimalUtil.toBigDecimal(o2));
        return db.setScale(scale, 1);
    }

    public static BigDecimal sub(Object o1, Object o2) {
        return BigDecimalUtil.toBigDecimal(o1).subtract(BigDecimalUtil.toBigDecimal(o2));
    }

    public static BigDecimal subRounding(Object o1, Object o2, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("Passed an invalid or incorrect argument");
        }
        BigDecimal db = BigDecimalUtil.toBigDecimal(o1).subtract(BigDecimalUtil.toBigDecimal(o2));
        return db.setScale(scale, 4);
    }

    public static BigDecimal subTrunc(Object o1, Object o2, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("Passed an invalid or incorrect argument");
        }
        BigDecimal db = BigDecimalUtil.toBigDecimal(o1).subtract(BigDecimalUtil.toBigDecimal(o2));
        return db.setScale(scale, 1);
    }

    public static BigDecimal mul(Object o1, Object o2) {
        return BigDecimalUtil.toBigDecimal(o1).multiply(BigDecimalUtil.toBigDecimal(o2));
    }

    public static BigDecimal mulRounding(Object o1, Object o2, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("Passed an invalid or incorrect argument");
        }
        BigDecimal db = BigDecimalUtil.toBigDecimal(o1).multiply(BigDecimalUtil.toBigDecimal(o2));
        return db.setScale(scale, 4);
    }

    public static BigDecimal mulTrunc(Object o1, Object o2, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("Passed an invalid or incorrect argument");
        }
        BigDecimal db = BigDecimalUtil.toBigDecimal(o1).multiply(BigDecimalUtil.toBigDecimal(o2));
        return db.setScale(scale, 1);
    }

    public static BigDecimal divRounding(Object o1, Object o2, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("Passed an invalid or incorrect argument");
        }
        return BigDecimalUtil.toBigDecimal(o1).divide(BigDecimalUtil.toBigDecimal(o2), scale, 4);
    }

    public static BigDecimal divTrunc(Object o1, Object o2, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("Passed an invalid or incorrect argument");
        }
        return BigDecimalUtil.toBigDecimal(o1).divide(BigDecimalUtil.toBigDecimal(o2), scale, 1);
    }

    public static BigDecimal toRounding(Object obj, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("Passed an invalid or incorrect argument");
        }
        return BigDecimalUtil.toBigDecimal(obj).setScale(scale, 4);
    }

    public static BigDecimal toTrunc(Object obj, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("Passed an invalid or incorrect argument");
        }
        return BigDecimalUtil.toBigDecimal(obj).setScale(scale, 1);
    }

    public static int compareTo(BigDecimal v1, BigDecimal v2) {
        if (v1 == null) {
            return -1;
        }
        if (v2 == null) {
            return 1;
        }
        return v1.compareTo(v2);
    }

    public static double score(double child, double mother) {
        return Math.floor(child * 100.0 / mother);
    }

    public static String fmtMoney(Long num) {
        if (num == null || 0L == num) {
            return "0.00";
        }
        return new BigDecimal(num).divide(new BigDecimal(100)).setScale(2, 4).toString();
    }

    public static Double fmtDouble(Double num) {
        if (num == null || 0.0 == num) {
            logger.info("num is null == {}", (Object)num);
            return 0.0;
        }
        try {
            return new BigDecimal(num).setScale(2, 4).doubleValue();
        }
        catch (Exception e) {
            logger.info("fmt double error : num = {} , error = {}", (Object)num, (Object)e.getMessage());
            return 0.0;
        }
    }

    public static Double fmtDouble(BigDecimal num) {
        if (num == null || 0.0 == num.doubleValue()) {
            logger.info("num is null == {}", (Object)num);
            return 0.0;
        }
        try {
            return num.setScale(2, 4).doubleValue();
        }
        catch (Exception e) {
            logger.info("fmt double error : num = {} , error = {}", (Object)num, (Object)e.getMessage());
            return 0.0;
        }
    }
}

