/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.util;

import cn.dolphin.core.exception.ReflexRuntimeException;
import cn.dolphin.core.exception.UtilsRuntimeException;
import cn.dolphin.core.util.ClassUtil;
import cn.dolphin.core.util.NameUtil;
import cn.dolphin.core.util.StrUtil;
import com.google.common.collect.Maps;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.cglib.beans.BeanCopier;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.beanutils.converters.DateConverter;
import org.apache.commons.beanutils.converters.LongConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.WebApplicationContext;

public final class BeanUtil
extends org.springframework.beans.BeanUtils {
    private static final String CLASS = "class";
    private static Logger logger = LoggerFactory.getLogger(BeanUtil.class);
    public static ConvertUtilsBean convertUtilsBean = new ConvertUtilsBean();
    private static BeanUtilsBean beanUtilsBean = new BeanUtilsBean(convertUtilsBean, new PropertyUtilsBean());

    public static <T> T newInstance(Class<?> clazz) {
        return (T)BeanUtil.instantiateClass(clazz);
    }

    public static <T> T newInstance(String clazzStr) {
        try {
            Class clazz = ClassUtil.forName((String)clazzStr, null);
            return BeanUtil.newInstance(clazz);
        }
        catch (ClassNotFoundException e) {
            throw new UtilsRuntimeException(e);
        }
    }

    public static void copyProperties2(Object source, Object target) {
        BeanCopier copier = BeanCopier.create(source.getClass(), target.getClass(), (boolean)false);
        copier.copy(source, target, null);
    }

    public static boolean isEmpty(Object o) {
        if (o == null) {
            return true;
        }
        return o instanceof String ? ((String)o).trim().length() == 0 : (o instanceof Collection ? ((Collection)o).isEmpty() : (o.getClass().isArray() ? ((Object[])o).length == 0 : o instanceof Map && ((Map)o).isEmpty()));
    }

    public static boolean isZeroEmpty(Object o) {
        Short sEmpty;
        Double lEmpty;
        if (o == null) {
            return true;
        }
        return o instanceof String ? ((String)o).trim().length() == 0 : (o instanceof Collection ? ((Collection)o).isEmpty() : (o.getClass().isArray() ? ((Object[])o).length == 0 : (o instanceof Map ? ((Map)o).isEmpty() : (o instanceof Double ? o == (lEmpty = Double.valueOf(0.0)) : (o instanceof Float ? o == (lEmpty = Float.valueOf(0.0f)) : (o instanceof Long ? o == (lEmpty = Long.valueOf(0L)) : (o instanceof Short ? o == (sEmpty = Short.valueOf((short)0)) : o instanceof Integer && o == (sEmpty = Integer.valueOf(0)))))))));
    }

    public static boolean isNotEmpty(Object o) {
        return !BeanUtil.isEmpty(o);
    }

    public static boolean isNotEmpty(Long o) {
        return !BeanUtil.isEmpty(o);
    }

    public static boolean isNotIncZeroEmpty(Object o) {
        return !BeanUtil.isZeroEmpty(o);
    }

    public static boolean isNumber(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof Number) {
            return true;
        }
        if (o instanceof String) {
            try {
                Double.parseDouble((String)o);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }

    public static Object populateEntity(Map map, Object entity) throws IllegalAccessException, InvocationTargetException {
        beanUtilsBean.populate(entity, map);
        return entity;
    }

    public static boolean validClass(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean isInherit(Class cls, Class parentClass) {
        return parentClass.isAssignableFrom(cls);
    }

    public static Object cloneBean(Object bean) {
        try {
            return beanUtilsBean.cloneBean(bean);
        }
        catch (Exception e) {
            BeanUtil.handleReflectionException(e);
            return null;
        }
    }

    public static Object getBean(Class cls) {
        WebApplicationContext ctx = ContextLoader.getCurrentWebApplicationContext();
        return ctx.getBean(cls);
    }

    public static List<String> scanPackages(String basePackages) throws IllegalArgumentException {
        PathMatchingResourcePatternResolver rl = new PathMatchingResourcePatternResolver();
        CachingMetadataReaderFactory metadataReaderFactory = new CachingMetadataReaderFactory((ResourceLoader)rl);
        ArrayList<String> result = new ArrayList<String>();
        String[] arrayPackages = basePackages.split(",");
        try {
            for (int j = 0; j < arrayPackages.length; ++j) {
                String packageToScan = arrayPackages[j];
                String packagePart = packageToScan.replace('.', '/');
                String classPattern = "classpath*:/" + packagePart + "/**/*.class";
                Resource[] resources = rl.getResources(classPattern);
                for (int i = 0; i < resources.length; ++i) {
                    Resource resource = resources[i];
                    MetadataReader metadataReader = metadataReaderFactory.getMetadataReader(resource);
                    String className = metadataReader.getClassMetadata().getClassName();
                    result.add(className);
                }
            }
        }
        catch (Exception e) {
            new IllegalArgumentException("scan pakcage class error,pakcages:" + basePackages);
        }
        return result;
    }

    public static void copyNotNullProperties(Object dest, Object orig) {
        if (dest == null) {
            logger.error("No destination bean specified");
            return;
        }
        if (orig == null) {
            logger.error("No origin bean specified");
            return;
        }
        try {
            if (orig instanceof DynaBean) {
                DynaProperty[] origDescriptors = ((DynaBean)orig).getDynaClass().getDynaProperties();
                for (int i = 0; i < origDescriptors.length; ++i) {
                    String name = origDescriptors[i].getName();
                    if (!beanUtilsBean.getPropertyUtils().isReadable(orig, name) || !beanUtilsBean.getPropertyUtils().isWriteable(dest, name)) continue;
                    Object value = ((DynaBean)orig).get(name);
                    beanUtilsBean.copyProperty(dest, name, value);
                }
            } else if (orig instanceof Map) {
                for (Map.Entry entry : ((Map)orig).entrySet()) {
                    String name = (String)entry.getKey();
                    if (!beanUtilsBean.getPropertyUtils().isWriteable(dest, name)) continue;
                    beanUtilsBean.copyProperty(dest, name, entry.getValue());
                }
            } else {
                PropertyDescriptor[] origDescriptors = beanUtilsBean.getPropertyUtils().getPropertyDescriptors(orig);
                for (int i = 0; i < origDescriptors.length; ++i) {
                    String name = origDescriptors[i].getName();
                    if (CLASS.equals(name) || !beanUtilsBean.getPropertyUtils().isReadable(orig, name) || !beanUtilsBean.getPropertyUtils().isWriteable(dest, name)) continue;
                    try {
                        Object value = beanUtilsBean.getPropertyUtils().getSimpleProperty(orig, name);
                        if (value == null) continue;
                        beanUtilsBean.copyProperty(dest, name, value);
                        continue;
                    }
                    catch (NoSuchMethodException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (Exception ex) {
            BeanUtil.handleReflectionException(ex);
        }
    }

    public static <T> T copyProperties(Class<T> destClass, Object orig) {
        T target = null;
        try {
            target = destClass.newInstance();
            BeanUtil.copyProperties(target, orig);
            return target;
        }
        catch (Exception e) {
            BeanUtil.handleReflectionException(e);
            return null;
        }
    }

    public static void copyProperties(Object dest, Object orig) {
        try {
            beanUtilsBean.copyProperties(dest, orig);
        }
        catch (Exception e) {
            BeanUtil.handleReflectionException(e);
        }
    }

    public static void copyProperty(Object bean, String name, Object value) {
        try {
            beanUtilsBean.copyProperty(bean, name, value);
        }
        catch (Exception e) {
            BeanUtil.handleReflectionException(e);
        }
    }

    public static Map describe(Object bean) {
        try {
            return beanUtilsBean.describe(bean);
        }
        catch (Exception e) {
            BeanUtil.handleReflectionException(e);
            return null;
        }
    }

    public static String[] getArrayProperty(Object bean, String name) {
        try {
            return beanUtilsBean.getArrayProperty(bean, name);
        }
        catch (Exception e) {
            BeanUtil.handleReflectionException(e);
            return null;
        }
    }

    public static ConvertUtilsBean getConvertUtils() {
        return beanUtilsBean.getConvertUtils();
    }

    public static String getIndexedProperty(Object bean, String name, int index) {
        try {
            return beanUtilsBean.getIndexedProperty(bean, name, index);
        }
        catch (Exception e) {
            BeanUtil.handleReflectionException(e);
            return null;
        }
    }

    public static String getIndexedProperty(Object bean, String name) {
        try {
            return beanUtilsBean.getIndexedProperty(bean, name);
        }
        catch (Exception e) {
            BeanUtil.handleReflectionException(e);
            return null;
        }
    }

    public static String getMappedProperty(Object bean, String name, String key) {
        try {
            return beanUtilsBean.getMappedProperty(bean, name, key);
        }
        catch (Exception e) {
            BeanUtil.handleReflectionException(e);
            return null;
        }
    }

    public static String getMappedProperty(Object bean, String name) {
        try {
            return beanUtilsBean.getMappedProperty(bean, name);
        }
        catch (Exception e) {
            BeanUtil.handleReflectionException(e);
            return null;
        }
    }

    public static String getNestedProperty(Object bean, String name) {
        try {
            return beanUtilsBean.getNestedProperty(bean, name);
        }
        catch (Exception e) {
            BeanUtil.handleReflectionException(e);
            return null;
        }
    }

    public static String getProperty(Object bean, String name) {
        try {
            return beanUtilsBean.getProperty(bean, name);
        }
        catch (Exception e) {
            BeanUtil.handleReflectionException(e);
            return null;
        }
    }

    public static PropertyUtilsBean getPropertyUtils() {
        try {
            return beanUtilsBean.getPropertyUtils();
        }
        catch (Exception e) {
            BeanUtil.handleReflectionException(e);
            return null;
        }
    }

    public static String getSimpleProperty(Object bean, String name) {
        try {
            return beanUtilsBean.getSimpleProperty(bean, name);
        }
        catch (Exception e) {
            BeanUtil.handleReflectionException(e);
            return null;
        }
    }

    public static void populate(Object bean, Map properties) {
        try {
            beanUtilsBean.populate(bean, properties);
        }
        catch (Exception e) {
            BeanUtil.handleReflectionException(e);
        }
    }

    public static void setProperty(Object bean, String name, Object value) {
        try {
            beanUtilsBean.setProperty(bean, name, value);
        }
        catch (Exception e) {
            BeanUtil.handleReflectionException(e);
        }
    }

    private static void handleReflectionException(Exception e) {
        ReflectionUtils.handleReflectionException((Exception)e);
    }

    public static Object convertByActType(String typeName, String value) {
        Object o = null;
        o = typeName.equals("int") ? Integer.valueOf(Integer.parseInt(value)) : (typeName.equals("short") ? Short.valueOf(Short.parseShort(value)) : (typeName.equals("long") ? Long.valueOf(Long.parseLong(value)) : (typeName.equals("float") ? Float.valueOf(Float.parseFloat(value)) : (typeName.equals("double") ? Double.valueOf(Double.parseDouble(value)) : (typeName.equals("boolean") ? Boolean.valueOf(Boolean.parseBoolean(value)) : (typeName.equals("java.lang.String") ? value : value))))));
        return o;
    }

    public static final void setField(Object obj, String field, Object value) {
        try {
            BeanUtils.setProperty((Object)obj, (String)field, (Object)value);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new ReflexRuntimeException(e.getMessage(), e);
        }
    }

    public static final String getField(Object obj, String field) {
        try {
            return BeanUtils.getProperty((Object)obj, (String)field);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new ReflexRuntimeException(e.getMessage(), e);
        }
    }

    public static final Object mapToObj(Map<String, Object> fields, Class<?> beanClass) {
        try {
            Object obj = beanClass.newInstance();
            BeanUtils.populate(obj, fields);
            return obj;
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new ReflexRuntimeException(e.getMessage(), e);
        }
    }

    public static final Map<String, Object> objToMap(Object obj) {
        try {
            Map map = PropertyUtils.describe((Object)obj);
            map.remove(CLASS);
            return map;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new ReflexRuntimeException(e.getMessage(), e);
        }
    }

    public static final Map<String, String> objToStrMap(Object obj) {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            Map beanLog = new HashMap();
            beanLog = BeanUtils.describe((Object)obj);
            for (Map.Entry entry : beanLog.entrySet()) {
                map.put((String)entry.getKey(), (String)entry.getValue() + "");
            }
            map.remove(CLASS);
            return map;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new ReflexRuntimeException(e.getMessage(), e);
        }
    }

    public static int getFnum(Object ent) {
        Collection values = null;
        try {
            Map map = PropertyUtils.describe((Object)ent);
            map.remove(CLASS);
            values = map.values();
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new ReflexRuntimeException(e.getMessage(), e);
        }
        int i = 0;
        for (Object obj : values) {
            if (obj == null || obj instanceof String && ((String)obj).length() == 0) continue;
            ++i;
        }
        return i;
    }

    public static <T> List<T> wrapToList(Object bean) {
        if (List.class.isInstance(bean)) {
            return (List)bean;
        }
        ArrayList<Object> target = new ArrayList<Object>(1);
        if (null != bean) {
            target.add(bean);
        }
        return target;
    }

    public static <K, T> Map<K, T> wrapToMap(Object bean) {
        if (Map.class.isInstance(bean)) {
            return (Map)bean;
        }
        ConcurrentHashMap target = new ConcurrentHashMap();
        return target;
    }

    public static int toInt(Object bean, int defaultValue) {
        try {
            return null != bean ? Integer.parseInt(bean.toString()) : defaultValue;
        }
        catch (Exception e) {
            e.printStackTrace();
            return defaultValue;
        }
    }

    public static int toInt(String bean, int defaultValue) {
        try {
            return null != bean ? Integer.parseInt(bean.toString()) : defaultValue;
        }
        catch (Exception e) {
            e.printStackTrace();
            return defaultValue;
        }
    }

    public static int toInt(Integer bean, int defaultValue) {
        return null != bean ? bean : defaultValue;
    }

    public static <T> T getKeyByValue(Object value, Map map) {
        Object v = null;
        for (Object key : map.keySet()) {
            v = map.get(key);
            if (!(value == null ? v == null : value.equals(v))) continue;
            return (T)key;
        }
        return null;
    }

    public static String toNullableString(Object obj) {
        return null != obj ? obj.toString() : null;
    }

    public static String toNotNullString(Object obj) {
        return null != obj ? obj.toString() : "";
    }

    public static boolean isNullOrEmpty(String str) {
        return null == str || "".equals(str);
    }

    public static boolean isNotNullAndEmpty(String str) {
        return null != str && !"".equals(str);
    }

    public static List<Map<String, Object>> sort(List<Map<String, Object>> list, final String[] sortKeys, final boolean[] ascOrders) {
        Comparator<Map<String, Object>> cmp = new Comparator<Map<String, Object>>(){

            @Override
            public int compare(Map m1, Map m2) {
                for (int i = 0; i < sortKeys.length; ++i) {
                    Object o1 = m1.get(sortKeys[i]);
                    Object o2 = m2.get(sortKeys[i]);
                    if (null == o1 || null == o2) {
                        throw new IllegalStateException("\u88ab\u6392\u5e8f\u7684map\u7684key\u7684\u503c\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    Comparable c = (Comparable)o1;
                    int r = c.compareTo(o2);
                    if (0 == r) continue;
                    return ascOrders[i] ? r : -r;
                }
                return 0;
            }
        };
        Collections.sort(list, cmp);
        return list;
    }

    public static List<Map<String, Object>> sort(List<Map<String, Object>> list, final String sortKey) {
        Comparator<Map> cmp = new Comparator<Map>(){

            @Override
            public int compare(Map m1, Map m2) {
                Object o1 = m1.get(sortKey);
                Object o2 = m2.get(sortKey);
                if (null == o1 || null == o2) {
                    throw new IllegalStateException("\u88ab\u6392\u5e8f\u7684map\u7684key\u7684\u503c\u4e0d\u80fd\u4e3a\u7a7a");
                }
                Comparable c = (Comparable)o1;
                return c.compareTo(o2);
            }
        };
        Collections.sort(list, cmp);
        return list;
    }

    private BeanUtil() {
    }

    public static Object createBean(String className) throws Exception {
        if (StrUtil.isBlank((CharSequence)className)) {
            String msg = "Cannot find the class :" + className;
            throw new Exception(msg);
        }
        try {
            return Class.forName(className).newInstance();
        }
        catch (Throwable ex) {
            String msg = "Cannot create this class :" + className;
            throw new Exception(msg, ex);
        }
    }

    public static Map<String, Object> mapKeyCovertion(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        HashMap nMap = Maps.newHashMap();
        map.forEach((k, v) -> nMap.put(NameUtil.getCamelName(k), v));
        map = null;
        return nMap;
    }

    static {
        convertUtilsBean.register((Converter)new DateConverter(), Date.class);
        convertUtilsBean.register((Converter)new LongConverter(null), Long.class);
    }
}

