/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.util;

import cn.dolphin.core.util.CommonUtil;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;

public class ArrayUtil
extends ArrayUtils {
    public static boolean isBlank(Object[] o) {
        return o == null || o.length <= 0;
    }

    public static boolean isNotBlank(Object[] o) {
        return !ArrayUtil.isBlank(o);
    }

    public static boolean isArray(Object obj) {
        if (null == obj) {
            return false;
        }
        return obj.getClass().isArray();
    }

    public static <T> T[] distinct(T[] sources) {
        if (null == sources) {
            return sources;
        }
        ArrayList<T> list = new ArrayList<T>();
        for (T obj : sources) {
            if (list.contains(obj)) continue;
            list.add(obj);
        }
        return list.toArray();
    }

    public static <T> T[] join(T[] sources, T target) {
        if (null == sources) {
            return new Object[]{target};
        }
        T[] tmp = Arrays.copyOf(sources, sources.length + 1);
        tmp[sources.length] = target;
        return tmp;
    }

    public static <T> T[] remove(T[] sources, T target) {
        ArrayList<T> list = new ArrayList<T>();
        if (null == sources) {
            return list.toArray();
        }
        for (T obj : sources) {
            list.add(obj);
            list.remove(target);
        }
        return list.toArray();
    }

    public static <T> boolean cross(T[] arg0, T[] arg1) {
        if (arg0 == null && arg1 == null) {
            return true;
        }
        List<Object> arg0List = new ArrayList();
        if (null != arg0) {
            arg0List = Arrays.asList(arg0);
        }
        List<Object> arg1List = new ArrayList();
        if (null != arg1) {
            arg1List = Arrays.asList(arg1);
        }
        if (arg0List.size() > arg1List.size()) {
            for (Object obj : arg0List) {
                if (!arg1List.contains(obj)) continue;
                return true;
            }
        } else {
            for (Object obj : arg1List) {
                if (!arg0List.contains(obj)) continue;
                return true;
            }
        }
        return false;
    }

    public static <T> T[] concat(T[] source, T[] ... targets) {
        int offset;
        if (CommonUtil.isEmpty(targets)) {
            return source;
        }
        int index = offset = null == source ? 0 : source.length;
        for (T[] objs : targets) {
            index += null == objs ? 0 : objs.length;
        }
        Object[] result = null == source ? new Object[index] : Arrays.copyOf(source, index);
        for (T[] objs : targets) {
            if (null == objs) continue;
            System.arraycopy(objs, 0, result, offset, objs.length);
            offset += objs.length;
        }
        return result;
    }

    public static boolean isInArray(String str, String[] array) {
        for (String s : array) {
            if (!s.equalsIgnoreCase(str)) continue;
            return true;
        }
        return false;
    }

    public static <T> T[] newArray(Class<?> componentType, int newSize) {
        return (Object[])Array.newInstance(componentType, newSize);
    }

    public static <T> T[] toArray(Iterator<T> iterator, Class<T> componentType) {
        return ArrayUtil.toArray(ArrayUtil.newArrayList(iterator), componentType);
    }

    private static <T> ArrayList<T> newArrayList(Iterator<T> iter) {
        ArrayList<T> list = new ArrayList<T>();
        if (null == iter) {
            return list;
        }
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        return list;
    }

    public static int length(Object array) throws IllegalArgumentException {
        if (null == array) {
            return 0;
        }
        return Array.getLength(array);
    }

    public static String toString(Object obj) {
        if (null == obj) {
            return null;
        }
        if (ArrayUtil.isArray(obj)) {
            try {
                return Arrays.deepToString((Object[])obj);
            }
            catch (Exception e) {
                String className;
                switch (className = obj.getClass().getComponentType().getName()) {
                    case "long": {
                        return Arrays.toString((long[])obj);
                    }
                    case "int": {
                        return Arrays.toString((int[])obj);
                    }
                    case "short": {
                        return Arrays.toString((short[])obj);
                    }
                    case "char": {
                        return Arrays.toString((char[])obj);
                    }
                    case "byte": {
                        return Arrays.toString((byte[])obj);
                    }
                    case "boolean": {
                        return Arrays.toString((boolean[])obj);
                    }
                    case "float": {
                        return Arrays.toString((float[])obj);
                    }
                    case "double": {
                        return Arrays.toString((double[])obj);
                    }
                }
                throw new RuntimeException(e);
            }
        }
        return obj.toString();
    }

    private static <E> Collection<E> toCollection(Iterable<E> iterable) {
        return iterable instanceof Collection ? (ArrayList<E>)iterable : ArrayUtil.newArrayList(iterable.iterator());
    }

    public static <T> T[] toArray(Iterable<T> iterable, Class<T> componentType) {
        return ArrayUtil.toArray(ArrayUtil.toCollection(iterable), componentType);
    }

    public static <T> T[] toArray(Collection<T> collection, Class<T> componentType) {
        T[] array = ArrayUtil.newArray(componentType, collection.size());
        return collection.toArray(array);
    }

    public static String[] toStringArray(int[] array) {
        String[] newArray = new String[array.length];
        if (ArrayUtil.isEmpty((int[])array)) {
            return newArray;
        }
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = String.valueOf(array[i]);
        }
        return newArray;
    }

    public static String[] toStringArray(double[] array) {
        String[] newArray = new String[array.length];
        if (ArrayUtil.isEmpty((double[])array)) {
            return newArray;
        }
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = String.valueOf(array[i]);
        }
        return newArray;
    }

    public static String[] toStringArray(float[] array) {
        String[] newArray = new String[array.length];
        if (ArrayUtil.isEmpty((float[])array)) {
            return newArray;
        }
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = String.valueOf(array[i]);
        }
        return newArray;
    }

    public static String[] toStringArray(short[] array) {
        String[] newArray = new String[array.length];
        if (ArrayUtil.isEmpty((short[])array)) {
            return newArray;
        }
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = String.valueOf(array[i]);
        }
        return newArray;
    }

    public static String[] toStringArray(byte[] array) {
        String[] newArray = new String[array.length];
        if (ArrayUtil.isEmpty((byte[])array)) {
            return newArray;
        }
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = String.valueOf(array[i]);
        }
        return newArray;
    }

    public static String[] toStringArray(long[] array) {
        String[] newArray = new String[array.length];
        if (ArrayUtil.isEmpty((long[])array)) {
            return newArray;
        }
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = String.valueOf(array[i]);
        }
        return newArray;
    }

    public static String[] toStringArray(boolean[] array) {
        String[] newArray = new String[array.length];
        if (ArrayUtil.isEmpty((boolean[])array)) {
            return newArray;
        }
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = String.valueOf(array[i]);
        }
        return newArray;
    }

    public static String[] toStringArray(char[] array) {
        String[] newArray = new String[array.length];
        if (ArrayUtil.isEmpty((char[])array)) {
            return newArray;
        }
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = String.valueOf(array[i]);
        }
        return newArray;
    }

    public static String[] toStringArray(Object[] array) {
        String[] newArray = new String[array.length];
        if (ArrayUtil.isEmpty((Object[])array)) {
            return newArray;
        }
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = String.valueOf(array[i]);
        }
        return newArray;
    }

    public static String[] toStringArray(Collection<String> collection) {
        if (collection == null) {
            return null;
        }
        return collection.toArray(new String[collection.size()]);
    }

    public static int[] toIntArray(String[] array) {
        int[] newArray = new int[array.length];
        if (ArrayUtil.isEmpty((Object[])array)) {
            return newArray;
        }
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = Integer.valueOf(array[i]);
        }
        return newArray;
    }

    public static int[] toIntArray(double[] array) {
        int[] newArray = new int[array.length];
        if (ArrayUtil.isEmpty((double[])array)) {
            return newArray;
        }
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = (int)array[i];
        }
        return newArray;
    }

    public static int[] toIntArray(float[] array) {
        int[] newArray = new int[array.length];
        if (ArrayUtil.isEmpty((float[])array)) {
            return newArray;
        }
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = (int)array[i];
        }
        return newArray;
    }

    public static int[] toIntArray(short[] array) {
        int[] newArray = new int[array.length];
        if (ArrayUtil.isEmpty((short[])array)) {
            return newArray;
        }
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = array[i];
        }
        return newArray;
    }

    public static int[] toIntArray(byte[] array) {
        int[] newArray = new int[array.length];
        if (ArrayUtil.isEmpty((byte[])array)) {
            return newArray;
        }
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = array[i];
        }
        return newArray;
    }

    public static int[] toIntArray(long[] array) {
        int[] newArray = new int[array.length];
        if (ArrayUtil.isEmpty((long[])array)) {
            return newArray;
        }
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = (int)array[i];
        }
        return newArray;
    }

    public static int[] toIntArray(char[] array) {
        int[] newArray = new int[array.length];
        if (ArrayUtil.isEmpty((char[])array)) {
            return newArray;
        }
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = array[i];
        }
        return newArray;
    }

    public static int[] toIntArray(boolean[] array) {
        int[] newArray = new int[array.length];
        if (ArrayUtil.isEmpty((boolean[])array)) {
            return newArray;
        }
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = !array[i] ? 0 : 1;
        }
        return newArray;
    }

    public static int[] toIntArray(Object[] array) {
        int[] newArray = new int[array.length];
        if (ArrayUtil.isEmpty((Object[])array)) {
            return newArray;
        }
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = (Integer)array[i];
        }
        return newArray;
    }

    public static double[] toDoubleArray(String[] array) {
        double[] newArray = new double[array.length];
        if (ArrayUtil.isEmpty((Object[])array)) {
            return newArray;
        }
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = Double.valueOf(array[i]);
        }
        return newArray;
    }

    public static double[] toDoubleArray(int[] array) {
        double[] newArray = new double[array.length];
        if (ArrayUtil.isEmpty((int[])array)) {
            return newArray;
        }
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = array[i];
        }
        return newArray;
    }

    public static double[] toDoubleArray(float[] array) {
        double[] newArray = new double[array.length];
        if (ArrayUtil.isEmpty((float[])array)) {
            return newArray;
        }
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = array[i];
        }
        return newArray;
    }

    public static double[] toDoubleArray(long[] array) {
        double[] newArray = new double[array.length];
        if (ArrayUtil.isEmpty((long[])array)) {
            return newArray;
        }
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = array[i];
        }
        return newArray;
    }

    public static double[] toDoubleArray(short[] array) {
        double[] newArray = new double[array.length];
        if (ArrayUtil.isEmpty((short[])array)) {
            return newArray;
        }
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = array[i];
        }
        return newArray;
    }

    public static double[] toDoubleArray(byte[] array) {
        double[] newArray = new double[array.length];
        if (ArrayUtil.isEmpty((byte[])array)) {
            return newArray;
        }
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = array[i];
        }
        return newArray;
    }

    public static double[] toDoubleArray(char[] array) {
        double[] newArray = new double[array.length];
        if (ArrayUtil.isEmpty((char[])array)) {
            return newArray;
        }
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = array[i];
        }
        return newArray;
    }

    public static double[] toDoubleArray(Object[] array) {
        double[] newArray = new double[array.length];
        if (ArrayUtil.isEmpty((Object[])array)) {
            return newArray;
        }
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = (Double)array[i];
        }
        return newArray;
    }

    public static float[] toFloatArray(String[] array) {
        float[] newArray = new float[array.length];
        if (ArrayUtil.isEmpty((Object[])array)) {
            return newArray;
        }
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = Float.valueOf(array[i]).floatValue();
        }
        return newArray;
    }

    public static float[] toFloatArray(int[] array) {
        float[] newArray = new float[array.length];
        if (ArrayUtil.isEmpty((int[])array)) {
            return newArray;
        }
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = array[i];
        }
        return newArray;
    }

    public static float[] toFloatArray(double[] array) {
        float[] newArray = new float[array.length];
        if (ArrayUtil.isEmpty((double[])array)) {
            return newArray;
        }
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = (float)array[i];
        }
        return newArray;
    }

    public static float[] toFloatArray(short[] array) {
        float[] newArray = new float[array.length];
        if (ArrayUtil.isEmpty((short[])array)) {
            return newArray;
        }
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = array[i];
        }
        return newArray;
    }

    public static float[] toFloatArray(byte[] array) {
        float[] newArray = new float[array.length];
        if (ArrayUtil.isEmpty((byte[])array)) {
            return newArray;
        }
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = array[i];
        }
        return newArray;
    }

    public static float[] toFloatArray(long[] array) {
        float[] newArray = new float[array.length];
        if (ArrayUtil.isEmpty((long[])array)) {
            return newArray;
        }
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = array[i];
        }
        return newArray;
    }

    public static float[] toFloatArray(char[] array) {
        float[] newArray = new float[array.length];
        if (ArrayUtil.isEmpty((char[])array)) {
            return newArray;
        }
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = array[i];
        }
        return newArray;
    }

    public static float[] toFloatArray(Object[] array) {
        float[] newArray = new float[array.length];
        if (ArrayUtil.isEmpty((Object[])array)) {
            return newArray;
        }
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = ((Float)array[i]).floatValue();
        }
        return newArray;
    }

    public static long[] toLongArray(String[] array) {
        long[] newArray = new long[array.length];
        if (ArrayUtil.isEmpty((Object[])array)) {
            return newArray;
        }
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = Long.valueOf(array[i]);
        }
        return newArray;
    }

    public static long[] toLongArray(int[] array) {
        long[] newArray = new long[array.length];
        if (ArrayUtil.isEmpty((int[])array)) {
            return newArray;
        }
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = array[i];
        }
        return newArray;
    }

    public static long[] toLongArray(double[] array) {
        long[] newArray = new long[array.length];
        if (ArrayUtil.isEmpty((double[])array)) {
            return newArray;
        }
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = (long)array[i];
        }
        return newArray;
    }

    public static long[] toLongArray(float[] array) {
        long[] newArray = new long[array.length];
        if (ArrayUtil.isEmpty((float[])array)) {
            return newArray;
        }
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = (long)array[i];
        }
        return newArray;
    }

    public static long[] toLongArray(short[] array) {
        long[] newArray = new long[array.length];
        if (ArrayUtil.isEmpty((short[])array)) {
            return newArray;
        }
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = array[i];
        }
        return newArray;
    }

    public static long[] toLongArray(byte[] array) {
        long[] newArray = new long[array.length];
        if (ArrayUtil.isEmpty((byte[])array)) {
            return newArray;
        }
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = array[i];
        }
        return newArray;
    }

    public static long[] toLongArray(char[] array) {
        long[] newArray = new long[array.length];
        if (ArrayUtil.isEmpty((char[])array)) {
            return newArray;
        }
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = array[i];
        }
        return newArray;
    }

    public static long[] toLongArray(Object[] array) {
        long[] newArray = new long[array.length];
        if (ArrayUtil.isEmpty((Object[])array)) {
            return newArray;
        }
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = (Long)array[i];
        }
        return newArray;
    }

    public static short[] toShortArray(String[] array) {
        short[] newArray = new short[array.length];
        if (ArrayUtil.isEmpty((Object[])array)) {
            return newArray;
        }
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = Short.valueOf(array[i]);
        }
        return newArray;
    }

    public static short[] toShortArray(int[] array) {
        short[] newArray = new short[array.length];
        if (ArrayUtil.isEmpty((int[])array)) {
            return newArray;
        }
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = (short)array[i];
        }
        return newArray;
    }

    public static short[] toShortArray(double[] array) {
        short[] newArray = new short[array.length];
        if (ArrayUtil.isEmpty((double[])array)) {
            return newArray;
        }
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = (short)array[i];
        }
        return newArray;
    }

    public static short[] toShortArray(float[] array) {
        short[] newArray = new short[array.length];
        if (ArrayUtil.isEmpty((float[])array)) {
            return newArray;
        }
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = (short)array[i];
        }
        return newArray;
    }

    public static short[] toShortArray(long[] array) {
        short[] newArray = new short[array.length];
        if (ArrayUtil.isEmpty((long[])array)) {
            return newArray;
        }
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = (short)array[i];
        }
        return newArray;
    }

    public static short[] toShortArray(byte[] array) {
        short[] newArray = new short[array.length];
        if (ArrayUtil.isEmpty((byte[])array)) {
            return newArray;
        }
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = array[i];
        }
        return newArray;
    }

    public static short[] toShortArray(char[] array) {
        short[] newArray = new short[array.length];
        if (ArrayUtil.isEmpty((char[])array)) {
            return newArray;
        }
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = (short)array[i];
        }
        return newArray;
    }

    public static short[] toShortArray(Object[] array) {
        short[] newArray = new short[array.length];
        if (ArrayUtil.isEmpty((Object[])array)) {
            return newArray;
        }
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = (Short)array[i];
        }
        return newArray;
    }

    public static byte[] toByteArray(String[] array) {
        byte[] newArray = new byte[array.length];
        if (ArrayUtil.isEmpty((Object[])array)) {
            return newArray;
        }
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = Byte.valueOf(array[i]);
        }
        return newArray;
    }

    public static byte[] toByteArray(int[] array) {
        byte[] newArray = new byte[array.length];
        if (ArrayUtil.isEmpty((int[])array)) {
            return newArray;
        }
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = (byte)array[i];
        }
        return newArray;
    }

    public static byte[] toByteArray(double[] array) {
        byte[] newArray = new byte[array.length];
        if (ArrayUtil.isEmpty((double[])array)) {
            return newArray;
        }
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = (byte)array[i];
        }
        return newArray;
    }

    public static byte[] toByteArray(float[] array) {
        byte[] newArray = new byte[array.length];
        if (ArrayUtil.isEmpty((float[])array)) {
            return newArray;
        }
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = (byte)array[i];
        }
        return newArray;
    }

    public static byte[] toByteArray(long[] array) {
        byte[] newArray = new byte[array.length];
        if (ArrayUtil.isEmpty((long[])array)) {
            return newArray;
        }
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = (byte)array[i];
        }
        return newArray;
    }

    public static byte[] toByteArray(short[] array) {
        byte[] newArray = new byte[array.length];
        if (ArrayUtil.isEmpty((short[])array)) {
            return newArray;
        }
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = (byte)array[i];
        }
        return newArray;
    }

    public static byte[] toByteArray(char[] array) {
        byte[] newArray = new byte[array.length];
        if (ArrayUtil.isEmpty((char[])array)) {
            return newArray;
        }
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = (byte)array[i];
        }
        return newArray;
    }

    public static byte[] toByteArray(Object[] array) {
        byte[] newArray = new byte[array.length];
        if (ArrayUtil.isEmpty((Object[])array)) {
            return newArray;
        }
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = (Byte)array[i];
        }
        return newArray;
    }

    public static final <T> List<T> convertList(T[] array) {
        if (ArrayUtil.isEmpty((Object[])array)) {
            return null;
        }
        return Arrays.asList(array);
    }

    public static Map convertMap(Object[] array) {
        if (array == null) {
            return null;
        }
        HashMap<Object, Object> map = new HashMap<Object, Object>((int)((double)array.length * 1.5));
        for (int i = 0; i < array.length; ++i) {
            Object[] entry;
            Object object = array[i];
            if (object instanceof Map.Entry) {
                entry = (Object[])object;
                map.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (object instanceof Object[]) {
                entry = (Object[])object;
                if (entry.length < 2) {
                    throw new IllegalArgumentException("Array element " + i + ", '" + object + "', has a length less than 2");
                }
                map.put(entry[0], entry[1]);
                continue;
            }
            throw new IllegalArgumentException("Array element " + i + ", '" + object + "', is neither of type Map.Entry nor an Array");
        }
        return map;
    }

    public static <T> String join(T[] array) {
        if (array == null) {
            return "null";
        }
        int iMax = array.length - 1;
        if (iMax == -1) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        int i = 0;
        while (true) {
            sb.append(array[i]);
            if (i == iMax) {
                return sb.append(']').toString();
            }
            sb.append(", ");
            ++i;
        }
    }

    public static String join(int[] array) {
        return ArrayUtil.join(ArrayUtil.toStringArray(array));
    }

    public static String join(double[] array) {
        return ArrayUtil.join(ArrayUtil.toStringArray(array));
    }

    public static String join(float[] array) {
        return ArrayUtil.join(ArrayUtil.toStringArray(array));
    }

    public static String join(long[] array) {
        return ArrayUtil.join(ArrayUtil.toStringArray(array));
    }

    public static String join(short[] array) {
        return ArrayUtil.join(ArrayUtil.toStringArray(array));
    }

    public static String join(byte[] array) {
        return ArrayUtil.join(ArrayUtil.toStringArray(array));
    }

    public static String join(boolean[] array) {
        return ArrayUtil.join(ArrayUtil.toStringArray(array));
    }

    public static <T> String join(T[] array, String splitStr) {
        StringBuilder sb = new StringBuilder();
        if (ArrayUtil.isEmpty((Object[])array)) {
            return "";
        }
        if (array.length == 1) {
            return String.valueOf(array[0]);
        }
        int iMax = array.length - 1;
        for (int i = 0; i < array.length; ++i) {
            if (i == iMax) {
                sb.append(array[i]);
                continue;
            }
            sb.append(array[i] + splitStr);
        }
        return sb.toString();
    }

    public static String join(int[] array, String splitStr) {
        return ArrayUtil.join(ArrayUtil.toStringArray(array), splitStr);
    }

    public static String join(double[] array, String splitStr) {
        return ArrayUtil.join(ArrayUtil.toStringArray(array), splitStr);
    }

    public static String join(float[] array, String splitStr) {
        return ArrayUtil.join(ArrayUtil.toStringArray(array), splitStr);
    }

    public static String join(long[] array, String splitStr) {
        return ArrayUtil.join(ArrayUtil.toStringArray(array), splitStr);
    }

    public static String join(short[] array, String splitStr) {
        return ArrayUtil.join(ArrayUtil.toStringArray(array), splitStr);
    }

    public static String join(byte[] array, String splitStr) {
        return ArrayUtil.join(ArrayUtil.toStringArray(array), splitStr);
    }

    public static String join(boolean[] array, String splitStr) {
        return ArrayUtil.join(ArrayUtil.toStringArray(array), splitStr);
    }

    public static <T> String joinSet(Set<T> set, String splitStr) {
        Iterator<T> iterator;
        if (set == null || set.size() == 0) {
            return "";
        }
        if (set.size() == 1 && (iterator = set.iterator()).hasNext()) {
            T t = iterator.next();
            return String.valueOf(t);
        }
        StringBuilder sb = new StringBuilder();
        for (T t : set) {
            sb.append(String.valueOf(t) + splitStr);
        }
        return sb.toString().substring(0, sb.length() - 1);
    }

    public static <T> String joinList(List<T> list, String splitStr) {
        if (list == null || list.size() == 0) {
            return "";
        }
        if (list.size() == 1) {
            return String.valueOf(list.get(0));
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            if (i == list.size() - 1) {
                sb.append(String.valueOf(list.get(i)));
                continue;
            }
            sb.append(String.valueOf(list.get(i)) + splitStr);
        }
        return sb.toString();
    }

    public static int[] subArray(int[] arr, int len) {
        if (arr.length <= len) {
            return arr;
        }
        int[] newArr = new int[len];
        for (int i = 0; i < len; ++i) {
            newArr[i] = arr[i];
        }
        return newArr;
    }

    public static Object[] subArray(Object[] arr, int len) {
        if (arr.length <= len) {
            return arr;
        }
        Object[] newArr = new Object[len];
        for (int i = 0; i < len; ++i) {
            newArr[i] = arr[i];
        }
        return newArr;
    }

    public static String contact(String[] aryStr, String separator) {
        if (aryStr.length == 1) {
            return aryStr[0];
        }
        String out = "";
        for (int i = 0; i < aryStr.length; ++i) {
            out = i == 0 ? out + aryStr[i] : out + separator + aryStr[i];
        }
        return out;
    }

    public static String addQuote(String val) {
        String[] aryVal = val.split(",");
        if (aryVal.length == 1) {
            return "'" + val + "'";
        }
        String tmp = "";
        for (int i = 0; i < aryVal.length; ++i) {
            tmp = i == 0 ? tmp + "'" + aryVal[i] + "'" : tmp + ",'" + aryVal[i] + "'";
        }
        return tmp;
    }
}

